/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.airbnb.lottie.BaseLayer;
import com.airbnb.lottie.Layer;
import com.airbnb.lottie.LottieDrawable;

class ImageLayer
extends BaseLayer {
    private final Paint paint = new Paint(3);
    private final Rect src = new Rect();
    private final Rect dst = new Rect();
    private final float density;

    ImageLayer(LottieDrawable lottieDrawable, Layer layerModel, float density) {
        super(lottieDrawable, layerModel);
        this.density = density;
    }

    @Override
    public void drawLayer(@NonNull Canvas canvas, Matrix parentMatrix, int parentAlpha) {
        Bitmap bitmap = this.getBitmap();
        if (bitmap == null) {
            return;
        }
        this.paint.setAlpha(parentAlpha);
        canvas.save();
        canvas.concat(parentMatrix);
        this.src.set(0, 0, bitmap.getWidth(), bitmap.getHeight());
        this.dst.set(0, 0, (int)((float)bitmap.getWidth() * this.density), (int)((float)bitmap.getHeight() * this.density));
        canvas.drawBitmap(bitmap, this.src, this.dst, this.paint);
        canvas.restore();
    }

    @Override
    public void getBounds(RectF outBounds, Matrix parentMatrix) {
        super.getBounds(outBounds, parentMatrix);
        Bitmap bitmap = this.getBitmap();
        if (bitmap != null) {
            outBounds.set(outBounds.left, outBounds.top, Math.min(outBounds.right, (float)bitmap.getWidth()), Math.min(outBounds.bottom, (float)bitmap.getHeight()));
            this.boundsMatrix.mapRect(outBounds);
        }
    }

    @Nullable
    private Bitmap getBitmap() {
        String refId = this.layerModel.getRefId();
        return this.lottieDrawable.getImageAsset(refId);
    }

    @Override
    public void addColorFilter(@Nullable String layerName, @Nullable String contentName, @Nullable ColorFilter colorFilter) {
        this.paint.setColorFilter(colorFilter);
    }
}

