/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.RectF;
import android.support.annotation.Nullable;
import com.airbnb.lottie.BaseKeyframeAnimation;
import com.airbnb.lottie.BaseLayer;
import com.airbnb.lottie.Content;
import com.airbnb.lottie.LottieDrawable;
import com.airbnb.lottie.PathContent;
import com.airbnb.lottie.RectangleShape;
import com.airbnb.lottie.ShapeTrimPath;
import com.airbnb.lottie.TrimPathContent;
import com.airbnb.lottie.Utils;
import java.util.List;

class RectangleContent
implements PathContent,
BaseKeyframeAnimation.AnimationListener {
    private final Path path = new Path();
    private final RectF rect = new RectF();
    private final String name;
    private final LottieDrawable lottieDrawable;
    private final BaseKeyframeAnimation<?, PointF> positionAnimation;
    private final BaseKeyframeAnimation<?, PointF> sizeAnimation;
    private final BaseKeyframeAnimation<?, Float> cornerRadiusAnimation;
    @Nullable
    private TrimPathContent trimPath;
    private boolean isPathValid;

    RectangleContent(LottieDrawable lottieDrawable, BaseLayer layer, RectangleShape rectShape) {
        this.name = rectShape.getName();
        this.lottieDrawable = lottieDrawable;
        this.positionAnimation = rectShape.getPosition().createAnimation();
        this.sizeAnimation = rectShape.getSize().createAnimation();
        this.cornerRadiusAnimation = rectShape.getCornerRadius().createAnimation();
        layer.addAnimation(this.positionAnimation);
        layer.addAnimation(this.sizeAnimation);
        layer.addAnimation(this.cornerRadiusAnimation);
        this.positionAnimation.addUpdateListener(this);
        this.sizeAnimation.addUpdateListener(this);
        this.cornerRadiusAnimation.addUpdateListener(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void onValueChanged() {
        this.invalidate();
    }

    private void invalidate() {
        this.isPathValid = false;
        this.lottieDrawable.invalidateSelf();
    }

    @Override
    public void setContents(List<Content> contentsBefore, List<Content> contentsAfter) {
        for (int i = 0; i < contentsBefore.size(); ++i) {
            Content content = contentsBefore.get(i);
            if (!(content instanceof TrimPathContent) || ((TrimPathContent)content).getType() != ShapeTrimPath.Type.Simultaneously) continue;
            this.trimPath = (TrimPathContent)content;
            this.trimPath.addListener(this);
        }
    }

    @Override
    public Path getPath() {
        if (this.isPathValid) {
            return this.path;
        }
        this.path.reset();
        PointF size = this.sizeAnimation.getValue();
        float halfWidth = size.x / 2.0f;
        float halfHeight = size.y / 2.0f;
        float radius = this.cornerRadiusAnimation == null ? 0.0f : this.cornerRadiusAnimation.getValue().floatValue();
        float maxRadius = Math.min(halfWidth, halfHeight);
        if (radius > maxRadius) {
            radius = maxRadius;
        }
        PointF position = this.positionAnimation.getValue();
        this.path.moveTo(position.x + halfWidth, position.y - halfHeight + radius);
        this.path.lineTo(position.x + halfWidth, position.y + halfHeight - radius);
        if (radius > 0.0f) {
            this.rect.set(position.x + halfWidth - 2.0f * radius, position.y + halfHeight - 2.0f * radius, position.x + halfWidth, position.y + halfHeight);
            this.path.arcTo(this.rect, 0.0f, 90.0f, false);
        }
        this.path.lineTo(position.x - halfWidth + radius, position.y + halfHeight);
        if (radius > 0.0f) {
            this.rect.set(position.x - halfWidth, position.y + halfHeight - 2.0f * radius, position.x - halfWidth + 2.0f * radius, position.y + halfHeight);
            this.path.arcTo(this.rect, 90.0f, 90.0f, false);
        }
        this.path.lineTo(position.x - halfWidth, position.y - halfHeight + radius);
        if (radius > 0.0f) {
            this.rect.set(position.x - halfWidth, position.y - halfHeight, position.x - halfWidth + 2.0f * radius, position.y - halfHeight + 2.0f * radius);
            this.path.arcTo(this.rect, 180.0f, 90.0f, false);
        }
        this.path.lineTo(position.x + halfWidth - radius, position.y - halfHeight);
        if (radius > 0.0f) {
            this.rect.set(position.x + halfWidth - 2.0f * radius, position.y - halfHeight, position.x + halfWidth, position.y - halfHeight + 2.0f * radius);
            this.path.arcTo(this.rect, 270.0f, 90.0f, false);
        }
        this.path.close();
        Utils.applyTrimPathIfNeeded(this.path, this.trimPath);
        this.isPathValid = true;
        return this.path;
    }
}

