/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.graphics.PointF;
import com.airbnb.lottie.AnimatableFloatValue;
import com.airbnb.lottie.AnimatablePathValue;
import com.airbnb.lottie.AnimatablePointValue;
import com.airbnb.lottie.AnimatableValue;
import com.airbnb.lottie.BaseLayer;
import com.airbnb.lottie.Content;
import com.airbnb.lottie.ContentModel;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.LottieDrawable;
import com.airbnb.lottie.RectangleContent;
import org.json.JSONObject;

class RectangleShape
implements ContentModel {
    private final String name;
    private final AnimatableValue<PointF> position;
    private final AnimatablePointValue size;
    private final AnimatableFloatValue cornerRadius;

    private RectangleShape(String name, AnimatableValue<PointF> position, AnimatablePointValue size, AnimatableFloatValue cornerRadius) {
        this.name = name;
        this.position = position;
        this.size = size;
        this.cornerRadius = cornerRadius;
    }

    String getName() {
        return this.name;
    }

    AnimatableFloatValue getCornerRadius() {
        return this.cornerRadius;
    }

    AnimatablePointValue getSize() {
        return this.size;
    }

    AnimatableValue<PointF> getPosition() {
        return this.position;
    }

    @Override
    public Content toContent(LottieDrawable drawable, BaseLayer layer) {
        return new RectangleContent(drawable, layer, this);
    }

    public String toString() {
        return "RectangleShape{cornerRadius=" + this.cornerRadius.getInitialValue() + ", position=" + this.position + ", size=" + this.size + '}';
    }

    static class Factory {
        private Factory() {
        }

        static RectangleShape newInstance(JSONObject json, LottieComposition composition) {
            return new RectangleShape(json.optString("nm"), AnimatablePathValue.createAnimatablePathOrSplitDimensionPath(json.optJSONObject("p"), composition), AnimatablePointValue.Factory.newInstance(json.optJSONObject("s"), composition), AnimatableFloatValue.Factory.newInstance(json.optJSONObject("r"), composition));
        }
    }
}

