/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.graphics.Bitmap;
import android.support.v4.util.LongSparseArray;
import com.airbnb.lottie.BitmapCanvas;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class CanvasPool {
    private final LongSparseArray<List<Bitmap>> availableBitmaps = new LongSparseArray();
    private final Map<BitmapCanvas, Bitmap> canvasBitmapMap = new HashMap<BitmapCanvas, Bitmap>();
    private final Map<Bitmap, BitmapCanvas> bitmapCanvasMap = new HashMap<Bitmap, BitmapCanvas>();

    CanvasPool() {
    }

    BitmapCanvas acquire(int width, int height, Bitmap.Config config) {
        BitmapCanvas canvas;
        int key = this.getKey(width, height, config);
        ArrayList bitmaps = (ArrayList)this.availableBitmaps.get((long)key);
        if (bitmaps == null) {
            bitmaps = new ArrayList();
            this.availableBitmaps.put((long)key, bitmaps);
        }
        if (bitmaps.isEmpty()) {
            Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config);
            canvas = new BitmapCanvas(bitmap);
            this.canvasBitmapMap.put(canvas, bitmap);
            this.bitmapCanvasMap.put(bitmap, canvas);
        } else {
            Bitmap bitmap = (Bitmap)bitmaps.remove(0);
            canvas = this.bitmapCanvasMap.get(bitmap);
        }
        canvas.getBitmap().eraseColor(0);
        return canvas;
    }

    void release(BitmapCanvas canvas) {
        Bitmap bitmap = this.canvasBitmapMap.get((Object)canvas);
        int key = this.getKey(bitmap);
        List bitmaps = (List)this.availableBitmaps.get((long)key);
        if (bitmaps.contains(bitmap)) {
            throw new IllegalStateException("Canvas already released.");
        }
        bitmaps.add(bitmap);
    }

    void recycleBitmaps() {
        for (int i = 0; i < this.availableBitmaps.size(); ++i) {
            List bitmaps = (List)this.availableBitmaps.valueAt(i);
            Iterator it = bitmaps.iterator();
            while (it.hasNext()) {
                Bitmap bitmap = (Bitmap)it.next();
                BitmapCanvas canvas = this.bitmapCanvasMap.get(bitmap);
                this.bitmapCanvasMap.remove(bitmap);
                this.canvasBitmapMap.remove((Object)canvas);
                bitmap.recycle();
                it.remove();
            }
        }
        if (!this.bitmapCanvasMap.isEmpty()) {
            throw new IllegalStateException("Not all canvases have been released!");
        }
    }

    private int getKey(Bitmap bitmap) {
        return this.getKey(bitmap.getWidth(), bitmap.getHeight(), bitmap.getConfig());
    }

    private int getKey(int width, int height, Bitmap.Config config) {
        return (width & 0xFFFF) << 17 | (height & 0xFFFF) << 1 | config.ordinal() & 1;
    }
}

