/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.graphics.PointF;
import org.json.JSONArray;
import org.json.JSONObject;

class JsonUtils {
    private JsonUtils() {
    }

    static PointF pointFromJsonObject(JSONObject values, float scale) {
        return new PointF(JsonUtils.valueFromObject(values.opt("x")) * scale, JsonUtils.valueFromObject(values.opt("y")) * scale);
    }

    static PointF pointFromJsonArray(JSONArray values, float scale) {
        if (values.length() < 2) {
            throw new IllegalArgumentException("Unable to parse point for " + values);
        }
        return new PointF((float)values.optDouble(0, 1.0) * scale, (float)values.optDouble(1, 1.0) * scale);
    }

    static float valueFromObject(Object object) {
        if (object instanceof Float) {
            return ((Float)object).floatValue();
        }
        if (object instanceof Integer) {
            return ((Integer)object).intValue();
        }
        if (object instanceof Double) {
            return (float)((Double)object).doubleValue();
        }
        if (object instanceof JSONArray) {
            return (float)((JSONArray)object).optDouble(0);
        }
        return 0.0f;
    }
}

