/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Rect;
import android.os.AsyncTask;
import android.support.annotation.Nullable;
import android.support.v4.util.LongSparseArray;
import android.support.v4.util.SparseArrayCompat;
import android.util.Log;
import com.airbnb.lottie.Cancellable;
import com.airbnb.lottie.FileCompositionLoader;
import com.airbnb.lottie.Font;
import com.airbnb.lottie.FontCharacter;
import com.airbnb.lottie.JsonCompositionLoader;
import com.airbnb.lottie.Layer;
import com.airbnb.lottie.LottieImageAsset;
import com.airbnb.lottie.OnCompositionLoadedListener;
import com.airbnb.lottie.PerformanceTracker;
import com.airbnb.lottie.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LottieComposition {
    private final Map<String, List<Layer>> precomps = new HashMap<String, List<Layer>>();
    private final Map<String, LottieImageAsset> images = new HashMap<String, LottieImageAsset>();
    private final Map<String, Font> fonts = new HashMap<String, Font>();
    private final SparseArrayCompat<FontCharacter> characters = new SparseArrayCompat();
    private final LongSparseArray<Layer> layerMap = new LongSparseArray();
    private final List<Layer> layers = new ArrayList<Layer>();
    private final HashSet<String> warnings = new HashSet();
    private final PerformanceTracker performanceTracker = new PerformanceTracker();
    private final Rect bounds;
    private final long startFrame;
    private final long endFrame;
    private final float frameRate;
    private final float dpScale;
    private final int majorVersion;
    private final int minorVersion;
    private final int patchVersion;

    private LottieComposition(Rect bounds, long startFrame, long endFrame, float frameRate, float dpScale, int major, int minor, int patch) {
        this.bounds = bounds;
        this.startFrame = startFrame;
        this.endFrame = endFrame;
        this.frameRate = frameRate;
        this.dpScale = dpScale;
        this.majorVersion = major;
        this.minorVersion = minor;
        this.patchVersion = patch;
        if (!Utils.isAtLeastVersion(this, 4, 5, 0)) {
            this.addWarning("Lottie only supports bodymovin >= 4.5.0");
        }
    }

    void addWarning(String warning) {
        Log.w((String)"LOTTIE", (String)warning);
        this.warnings.add(warning);
    }

    public ArrayList<String> getWarnings() {
        return new ArrayList<String>(Arrays.asList(this.warnings.toArray(new String[this.warnings.size()])));
    }

    public void setPerformanceTrackingEnabled(boolean enabled) {
        this.performanceTracker.setEnabled(enabled);
    }

    public PerformanceTracker getPerformanceTracker() {
        return this.performanceTracker;
    }

    Layer layerModelForId(long id) {
        return (Layer)this.layerMap.get(id);
    }

    public Rect getBounds() {
        return this.bounds;
    }

    public long getDuration() {
        long frameDuration = this.endFrame - this.startFrame;
        return (long)((float)frameDuration / this.frameRate * 1000.0f);
    }

    int getMajorVersion() {
        return this.majorVersion;
    }

    int getMinorVersion() {
        return this.minorVersion;
    }

    int getPatchVersion() {
        return this.patchVersion;
    }

    long getStartFrame() {
        return this.startFrame;
    }

    long getEndFrame() {
        return this.endFrame;
    }

    List<Layer> getLayers() {
        return this.layers;
    }

    @Nullable
    List<Layer> getPrecomps(String id) {
        return this.precomps.get(id);
    }

    SparseArrayCompat<FontCharacter> getCharacters() {
        return this.characters;
    }

    Map<String, Font> getFonts() {
        return this.fonts;
    }

    public boolean hasImages() {
        return !this.images.isEmpty();
    }

    Map<String, LottieImageAsset> getImages() {
        return this.images;
    }

    float getDurationFrames() {
        return (float)this.getDuration() * this.frameRate / 1000.0f;
    }

    float getDpScale() {
        return this.dpScale;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("LottieComposition:\n");
        for (Layer layer : this.layers) {
            sb.append(layer.toString("\t"));
        }
        return sb.toString();
    }

    public static class Factory {
        private Factory() {
        }

        public static Cancellable fromAssetFileName(Context context, String fileName, OnCompositionLoadedListener loadedListener) {
            InputStream stream;
            try {
                stream = context.getAssets().open(fileName);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to find file " + fileName, e);
            }
            return Factory.fromInputStream(context, stream, loadedListener);
        }

        public static Cancellable fromInputStream(Context context, InputStream stream, OnCompositionLoadedListener loadedListener) {
            FileCompositionLoader loader = new FileCompositionLoader(context.getResources(), loadedListener);
            loader.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new InputStream[]{stream});
            return loader;
        }

        public static LottieComposition fromFileSync(Context context, String fileName) {
            InputStream stream;
            try {
                stream = context.getAssets().open(fileName);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to find file " + fileName, e);
            }
            return Factory.fromInputStream(context.getResources(), stream);
        }

        public static Cancellable fromJson(Resources res, JSONObject json, OnCompositionLoadedListener loadedListener) {
            JsonCompositionLoader loader = new JsonCompositionLoader(res, loadedListener);
            loader.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new JSONObject[]{json});
            return loader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        static LottieComposition fromInputStream(Resources res, InputStream stream) {
            try {
                int size = stream.available();
                byte[] buffer = new byte[size];
                stream.read(buffer);
                String json = new String(buffer, "UTF-8");
                JSONObject jsonObject = new JSONObject(json);
                LottieComposition lottieComposition = Factory.fromJsonSync(res, jsonObject);
                return lottieComposition;
            }
            catch (IOException e) {
                Log.e((String)"LOTTIE", (String)"Failed to load composition.", (Throwable)new IllegalStateException("Unable to find file.", e));
            }
            catch (JSONException e) {
                Log.e((String)"LOTTIE", (String)"Failed to load composition.", (Throwable)new IllegalStateException("Unable to load JSON.", e));
            }
            finally {
                Utils.closeQuietly(stream);
            }
            return null;
        }

        static LottieComposition fromJsonSync(Resources res, JSONObject json) {
            Rect bounds = null;
            float scale = res.getDisplayMetrics().density;
            int width = json.optInt("w", -1);
            int height = json.optInt("h", -1);
            if (width != -1 && height != -1) {
                int scaledWidth = (int)((float)width * scale);
                int scaledHeight = (int)((float)height * scale);
                bounds = new Rect(0, 0, scaledWidth, scaledHeight);
            }
            long startFrame = json.optLong("ip", 0L);
            long endFrame = json.optLong("op", 0L);
            float frameRate = (float)json.optDouble("fr", 0.0);
            String version = json.optString("v");
            String[] versions = version.split("[.]");
            int major = Integer.parseInt(versions[0]);
            int minor = Integer.parseInt(versions[1]);
            int patch = Integer.parseInt(versions[2]);
            LottieComposition composition = new LottieComposition(bounds, startFrame, endFrame, frameRate, scale, major, minor, patch);
            JSONArray assetsJson = json.optJSONArray("assets");
            Factory.parseImages(assetsJson, composition);
            Factory.parsePrecomps(assetsJson, composition);
            Factory.parseFonts(json.optJSONObject("fonts"), composition);
            Factory.parseChars(json.optJSONArray("chars"), composition);
            Factory.parseLayers(json, composition);
            return composition;
        }

        private static void parseLayers(JSONObject json, LottieComposition composition) {
            JSONArray jsonLayers = json.optJSONArray("layers");
            if (jsonLayers == null) {
                return;
            }
            int length = jsonLayers.length();
            int imageCount = 0;
            for (int i = 0; i < length; ++i) {
                Layer layer = Layer.Factory.newInstance(jsonLayers.optJSONObject(i), composition);
                if (layer.getLayerType() == Layer.LayerType.Image) {
                    ++imageCount;
                }
                Factory.addLayer(composition.layers, (LongSparseArray<Layer>)composition.layerMap, layer);
            }
            if (imageCount > 4) {
                composition.addWarning("You have " + imageCount + " images. Lottie should primarily be " + "used with shapes. If you are using Adobe Illustrator, convert the Illustrator layers" + " to shape layers.");
            }
        }

        private static void parsePrecomps(@Nullable JSONArray assetsJson, LottieComposition composition) {
            if (assetsJson == null) {
                return;
            }
            int length = assetsJson.length();
            for (int i = 0; i < length; ++i) {
                JSONObject assetJson = assetsJson.optJSONObject(i);
                JSONArray layersJson = assetJson.optJSONArray("layers");
                if (layersJson == null) continue;
                ArrayList<Layer> layers = new ArrayList<Layer>(layersJson.length());
                LongSparseArray layerMap = new LongSparseArray();
                for (int j = 0; j < layersJson.length(); ++j) {
                    Layer layer = Layer.Factory.newInstance(layersJson.optJSONObject(j), composition);
                    layerMap.put(layer.getId(), (Object)layer);
                    layers.add(layer);
                }
                String id = assetJson.optString("id");
                composition.precomps.put(id, layers);
            }
        }

        private static void parseImages(@Nullable JSONArray assetsJson, LottieComposition composition) {
            if (assetsJson == null) {
                return;
            }
            int length = assetsJson.length();
            for (int i = 0; i < length; ++i) {
                JSONObject assetJson = assetsJson.optJSONObject(i);
                if (!assetJson.has("p")) continue;
                LottieImageAsset image = LottieImageAsset.Factory.newInstance(assetJson);
                composition.images.put(image.getId(), image);
            }
        }

        private static void parseFonts(@Nullable JSONObject fonts, LottieComposition composition) {
            if (fonts == null) {
                return;
            }
            JSONArray fontsList = fonts.optJSONArray("list");
            if (fontsList == null) {
                return;
            }
            int length = fontsList.length();
            for (int i = 0; i < length; ++i) {
                Font font = Font.Factory.newInstance(fontsList.optJSONObject(i));
                composition.fonts.put(font.getName(), font);
            }
        }

        private static void parseChars(@Nullable JSONArray charsJson, LottieComposition composition) {
            if (charsJson == null) {
                return;
            }
            int length = charsJson.length();
            for (int i = 0; i < length; ++i) {
                FontCharacter character = FontCharacter.Factory.newInstance(charsJson.optJSONObject(i), composition);
                composition.characters.put(character.hashCode(), (Object)character);
            }
        }

        private static void addLayer(List<Layer> layers, LongSparseArray<Layer> layerMap, Layer layer) {
            layers.add(layer);
            layerMap.put(layer.getId(), (Object)layer);
        }
    }
}

