/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.support.annotation.Nullable;
import com.airbnb.lottie.AnimatableTextProperties;
import com.airbnb.lottie.BaseLayer;
import com.airbnb.lottie.ContentGroup;
import com.airbnb.lottie.DocumentData;
import com.airbnb.lottie.Font;
import com.airbnb.lottie.FontCharacter;
import com.airbnb.lottie.KeyframeAnimation;
import com.airbnb.lottie.Layer;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.LottieDrawable;
import com.airbnb.lottie.ShapeGroup;
import com.airbnb.lottie.TextDelegate;
import com.airbnb.lottie.TextKeyframeAnimation;
import com.airbnb.lottie.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class TextLayer
extends BaseLayer {
    private final char[] tempCharArray = new char[1];
    private final RectF rectF = new RectF();
    private final Matrix matrix = new Matrix();
    private final Paint fillPaint = new Paint(1){
        {
            this.setStyle(Paint.Style.FILL);
        }
    };
    private final Paint strokePaint = new Paint(1){
        {
            this.setStyle(Paint.Style.STROKE);
        }
    };
    private final Map<FontCharacter, List<ContentGroup>> contentsForCharacter = new HashMap<FontCharacter, List<ContentGroup>>();
    private final TextKeyframeAnimation textAnimation;
    private final LottieDrawable lottieDrawable;
    private final LottieComposition composition;
    @Nullable
    private KeyframeAnimation<Integer> colorAnimation;
    @Nullable
    private KeyframeAnimation<Integer> strokeAnimation;
    @Nullable
    private KeyframeAnimation<Float> strokeWidthAnimation;
    @Nullable
    private KeyframeAnimation<Float> trackingAnimation;

    TextLayer(LottieDrawable lottieDrawable, Layer layerModel) {
        super(lottieDrawable, layerModel);
        this.lottieDrawable = lottieDrawable;
        this.composition = layerModel.getComposition();
        this.textAnimation = layerModel.getText().createAnimation();
        this.textAnimation.addUpdateListener(this);
        this.addAnimation(this.textAnimation);
        AnimatableTextProperties textProperties = layerModel.getTextProperties();
        if (textProperties != null && textProperties.color != null) {
            this.colorAnimation = textProperties.color.createAnimation();
            this.colorAnimation.addUpdateListener(this);
            this.addAnimation(this.colorAnimation);
        }
        if (textProperties != null && textProperties.stroke != null) {
            this.strokeAnimation = textProperties.stroke.createAnimation();
            this.strokeAnimation.addUpdateListener(this);
            this.addAnimation(this.strokeAnimation);
        }
        if (textProperties != null && textProperties.strokeWidth != null) {
            this.strokeWidthAnimation = textProperties.strokeWidth.createAnimation();
            this.strokeWidthAnimation.addUpdateListener(this);
            this.addAnimation(this.strokeWidthAnimation);
        }
        if (textProperties != null && textProperties.tracking != null) {
            this.trackingAnimation = textProperties.tracking.createAnimation();
            this.trackingAnimation.addUpdateListener(this);
            this.addAnimation(this.trackingAnimation);
        }
    }

    @Override
    void drawLayer(Canvas canvas, Matrix parentMatrix, int parentAlpha) {
        canvas.save();
        if (!this.lottieDrawable.useTextGlyphs()) {
            canvas.setMatrix(parentMatrix);
        }
        DocumentData documentData = (DocumentData)this.textAnimation.getValue();
        Font font = this.composition.getFonts().get(documentData.fontName);
        if (font == null) {
            return;
        }
        if (this.colorAnimation != null) {
            this.fillPaint.setColor(((Integer)this.colorAnimation.getValue()).intValue());
        } else {
            this.fillPaint.setColor(documentData.color);
        }
        if (this.strokeAnimation != null) {
            this.strokePaint.setColor(((Integer)this.strokeAnimation.getValue()).intValue());
        } else {
            this.strokePaint.setColor(documentData.strokeColor);
        }
        if (this.strokeWidthAnimation != null) {
            this.strokePaint.setStrokeWidth(((Float)this.strokeWidthAnimation.getValue()).floatValue());
        } else {
            float parentScale = Utils.getScale(parentMatrix);
            this.strokePaint.setStrokeWidth((float)documentData.strokeWidth * this.composition.getDpScale() * parentScale);
        }
        if (this.lottieDrawable.useTextGlyphs()) {
            this.drawTextGlyphs(documentData, parentMatrix, font, canvas);
        } else {
            this.drawTextWithFont(documentData, font, parentMatrix, canvas);
        }
        canvas.restore();
    }

    private void drawTextGlyphs(DocumentData documentData, Matrix parentMatrix, Font font, Canvas canvas) {
        float fontScale = (float)documentData.size / 100.0f;
        float parentScale = Utils.getScale(parentMatrix);
        String text = documentData.text;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            int characterHash = FontCharacter.hashFor(c, font.getFamily(), font.getStyle());
            FontCharacter character = (FontCharacter)this.composition.getCharacters().get(characterHash);
            if (character == null) continue;
            this.drawCharacterAsGlyph(character, parentMatrix, fontScale, documentData, canvas);
            float tx = (float)character.getWidth() * fontScale * this.composition.getDpScale() * parentScale;
            float tracking = (float)documentData.tracking / 10.0f;
            if (this.trackingAnimation != null) {
                tracking += ((Float)this.trackingAnimation.getValue()).floatValue();
            }
            canvas.translate(tx += tracking * parentScale, 0.0f);
        }
    }

    private void drawTextWithFont(DocumentData documentData, Font font, Matrix parentMatrix, Canvas canvas) {
        float parentScale = Utils.getScale(parentMatrix);
        Typeface typeface = this.lottieDrawable.getTypeface(font.getFamily(), font.getStyle());
        if (typeface == null) {
            return;
        }
        String text = documentData.text;
        TextDelegate textDelegate = this.lottieDrawable.getTextDelegate();
        if (textDelegate != null) {
            text = textDelegate.getTextInternal(text);
        }
        this.fillPaint.setTypeface(typeface);
        this.fillPaint.setTextSize((float)documentData.size * this.composition.getDpScale());
        this.strokePaint.setTypeface(this.fillPaint.getTypeface());
        this.strokePaint.setTextSize(this.fillPaint.getTextSize());
        for (int i = 0; i < text.length(); ++i) {
            char character = text.charAt(i);
            this.drawCharacterFromFont(character, documentData, canvas);
            this.tempCharArray[0] = character;
            float charWidth = this.fillPaint.measureText(this.tempCharArray, 0, 1);
            float tracking = (float)documentData.tracking / 10.0f;
            if (this.trackingAnimation != null) {
                tracking += ((Float)this.trackingAnimation.getValue()).floatValue();
            }
            float tx = charWidth + tracking * parentScale;
            canvas.translate(tx, 0.0f);
        }
    }

    private void drawCharacterAsGlyph(FontCharacter character, Matrix parentMatrix, float fontScale, DocumentData documentData, Canvas canvas) {
        List<ContentGroup> contentGroups = this.getContentsForCharacter(character);
        for (int j = 0; j < contentGroups.size(); ++j) {
            Path path = contentGroups.get(j).getPath();
            path.computeBounds(this.rectF, false);
            this.matrix.set(parentMatrix);
            this.matrix.preScale(fontScale, fontScale);
            path.transform(this.matrix);
            if (documentData.strokeOverFill) {
                this.drawGlyph(path, this.fillPaint, canvas);
                this.drawGlyph(path, this.strokePaint, canvas);
                continue;
            }
            this.drawGlyph(path, this.strokePaint, canvas);
            this.drawGlyph(path, this.fillPaint, canvas);
        }
    }

    private void drawGlyph(Path path, Paint paint, Canvas canvas) {
        if (paint.getColor() == 0) {
            return;
        }
        if (paint.getStyle() == Paint.Style.STROKE && paint.getStrokeWidth() == 0.0f) {
            return;
        }
        canvas.drawPath(path, paint);
    }

    private void drawCharacterFromFont(char c, DocumentData documentData, Canvas canvas) {
        this.tempCharArray[0] = c;
        if (documentData.strokeOverFill) {
            this.drawCharacter(this.tempCharArray, this.fillPaint, canvas);
            this.drawCharacter(this.tempCharArray, this.strokePaint, canvas);
        } else {
            this.drawCharacter(this.tempCharArray, this.strokePaint, canvas);
            this.drawCharacter(this.tempCharArray, this.fillPaint, canvas);
        }
    }

    private void drawCharacter(char[] character, Paint paint, Canvas canvas) {
        canvas.drawText(character, 0, 1, 0.0f, 0.0f, paint);
    }

    private List<ContentGroup> getContentsForCharacter(FontCharacter character) {
        if (this.contentsForCharacter.containsKey(character)) {
            return this.contentsForCharacter.get(character);
        }
        List<ShapeGroup> shapes = character.getShapes();
        int size = shapes.size();
        ArrayList<ContentGroup> contents = new ArrayList<ContentGroup>(size);
        for (int i = 0; i < size; ++i) {
            ShapeGroup sg = shapes.get(i);
            contents.add(new ContentGroup(this.lottieDrawable, this, sg));
        }
        this.contentsForCharacter.put(character, contents);
        return contents;
    }
}

