/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.graphics.Color;
import android.support.annotation.ColorInt;
import org.json.JSONArray;
import org.json.JSONObject;

class DocumentData {
    String text;
    String fontName;
    int size;
    int justification;
    int tracking;
    double lineHeight;
    @ColorInt
    int color;
    @ColorInt
    int strokeColor;
    int strokeWidth;
    boolean strokeOverFill;

    DocumentData(String text, String fontName, int size, int justification, int tracking, double lineHeight, @ColorInt int color, @ColorInt int strokeColor, int strokeWidth, boolean strokeOverFill) {
        this.text = text;
        this.fontName = fontName;
        this.size = size;
        this.justification = justification;
        this.tracking = tracking;
        this.lineHeight = lineHeight;
        this.color = color;
        this.strokeColor = strokeColor;
        this.strokeWidth = strokeWidth;
        this.strokeOverFill = strokeOverFill;
    }

    void set(DocumentData documentData) {
        this.text = documentData.text;
        this.fontName = documentData.fontName;
        this.size = documentData.size;
        this.justification = documentData.justification;
        this.tracking = documentData.tracking;
        this.lineHeight = documentData.lineHeight;
        this.color = documentData.color;
    }

    public int hashCode() {
        int result = this.text.hashCode();
        result = 31 * result + this.fontName.hashCode();
        result = 31 * result + this.size;
        result = 31 * result + this.justification;
        result = 31 * result + this.tracking;
        long temp = Double.doubleToLongBits(this.lineHeight);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.color;
        return result;
    }

    static final class Factory {
        private Factory() {
        }

        static DocumentData newInstance(JSONObject json) {
            String text = json.optString("t");
            String fontName = json.optString("f");
            int size = json.optInt("s");
            int justification = json.optInt("j");
            int tracking = json.optInt("tr");
            double lineHeight = json.optDouble("lh");
            JSONArray colorArray = json.optJSONArray("fc");
            int color = Color.argb((int)255, (int)((int)(colorArray.optDouble(0) * 255.0)), (int)((int)(colorArray.optDouble(1) * 255.0)), (int)((int)(colorArray.optDouble(2) * 255.0)));
            JSONArray strokeArray = json.optJSONArray("sc");
            int strokeColor = 0;
            if (strokeArray != null) {
                strokeColor = Color.argb((int)255, (int)((int)(strokeArray.optDouble(0) * 255.0)), (int)((int)(strokeArray.optDouble(1) * 255.0)), (int)((int)(strokeArray.optDouble(2) * 255.0)));
            }
            int strokeWidth = json.optInt("sw");
            boolean strokeOverFill = json.optBoolean("of");
            return new DocumentData(text, fontName, size, justification, tracking, lineHeight, color, strokeColor, strokeWidth, strokeOverFill);
        }
    }
}

