/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

class GammaEvaluator {
    GammaEvaluator() {
    }

    private static float OECF_sRGB(float linear) {
        return linear <= 0.0031308f ? linear * 12.92f : (float)(Math.pow(linear, 0.4166666567325592) * (double)1.055f - (double)0.055f);
    }

    private static float EOCF_sRGB(float srgb) {
        return srgb <= 0.04045f ? srgb / 12.92f : (float)Math.pow((srgb + 0.055f) / 1.055f, 2.4f);
    }

    static int evaluate(float fraction, int startInt, int endInt) {
        float startA = (float)(startInt >> 24 & 0xFF) / 255.0f;
        float startR = (float)(startInt >> 16 & 0xFF) / 255.0f;
        float startG = (float)(startInt >> 8 & 0xFF) / 255.0f;
        float startB = (float)(startInt & 0xFF) / 255.0f;
        float endA = (float)(endInt >> 24 & 0xFF) / 255.0f;
        float endR = (float)(endInt >> 16 & 0xFF) / 255.0f;
        float endG = (float)(endInt >> 8 & 0xFF) / 255.0f;
        float endB = (float)(endInt & 0xFF) / 255.0f;
        startR = GammaEvaluator.EOCF_sRGB(startR);
        startG = GammaEvaluator.EOCF_sRGB(startG);
        startB = GammaEvaluator.EOCF_sRGB(startB);
        endR = GammaEvaluator.EOCF_sRGB(endR);
        endG = GammaEvaluator.EOCF_sRGB(endG);
        endB = GammaEvaluator.EOCF_sRGB(endB);
        float a = startA + fraction * (endA - startA);
        float r = startR + fraction * (endR - startR);
        float g = startG + fraction * (endG - startG);
        float b = startB + fraction * (endB - startB);
        r = GammaEvaluator.OECF_sRGB(r) * 255.0f;
        g = GammaEvaluator.OECF_sRGB(g) * 255.0f;
        b = GammaEvaluator.OECF_sRGB(b) * 255.0f;
        return Math.round(a *= 255.0f) << 24 | Math.round(r) << 16 | Math.round(g) << 8 | Math.round(b);
    }
}

