/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.graphics.PointF;
import android.support.annotation.FloatRange;
import android.support.annotation.Nullable;
import android.support.v4.util.SparseArrayCompat;
import android.support.v4.view.animation.PathInterpolatorCompat;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import com.airbnb.lottie.AnimatableValue;
import com.airbnb.lottie.JsonUtils;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.MiscUtils;
import com.airbnb.lottie.Utils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

class Keyframe<T> {
    private static final float MAX_CP_VALUE = 100.0f;
    private static final Interpolator LINEAR_INTERPOLATOR = new LinearInterpolator();
    private final LottieComposition composition;
    @Nullable
    final T startValue;
    @Nullable
    final T endValue;
    @Nullable
    final Interpolator interpolator;
    final float startFrame;
    @Nullable
    Float endFrame;
    private float startProgress = Float.MIN_VALUE;
    private float endProgress = Float.MIN_VALUE;

    static void setEndFrames(List<? extends Keyframe<?>> keyframes) {
        int size = keyframes.size();
        for (int i = 0; i < size - 1; ++i) {
            keyframes.get((int)i).endFrame = Float.valueOf(keyframes.get((int)(i + 1)).startFrame);
        }
        Keyframe<?> lastKeyframe = keyframes.get(size - 1);
        if (lastKeyframe.startValue == null) {
            keyframes.remove(lastKeyframe);
        }
    }

    public Keyframe(LottieComposition composition, @Nullable T startValue, @Nullable T endValue, @Nullable Interpolator interpolator, float startFrame, @Nullable Float endFrame) {
        this.composition = composition;
        this.startValue = startValue;
        this.endValue = endValue;
        this.interpolator = interpolator;
        this.startFrame = startFrame;
        this.endFrame = endFrame;
    }

    float getStartProgress() {
        if (this.startProgress == Float.MIN_VALUE) {
            this.startProgress = (this.startFrame - (float)this.composition.getStartFrame()) / this.composition.getDurationFrames();
        }
        return this.startProgress;
    }

    float getEndProgress() {
        if (this.endProgress == Float.MIN_VALUE) {
            if (this.endFrame == null) {
                this.endProgress = 1.0f;
            } else {
                float startProgress = this.getStartProgress();
                float durationFrames = this.endFrame.floatValue() - this.startFrame;
                float durationProgress = durationFrames / this.composition.getDurationFrames();
                this.endProgress = startProgress + durationProgress;
            }
        }
        return this.endProgress;
    }

    boolean isStatic() {
        return this.interpolator == null;
    }

    boolean containsProgress(@FloatRange(from=0.0, to=1.0) float progress) {
        return progress >= this.getStartProgress() && progress <= this.getEndProgress();
    }

    public String toString() {
        return "Keyframe{startValue=" + this.startValue + ", endValue=" + this.endValue + ", startFrame=" + this.startFrame + ", endFrame=" + this.endFrame + ", interpolator=" + this.interpolator + '}';
    }

    static class Factory {
        private static final SparseArrayCompat<WeakReference<Interpolator>> pathInterpolatorCache = new SparseArrayCompat();

        private Factory() {
        }

        static <T> Keyframe<T> newInstance(JSONObject json, LottieComposition composition, float scale, AnimatableValue.Factory<T> valueFactory) {
            PointF cp1 = null;
            PointF cp2 = null;
            float startFrame = 0.0f;
            Object startValue = null;
            Object endValue = null;
            Interpolator interpolator = null;
            if (json.has("t")) {
                boolean hold;
                Object endValueJson;
                startFrame = (float)json.optDouble("t", 0.0);
                Object startValueJson = json.opt("s");
                if (startValueJson != null) {
                    startValue = valueFactory.valueFromObject(startValueJson, scale);
                }
                if ((endValueJson = json.opt("e")) != null) {
                    endValue = valueFactory.valueFromObject(endValueJson, scale);
                }
                JSONObject cp1Json = json.optJSONObject("o");
                JSONObject cp2Json = json.optJSONObject("i");
                if (cp1Json != null && cp2Json != null) {
                    cp1 = JsonUtils.pointFromJsonObject(cp1Json, scale);
                    cp2 = JsonUtils.pointFromJsonObject(cp2Json, scale);
                }
                boolean bl = hold = json.optInt("h", 0) == 1;
                if (hold) {
                    endValue = startValue;
                    interpolator = LINEAR_INTERPOLATOR;
                } else if (cp1 != null) {
                    cp1.x = MiscUtils.clamp(cp1.x, -scale, scale);
                    cp1.y = MiscUtils.clamp(cp1.y, -100.0f, 100.0f);
                    cp2.x = MiscUtils.clamp(cp2.x, -scale, scale);
                    cp2.y = MiscUtils.clamp(cp2.y, -100.0f, 100.0f);
                    int hash = Utils.hashFor(cp1.x, cp1.y, cp2.x, cp2.y);
                    WeakReference interpolatorRef = (WeakReference)pathInterpolatorCache.get(hash);
                    if (interpolatorRef != null) {
                        interpolator = (Interpolator)interpolatorRef.get();
                    }
                    if (interpolatorRef == null || interpolator == null) {
                        interpolator = PathInterpolatorCompat.create((float)(cp1.x / scale), (float)(cp1.y / scale), (float)(cp2.x / scale), (float)(cp2.y / scale));
                        pathInterpolatorCache.put(hash, new WeakReference<Interpolator>(interpolator));
                    }
                } else {
                    interpolator = LINEAR_INTERPOLATOR;
                }
            } else {
                endValue = startValue = (Object)valueFactory.valueFromObject(json, scale);
            }
            return new Keyframe<Object>(composition, startValue, endValue, interpolator, startFrame, null);
        }

        static <T> List<Keyframe<T>> parseKeyframes(JSONArray json, LottieComposition composition, float scale, AnimatableValue.Factory<T> valueFactory) {
            int length = json.length();
            if (length == 0) {
                return Collections.emptyList();
            }
            ArrayList<Keyframe<T>> keyframes = new ArrayList<Keyframe<T>>();
            for (int i = 0; i < length; ++i) {
                keyframes.add(Factory.newInstance(json.optJSONObject(i), composition, scale, valueFactory));
            }
            Keyframe.setEndFrames(keyframes);
            return keyframes;
        }
    }
}

