/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.graphics.PointF;
import com.airbnb.lottie.AnimatableFloatValue;
import com.airbnb.lottie.AnimatablePathValue;
import com.airbnb.lottie.AnimatableValue;
import com.airbnb.lottie.BaseLayer;
import com.airbnb.lottie.Content;
import com.airbnb.lottie.ContentModel;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.LottieDrawable;
import com.airbnb.lottie.PolystarContent;
import org.json.JSONObject;

class PolystarShape
implements ContentModel {
    private final String name;
    private final Type type;
    private final AnimatableFloatValue points;
    private final AnimatableValue<PointF> position;
    private final AnimatableFloatValue rotation;
    private final AnimatableFloatValue innerRadius;
    private final AnimatableFloatValue outerRadius;
    private final AnimatableFloatValue innerRoundedness;
    private final AnimatableFloatValue outerRoundedness;

    private PolystarShape(String name, Type type, AnimatableFloatValue points, AnimatableValue<PointF> position, AnimatableFloatValue rotation, AnimatableFloatValue innerRadius, AnimatableFloatValue outerRadius, AnimatableFloatValue innerRoundedness, AnimatableFloatValue outerRoundedness) {
        this.name = name;
        this.type = type;
        this.points = points;
        this.position = position;
        this.rotation = rotation;
        this.innerRadius = innerRadius;
        this.outerRadius = outerRadius;
        this.innerRoundedness = innerRoundedness;
        this.outerRoundedness = outerRoundedness;
    }

    String getName() {
        return this.name;
    }

    Type getType() {
        return this.type;
    }

    AnimatableFloatValue getPoints() {
        return this.points;
    }

    AnimatableValue<PointF> getPosition() {
        return this.position;
    }

    AnimatableFloatValue getRotation() {
        return this.rotation;
    }

    AnimatableFloatValue getInnerRadius() {
        return this.innerRadius;
    }

    AnimatableFloatValue getOuterRadius() {
        return this.outerRadius;
    }

    AnimatableFloatValue getInnerRoundedness() {
        return this.innerRoundedness;
    }

    AnimatableFloatValue getOuterRoundedness() {
        return this.outerRoundedness;
    }

    @Override
    public Content toContent(LottieDrawable drawable, BaseLayer layer) {
        return new PolystarContent(drawable, layer, this);
    }

    static class Factory {
        private Factory() {
        }

        static PolystarShape newInstance(JSONObject json, LottieComposition composition) {
            AnimatableFloatValue innerRoundedness;
            AnimatableFloatValue innerRadius;
            String name = json.optString("nm");
            Type type = Type.forValue(json.optInt("sy"));
            AnimatableFloatValue points = AnimatableFloatValue.Factory.newInstance(json.optJSONObject("pt"), composition, false);
            AnimatableValue<PointF> position = AnimatablePathValue.createAnimatablePathOrSplitDimensionPath(json.optJSONObject("p"), composition);
            AnimatableFloatValue rotation = AnimatableFloatValue.Factory.newInstance(json.optJSONObject("r"), composition, false);
            AnimatableFloatValue outerRadius = AnimatableFloatValue.Factory.newInstance(json.optJSONObject("or"), composition);
            AnimatableFloatValue outerRoundedness = AnimatableFloatValue.Factory.newInstance(json.optJSONObject("os"), composition, false);
            if (type == Type.Star) {
                innerRadius = AnimatableFloatValue.Factory.newInstance(json.optJSONObject("ir"), composition);
                innerRoundedness = AnimatableFloatValue.Factory.newInstance(json.optJSONObject("is"), composition, false);
            } else {
                innerRadius = null;
                innerRoundedness = null;
            }
            return new PolystarShape(name, type, points, position, rotation, innerRadius, outerRadius, innerRoundedness, outerRoundedness);
        }
    }

    static enum Type {
        Star(1),
        Polygon(2);

        private final int value;

        private Type(int value) {
            this.value = value;
        }

        static Type forValue(int value) {
            for (Type type : Type.values()) {
                if (type.value != value) continue;
                return type;
            }
            return null;
        }
    }
}

