/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.support.annotation.Nullable;
import android.util.Log;
import com.airbnb.lottie.AnimatableTransform;
import com.airbnb.lottie.BaseLayer;
import com.airbnb.lottie.CircleShape;
import com.airbnb.lottie.Content;
import com.airbnb.lottie.ContentGroup;
import com.airbnb.lottie.ContentModel;
import com.airbnb.lottie.GradientFill;
import com.airbnb.lottie.GradientStroke;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.LottieDrawable;
import com.airbnb.lottie.MergePaths;
import com.airbnb.lottie.PolystarShape;
import com.airbnb.lottie.RectangleShape;
import com.airbnb.lottie.Repeater;
import com.airbnb.lottie.ShapeFill;
import com.airbnb.lottie.ShapePath;
import com.airbnb.lottie.ShapeStroke;
import com.airbnb.lottie.ShapeTrimPath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

class ShapeGroup
implements ContentModel {
    private final String name;
    private final List<ContentModel> items;

    @Nullable
    static ContentModel shapeItemWithJson(JSONObject json, LottieComposition composition) {
        String type;
        switch (type = json.optString("ty")) {
            case "gr": {
                return Factory.newInstance(json, composition);
            }
            case "st": {
                return ShapeStroke.Factory.newInstance(json, composition);
            }
            case "gs": {
                return GradientStroke.Factory.newInstance(json, composition);
            }
            case "fl": {
                return ShapeFill.Factory.newInstance(json, composition);
            }
            case "gf": {
                return GradientFill.Factory.newInstance(json, composition);
            }
            case "tr": {
                return AnimatableTransform.Factory.newInstance(json, composition);
            }
            case "sh": {
                return ShapePath.Factory.newInstance(json, composition);
            }
            case "el": {
                return CircleShape.Factory.newInstance(json, composition);
            }
            case "rc": {
                return RectangleShape.Factory.newInstance(json, composition);
            }
            case "tm": {
                return ShapeTrimPath.Factory.newInstance(json, composition);
            }
            case "sr": {
                return PolystarShape.Factory.newInstance(json, composition);
            }
            case "mm": {
                return MergePaths.Factory.newInstance(json);
            }
            case "rp": {
                return Repeater.Factory.newInstance(json, composition);
            }
        }
        Log.w((String)"LOTTIE", (String)("Unknown shape type " + type));
        return null;
    }

    ShapeGroup(String name, List<ContentModel> items) {
        this.name = name;
        this.items = items;
    }

    public String getName() {
        return this.name;
    }

    List<ContentModel> getItems() {
        return this.items;
    }

    @Override
    public Content toContent(LottieDrawable drawable, BaseLayer layer) {
        return new ContentGroup(drawable, layer, this);
    }

    public String toString() {
        return "ShapeGroup{name='" + this.name + "' Shapes: " + Arrays.toString(this.items.toArray()) + '}';
    }

    static class Factory {
        private Factory() {
        }

        private static ShapeGroup newInstance(JSONObject json, LottieComposition composition) {
            JSONArray jsonItems = json.optJSONArray("it");
            String name = json.optString("nm");
            ArrayList<ContentModel> items = new ArrayList<ContentModel>();
            for (int i = 0; i < jsonItems.length(); ++i) {
                ContentModel newItem = ShapeGroup.shapeItemWithJson(jsonItems.optJSONObject(i), composition);
                if (newItem == null) continue;
                items.add(newItem);
            }
            return new ShapeGroup(name, items);
        }
    }
}

