/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.model;

import com.airbnb.lottie.model.animatable.AnimatableValue;
import org.json.JSONArray;

public class ScaleXY {
    private final float scaleX;
    private final float scaleY;

    public ScaleXY(float sx, float sy) {
        this.scaleX = sx;
        this.scaleY = sy;
    }

    public ScaleXY() {
        this(1.0f, 1.0f);
    }

    public float getScaleX() {
        return this.scaleX;
    }

    public float getScaleY() {
        return this.scaleY;
    }

    public String toString() {
        return this.getScaleX() + "x" + this.getScaleY();
    }

    public static class Factory
    implements AnimatableValue.Factory<ScaleXY> {
        public static final Factory INSTANCE = new Factory();

        private Factory() {
        }

        @Override
        public ScaleXY valueFromObject(Object object, float scale) {
            JSONArray array = (JSONArray)object;
            return new ScaleXY((float)array.optDouble(0, 1.0) / 100.0f * scale, (float)array.optDouble(1, 1.0) / 100.0f * scale);
        }
    }
}

