/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.model.animatable;

import com.airbnb.lottie.animation.Keyframe;
import com.airbnb.lottie.model.animatable.AnimatableValue;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public abstract class BaseAnimatableValue<V, O>
implements AnimatableValue<V, O> {
    final List<Keyframe<V>> keyframes;
    final V initialValue;

    BaseAnimatableValue(V initialValue) {
        this(Collections.emptyList(), initialValue);
    }

    BaseAnimatableValue(List<Keyframe<V>> keyframes, V initialValue) {
        this.keyframes = keyframes;
        this.initialValue = initialValue;
    }

    O convertType(V value) {
        return (O)value;
    }

    @Override
    public boolean hasAnimation() {
        return !this.keyframes.isEmpty();
    }

    public O getInitialValue() {
        return this.convertType(this.initialValue);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("parseInitialValue=").append(this.initialValue);
        if (!this.keyframes.isEmpty()) {
            sb.append(", values=").append(Arrays.toString(this.keyframes.toArray()));
        }
        return sb.toString();
    }
}

