/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.animation.keyframe;

import android.graphics.Matrix;
import android.graphics.PointF;
import android.support.annotation.Nullable;
import com.airbnb.lottie.animation.keyframe.BaseKeyframeAnimation;
import com.airbnb.lottie.model.ScaleXY;
import com.airbnb.lottie.model.animatable.AnimatableTransform;
import com.airbnb.lottie.model.layer.BaseLayer;

public class TransformKeyframeAnimation {
    private final Matrix matrix = new Matrix();
    private final BaseKeyframeAnimation<PointF, PointF> anchorPoint;
    private final BaseKeyframeAnimation<?, PointF> position;
    private final BaseKeyframeAnimation<ScaleXY, ScaleXY> scale;
    private final BaseKeyframeAnimation<Float, Float> rotation;
    private final BaseKeyframeAnimation<Integer, Integer> opacity;
    @Nullable
    private final BaseKeyframeAnimation<?, Float> startOpacity;
    @Nullable
    private final BaseKeyframeAnimation<?, Float> endOpacity;

    public TransformKeyframeAnimation(AnimatableTransform animatableTransform) {
        this.anchorPoint = animatableTransform.getAnchorPoint().createAnimation();
        this.position = animatableTransform.getPosition().createAnimation();
        this.scale = animatableTransform.getScale().createAnimation();
        this.rotation = animatableTransform.getRotation().createAnimation();
        this.opacity = animatableTransform.getOpacity().createAnimation();
        this.startOpacity = animatableTransform.getStartOpacity() != null ? animatableTransform.getStartOpacity().createAnimation() : null;
        this.endOpacity = animatableTransform.getEndOpacity() != null ? animatableTransform.getEndOpacity().createAnimation() : null;
    }

    public void addAnimationsToLayer(BaseLayer layer) {
        layer.addAnimation(this.anchorPoint);
        layer.addAnimation(this.position);
        layer.addAnimation(this.scale);
        layer.addAnimation(this.rotation);
        layer.addAnimation(this.opacity);
        if (this.startOpacity != null) {
            layer.addAnimation(this.startOpacity);
        }
        if (this.endOpacity != null) {
            layer.addAnimation(this.endOpacity);
        }
    }

    public void addListener(BaseKeyframeAnimation.AnimationListener listener) {
        this.anchorPoint.addUpdateListener(listener);
        this.position.addUpdateListener(listener);
        this.scale.addUpdateListener(listener);
        this.rotation.addUpdateListener(listener);
        this.opacity.addUpdateListener(listener);
        if (this.startOpacity != null) {
            this.startOpacity.addUpdateListener(listener);
        }
        if (this.endOpacity != null) {
            this.endOpacity.addUpdateListener(listener);
        }
    }

    public BaseKeyframeAnimation<?, Integer> getOpacity() {
        return this.opacity;
    }

    @Nullable
    public BaseKeyframeAnimation<?, Float> getStartOpacity() {
        return this.startOpacity;
    }

    @Nullable
    public BaseKeyframeAnimation<?, Float> getEndOpacity() {
        return this.endOpacity;
    }

    public Matrix getMatrix() {
        ScaleXY scaleTransform;
        float rotation;
        this.matrix.reset();
        PointF position = this.position.getValue();
        if (position.x != 0.0f || position.y != 0.0f) {
            this.matrix.preTranslate(position.x, position.y);
        }
        if ((rotation = this.rotation.getValue().floatValue()) != 0.0f) {
            this.matrix.preRotate(rotation);
        }
        if ((scaleTransform = this.scale.getValue()).getScaleX() != 1.0f || scaleTransform.getScaleY() != 1.0f) {
            this.matrix.preScale(scaleTransform.getScaleX(), scaleTransform.getScaleY());
        }
        PointF anchorPoint = this.anchorPoint.getValue();
        if (anchorPoint.x != 0.0f || anchorPoint.y != 0.0f) {
            this.matrix.preTranslate(-anchorPoint.x, -anchorPoint.y);
        }
        return this.matrix;
    }

    public Matrix getMatrixForRepeater(float amount) {
        PointF position = this.position.getValue();
        PointF anchorPoint = this.anchorPoint.getValue();
        ScaleXY scale = this.scale.getValue();
        float rotation = this.rotation.getValue().floatValue();
        this.matrix.reset();
        this.matrix.preTranslate(position.x * amount, position.y * amount);
        this.matrix.preScale((float)Math.pow(scale.getScaleX(), amount), (float)Math.pow(scale.getScaleY(), amount));
        this.matrix.preRotate(rotation * amount, anchorPoint.x, anchorPoint.y);
        return this.matrix;
    }
}

