/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.utils;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.support.annotation.FloatRange;

public class LottieValueAnimator
extends ValueAnimator {
    private boolean systemAnimationsAreDisabled = false;
    private boolean isReversed = false;
    private float minProgress = 0.0f;
    private float maxProgress = 1.0f;
    private long originalDuration;
    private float progress = 0.0f;

    public LottieValueAnimator() {
        this.setFloatValues(new float[]{0.0f, 1.0f});
        this.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                LottieValueAnimator.this.updateValues(LottieValueAnimator.this.minProgress, LottieValueAnimator.this.maxProgress);
            }

            public void onAnimationCancel(Animator animation) {
                LottieValueAnimator.this.updateValues(LottieValueAnimator.this.minProgress, LottieValueAnimator.this.maxProgress);
            }
        });
        this.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                if (!LottieValueAnimator.this.systemAnimationsAreDisabled) {
                    LottieValueAnimator.this.progress = ((Float)animation.getAnimatedValue()).floatValue();
                }
            }
        });
    }

    public void start() {
        if (this.systemAnimationsAreDisabled) {
            this.setProgress(this.getMaxProgress());
        } else {
            super.start();
        }
    }

    public void systemAnimationsAreDisabled() {
        this.systemAnimationsAreDisabled = true;
    }

    public ValueAnimator setDuration(long duration) {
        this.originalDuration = duration;
        this.updateValues(this.minProgress, this.maxProgress);
        return this;
    }

    public void setProgress(@FloatRange(from=0.0, to=1.0) float progress) {
        if (this.progress == progress) {
            return;
        }
        this.setProgressInternal(progress);
    }

    public void forceUpdate() {
        this.setProgressInternal(this.getProgress());
    }

    private void setProgressInternal(@FloatRange(from=0.0, to=1.0) float progress) {
        if (progress < this.minProgress) {
            progress = this.minProgress;
        } else if (progress > this.maxProgress) {
            progress = this.maxProgress;
        }
        this.progress = progress;
        if (this.getDuration() > 0L) {
            float offsetProgress = (progress - this.minProgress) / (this.maxProgress - this.minProgress);
            this.setCurrentPlayTime((long)((float)this.getDuration() * offsetProgress));
        }
    }

    public float getProgress() {
        return this.progress;
    }

    public void setIsReversed(boolean isReversed) {
        this.isReversed = isReversed;
        this.updateValues(this.minProgress, this.maxProgress);
    }

    public void setMinProgress(float minProgress) {
        this.minProgress = minProgress;
        this.updateValues(minProgress, this.maxProgress);
    }

    public void setMaxProgress(float maxProgress) {
        this.maxProgress = maxProgress;
        this.updateValues(this.minProgress, maxProgress);
    }

    public float getMinProgress() {
        return this.minProgress;
    }

    public float getMaxProgress() {
        return this.maxProgress;
    }

    public void resumeAnimation() {
        float startingProgress = this.progress;
        this.start();
        this.setProgress(startingProgress);
    }

    public void updateValues(float startProgress, float endProgress) {
        float minValue = Math.min(startProgress, endProgress);
        float maxValue = Math.max(startProgress, endProgress);
        this.setFloatValues(new float[]{this.isReversed ? maxValue : minValue, this.isReversed ? minValue : maxValue});
        super.setDuration((long)((float)this.originalDuration * (maxValue - minValue)));
        this.setProgress(this.getProgress());
    }
}

