/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.animation.content;

import android.annotation.TargetApi;
import android.graphics.Path;
import android.os.Build;
import com.airbnb.lottie.animation.content.Content;
import com.airbnb.lottie.animation.content.ContentGroup;
import com.airbnb.lottie.animation.content.GreedyContent;
import com.airbnb.lottie.animation.content.PathContent;
import com.airbnb.lottie.model.content.MergePaths;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

@TargetApi(value=19)
public class MergePathsContent
implements PathContent,
GreedyContent {
    private final Path firstPath = new Path();
    private final Path remainderPath = new Path();
    private final Path path = new Path();
    private final String name;
    private final List<PathContent> pathContents = new ArrayList<PathContent>();
    private final MergePaths mergePaths;

    public MergePathsContent(MergePaths mergePaths) {
        if (Build.VERSION.SDK_INT < 19) {
            throw new IllegalStateException("Merge paths are not supported pre-KitKat.");
        }
        this.name = mergePaths.getName();
        this.mergePaths = mergePaths;
    }

    @Override
    public void absorbContent(ListIterator<Content> contents) {
        while (contents.hasPrevious() && contents.previous() != this) {
        }
        while (contents.hasPrevious()) {
            Content content = contents.previous();
            if (!(content instanceof PathContent)) continue;
            this.pathContents.add((PathContent)content);
            contents.remove();
        }
    }

    @Override
    public void setContents(List<Content> contentsBefore, List<Content> contentsAfter) {
        for (int i = 0; i < this.pathContents.size(); ++i) {
            this.pathContents.get(i).setContents(contentsBefore, contentsAfter);
        }
    }

    @Override
    public Path getPath() {
        this.path.reset();
        switch (this.mergePaths.getMode()) {
            case Merge: {
                this.addPaths();
                break;
            }
            case Add: {
                this.opFirstPathWithRest(Path.Op.UNION);
                break;
            }
            case Subtract: {
                this.opFirstPathWithRest(Path.Op.REVERSE_DIFFERENCE);
                break;
            }
            case Intersect: {
                this.opFirstPathWithRest(Path.Op.INTERSECT);
                break;
            }
            case ExcludeIntersections: {
                this.opFirstPathWithRest(Path.Op.XOR);
            }
        }
        return this.path;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void addPaths() {
        for (int i = 0; i < this.pathContents.size(); ++i) {
            this.path.addPath(this.pathContents.get(i).getPath());
        }
    }

    @TargetApi(value=19)
    private void opFirstPathWithRest(Path.Op op) {
        this.remainderPath.reset();
        this.firstPath.reset();
        for (int i = this.pathContents.size() - 1; i >= 1; --i) {
            PathContent content = this.pathContents.get(i);
            if (content instanceof ContentGroup) {
                List<PathContent> pathList = ((ContentGroup)content).getPathList();
                for (int j = pathList.size() - 1; j >= 0; --j) {
                    Path path = pathList.get(j).getPath();
                    path.transform(((ContentGroup)content).getTransformationMatrix());
                    this.remainderPath.addPath(path);
                }
                continue;
            }
            this.remainderPath.addPath(content.getPath());
        }
        PathContent lastContent = this.pathContents.get(0);
        if (lastContent instanceof ContentGroup) {
            List<PathContent> pathList = ((ContentGroup)lastContent).getPathList();
            for (int j = 0; j < pathList.size(); ++j) {
                Path path = pathList.get(j).getPath();
                path.transform(((ContentGroup)lastContent).getTransformationMatrix());
                this.firstPath.addPath(path);
            }
        } else {
            this.firstPath.set(lastContent.getPath());
        }
        this.path.op(this.firstPath, this.remainderPath, op);
    }
}

