/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.model.animatable;

import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.animation.Keyframe;
import com.airbnb.lottie.animation.keyframe.BaseKeyframeAnimation;
import com.airbnb.lottie.animation.keyframe.IntegerKeyframeAnimation;
import com.airbnb.lottie.animation.keyframe.StaticKeyframeAnimation;
import com.airbnb.lottie.model.animatable.AnimatableValue;
import com.airbnb.lottie.model.animatable.AnimatableValueParser;
import com.airbnb.lottie.model.animatable.BaseAnimatableValue;
import com.airbnb.lottie.utils.JsonUtils;
import java.util.List;
import org.json.JSONObject;

public class AnimatableIntegerValue
extends BaseAnimatableValue<Integer, Integer> {
    private AnimatableIntegerValue() {
        super(100);
    }

    AnimatableIntegerValue(List<Keyframe<Integer>> keyframes, Integer initialValue) {
        super(keyframes, initialValue);
    }

    @Override
    public BaseKeyframeAnimation<Integer, Integer> createAnimation() {
        if (!this.hasAnimation()) {
            return new StaticKeyframeAnimation(this.initialValue);
        }
        return new IntegerKeyframeAnimation(this.keyframes);
    }

    @Override
    public Integer getInitialValue() {
        return (Integer)this.initialValue;
    }

    private static class ValueFactory
    implements AnimatableValue.Factory<Integer> {
        private static final ValueFactory INSTANCE = new ValueFactory();

        private ValueFactory() {
        }

        @Override
        public Integer valueFromObject(Object object, float scale) {
            return Math.round(JsonUtils.valueFromObject(object) * scale);
        }
    }

    public static final class Factory {
        private Factory() {
        }

        static AnimatableIntegerValue newInstance() {
            return new AnimatableIntegerValue();
        }

        public static AnimatableIntegerValue newInstance(JSONObject json, LottieComposition composition) {
            if (json != null && json.has("x")) {
                composition.addWarning("Lottie doesn't support expressions.");
            }
            AnimatableValueParser.Result<Integer> result = AnimatableValueParser.newInstance(json, 1.0f, composition, ValueFactory.INSTANCE).parseJson();
            Integer initialValue = (Integer)result.initialValue;
            return new AnimatableIntegerValue(result.keyframes, initialValue);
        }
    }
}

