/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.model.layer;

import android.annotation.SuppressLint;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.support.annotation.CallSuper;
import android.support.annotation.FloatRange;
import android.support.annotation.Nullable;
import android.util.Log;
import com.airbnb.lottie.L;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.LottieDrawable;
import com.airbnb.lottie.animation.content.Content;
import com.airbnb.lottie.animation.content.DrawingContent;
import com.airbnb.lottie.animation.keyframe.BaseKeyframeAnimation;
import com.airbnb.lottie.animation.keyframe.FloatKeyframeAnimation;
import com.airbnb.lottie.animation.keyframe.MaskKeyframeAnimation;
import com.airbnb.lottie.animation.keyframe.StaticKeyframeAnimation;
import com.airbnb.lottie.animation.keyframe.TransformKeyframeAnimation;
import com.airbnb.lottie.model.content.Mask;
import com.airbnb.lottie.model.content.ShapeData;
import com.airbnb.lottie.model.layer.CompositionLayer;
import com.airbnb.lottie.model.layer.ImageLayer;
import com.airbnb.lottie.model.layer.Layer;
import com.airbnb.lottie.model.layer.NullLayer;
import com.airbnb.lottie.model.layer.ShapeLayer;
import com.airbnb.lottie.model.layer.SolidLayer;
import com.airbnb.lottie.model.layer.TextLayer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class BaseLayer
implements DrawingContent,
BaseKeyframeAnimation.AnimationListener {
    private static final int SAVE_FLAGS = 19;
    private final Path path = new Path();
    private final Matrix matrix = new Matrix();
    private final Paint contentPaint = new Paint(1);
    private final Paint maskPaint = new Paint(1);
    private final Paint mattePaint = new Paint(1);
    private final Paint clearPaint = new Paint();
    private final RectF rect = new RectF();
    private final RectF maskBoundsRect = new RectF();
    private final RectF matteBoundsRect = new RectF();
    private final RectF tempMaskBoundsRect = new RectF();
    private final String drawTraceName;
    final Matrix boundsMatrix = new Matrix();
    final LottieDrawable lottieDrawable;
    final Layer layerModel;
    @Nullable
    private MaskKeyframeAnimation mask;
    @Nullable
    private BaseLayer matteLayer;
    @Nullable
    private BaseLayer parentLayer;
    private List<BaseLayer> parentLayers;
    private final List<BaseKeyframeAnimation<?, ?>> animations = new ArrayList();
    final TransformKeyframeAnimation transform;
    private boolean visible = true;

    @Nullable
    static BaseLayer forModel(Layer layerModel, LottieDrawable drawable, LottieComposition composition) {
        switch (layerModel.getLayerType()) {
            case Shape: {
                return new ShapeLayer(drawable, layerModel);
            }
            case PreComp: {
                return new CompositionLayer(drawable, layerModel, composition.getPrecomps(layerModel.getRefId()), composition);
            }
            case Solid: {
                return new SolidLayer(drawable, layerModel);
            }
            case Image: {
                return new ImageLayer(drawable, layerModel, composition.getDpScale());
            }
            case Null: {
                return new NullLayer(drawable, layerModel);
            }
            case Text: {
                return new TextLayer(drawable, layerModel);
            }
        }
        Log.w((String)"LOTTIE", (String)("Unknown layer type " + (Object)((Object)layerModel.getLayerType())));
        return null;
    }

    BaseLayer(LottieDrawable lottieDrawable, Layer layerModel) {
        this.lottieDrawable = lottieDrawable;
        this.layerModel = layerModel;
        this.drawTraceName = layerModel.getName() + "#draw";
        this.clearPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        this.maskPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_IN));
        if (layerModel.getMatteType() == Layer.MatteType.Invert) {
            this.mattePaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_OUT));
        } else {
            this.mattePaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_IN));
        }
        this.transform = layerModel.getTransform().createAnimation();
        this.transform.addListener(this);
        this.transform.addAnimationsToLayer(this);
        if (layerModel.getMasks() != null && !layerModel.getMasks().isEmpty()) {
            this.mask = new MaskKeyframeAnimation(layerModel.getMasks());
            for (BaseKeyframeAnimation<ShapeData, Path> baseKeyframeAnimation : this.mask.getMaskAnimations()) {
                this.addAnimation(baseKeyframeAnimation);
                baseKeyframeAnimation.addUpdateListener(this);
            }
            for (BaseKeyframeAnimation<Object, Object> baseKeyframeAnimation : this.mask.getOpacityAnimations()) {
                this.addAnimation(baseKeyframeAnimation);
                baseKeyframeAnimation.addUpdateListener(this);
            }
        }
        this.setupInOutAnimations();
    }

    @Override
    public void onValueChanged() {
        this.invalidateSelf();
    }

    Layer getLayerModel() {
        return this.layerModel;
    }

    void setMatteLayer(@Nullable BaseLayer matteLayer) {
        this.matteLayer = matteLayer;
    }

    boolean hasMatteOnThisLayer() {
        return this.matteLayer != null;
    }

    void setParentLayer(@Nullable BaseLayer parentLayer) {
        this.parentLayer = parentLayer;
    }

    private void setupInOutAnimations() {
        if (!this.layerModel.getInOutKeyframes().isEmpty()) {
            final FloatKeyframeAnimation inOutAnimation = new FloatKeyframeAnimation(this.layerModel.getInOutKeyframes());
            inOutAnimation.setIsDiscrete();
            inOutAnimation.addUpdateListener(new BaseKeyframeAnimation.AnimationListener(){

                @Override
                public void onValueChanged() {
                    BaseLayer.this.setVisible(((Float)inOutAnimation.getValue()).floatValue() == 1.0f);
                }
            });
            this.setVisible(((Float)inOutAnimation.getValue()).floatValue() == 1.0f);
            this.addAnimation(inOutAnimation);
        } else {
            this.setVisible(true);
        }
    }

    private void invalidateSelf() {
        this.lottieDrawable.invalidateSelf();
    }

    public void addAnimation(BaseKeyframeAnimation<?, ?> newAnimation) {
        if (!(newAnimation instanceof StaticKeyframeAnimation)) {
            this.animations.add(newAnimation);
        }
    }

    @Override
    @CallSuper
    public void getBounds(RectF outBounds, Matrix parentMatrix) {
        this.boundsMatrix.set(parentMatrix);
        this.boundsMatrix.preConcat(this.transform.getMatrix());
    }

    @Override
    @SuppressLint(value={"WrongConstant"})
    public void draw(Canvas canvas, Matrix parentMatrix, int parentAlpha) {
        L.beginSection(this.drawTraceName);
        if (!this.visible) {
            L.endSection(this.drawTraceName);
            return;
        }
        this.buildParentLayerListIfNeeded();
        L.beginSection("Layer#parentMatrix");
        this.matrix.reset();
        this.matrix.set(parentMatrix);
        for (int i = this.parentLayers.size() - 1; i >= 0; --i) {
            this.matrix.preConcat(this.parentLayers.get((int)i).transform.getMatrix());
        }
        L.endSection("Layer#parentMatrix");
        int alpha = (int)((float)parentAlpha / 255.0f * (float)this.transform.getOpacity().getValue().intValue() / 100.0f * 255.0f);
        if (!this.hasMatteOnThisLayer() && !this.hasMasksOnThisLayer()) {
            this.matrix.preConcat(this.transform.getMatrix());
            L.beginSection("Layer#drawLayer");
            this.drawLayer(canvas, this.matrix, alpha);
            L.endSection("Layer#drawLayer");
            this.recordRenderTime(L.endSection(this.drawTraceName));
            return;
        }
        L.beginSection("Layer#computeBounds");
        this.rect.set(0.0f, 0.0f, 0.0f, 0.0f);
        this.getBounds(this.rect, this.matrix);
        this.intersectBoundsWithMatte(this.rect, this.matrix);
        this.matrix.preConcat(this.transform.getMatrix());
        this.intersectBoundsWithMask(this.rect, this.matrix);
        this.rect.set(0.0f, 0.0f, (float)canvas.getWidth(), (float)canvas.getHeight());
        L.endSection("Layer#computeBounds");
        L.beginSection("Layer#saveLayer");
        canvas.saveLayer(this.rect, this.contentPaint, 31);
        L.endSection("Layer#saveLayer");
        this.clearCanvas(canvas);
        L.beginSection("Layer#drawLayer");
        this.drawLayer(canvas, this.matrix, alpha);
        L.endSection("Layer#drawLayer");
        if (this.hasMasksOnThisLayer()) {
            this.applyMasks(canvas, this.matrix);
        }
        if (this.hasMatteOnThisLayer()) {
            L.beginSection("Layer#drawMatte");
            L.beginSection("Layer#saveLayer");
            canvas.saveLayer(this.rect, this.mattePaint, 19);
            L.endSection("Layer#saveLayer");
            this.clearCanvas(canvas);
            this.matteLayer.draw(canvas, parentMatrix, alpha);
            L.beginSection("Layer#restoreLayer");
            canvas.restore();
            L.endSection("Layer#restoreLayer");
            L.endSection("Layer#drawMatte");
        }
        L.beginSection("Layer#restoreLayer");
        canvas.restore();
        L.endSection("Layer#restoreLayer");
        this.recordRenderTime(L.endSection(this.drawTraceName));
    }

    private void recordRenderTime(float ms) {
        this.lottieDrawable.getComposition().getPerformanceTracker().recordRenderTime(this.layerModel.getName(), ms);
    }

    private void clearCanvas(Canvas canvas) {
        L.beginSection("Layer#clearLayer");
        canvas.drawRect(this.rect.left - 1.0f, this.rect.top - 1.0f, this.rect.right + 1.0f, this.rect.bottom + 1.0f, this.clearPaint);
        L.endSection("Layer#clearLayer");
    }

    private void intersectBoundsWithMask(RectF rect, Matrix matrix) {
        this.maskBoundsRect.set(0.0f, 0.0f, 0.0f, 0.0f);
        if (!this.hasMasksOnThisLayer()) {
            return;
        }
        int size = this.mask.getMasks().size();
        for (int i = 0; i < size; ++i) {
            Mask mask = this.mask.getMasks().get(i);
            BaseKeyframeAnimation<ShapeData, Path> maskAnimation = this.mask.getMaskAnimations().get(i);
            Path maskPath = maskAnimation.getValue();
            this.path.set(maskPath);
            this.path.transform(matrix);
            switch (mask.getMaskMode()) {
                case MaskModeSubtract: {
                    return;
                }
                case MaskModeIntersect: {
                    return;
                }
                case MaskModeUnknown: {
                    return;
                }
            }
            this.path.computeBounds(this.tempMaskBoundsRect, false);
            if (i == 0) {
                this.maskBoundsRect.set(this.tempMaskBoundsRect);
                continue;
            }
            this.maskBoundsRect.set(Math.min(this.maskBoundsRect.left, this.tempMaskBoundsRect.left), Math.min(this.maskBoundsRect.top, this.tempMaskBoundsRect.top), Math.max(this.maskBoundsRect.right, this.tempMaskBoundsRect.right), Math.max(this.maskBoundsRect.bottom, this.tempMaskBoundsRect.bottom));
        }
        rect.set(Math.max(rect.left, this.maskBoundsRect.left), Math.max(rect.top, this.maskBoundsRect.top), Math.min(rect.right, this.maskBoundsRect.right), Math.min(rect.bottom, this.maskBoundsRect.bottom));
    }

    private void intersectBoundsWithMatte(RectF rect, Matrix matrix) {
        if (!this.hasMatteOnThisLayer()) {
            return;
        }
        if (this.layerModel.getMatteType() == Layer.MatteType.Invert) {
            return;
        }
        this.matteLayer.getBounds(this.matteBoundsRect, matrix);
        rect.set(Math.max(rect.left, this.matteBoundsRect.left), Math.max(rect.top, this.matteBoundsRect.top), Math.min(rect.right, this.matteBoundsRect.right), Math.min(rect.bottom, this.matteBoundsRect.bottom));
    }

    abstract void drawLayer(Canvas var1, Matrix var2, int var3);

    @SuppressLint(value={"WrongConstant"})
    private void applyMasks(Canvas canvas, Matrix matrix) {
        L.beginSection("Layer#drawMask");
        L.beginSection("Layer#saveLayer");
        canvas.saveLayer(this.rect, this.maskPaint, 19);
        L.endSection("Layer#saveLayer");
        this.clearCanvas(canvas);
        int size = this.mask.getMasks().size();
        for (int i = 0; i < size; ++i) {
            Mask mask = this.mask.getMasks().get(i);
            BaseKeyframeAnimation<ShapeData, Path> maskAnimation = this.mask.getMaskAnimations().get(i);
            Path maskPath = maskAnimation.getValue();
            this.path.set(maskPath);
            this.path.transform(matrix);
            switch (mask.getMaskMode()) {
                case MaskModeSubtract: {
                    this.path.setFillType(Path.FillType.INVERSE_WINDING);
                    break;
                }
                default: {
                    this.path.setFillType(Path.FillType.WINDING);
                }
            }
            BaseKeyframeAnimation<Integer, Integer> opacityAnimation = this.mask.getOpacityAnimations().get(i);
            int alpha = this.contentPaint.getAlpha();
            this.contentPaint.setAlpha((int)((float)opacityAnimation.getValue().intValue() * 2.55f));
            canvas.drawPath(this.path, this.contentPaint);
            this.contentPaint.setAlpha(alpha);
        }
        L.beginSection("Layer#restoreLayer");
        canvas.restore();
        L.endSection("Layer#restoreLayer");
        L.endSection("Layer#drawMask");
    }

    boolean hasMasksOnThisLayer() {
        return this.mask != null && !this.mask.getMaskAnimations().isEmpty();
    }

    private void setVisible(boolean visible) {
        if (visible != this.visible) {
            this.visible = visible;
            this.invalidateSelf();
        }
    }

    void setProgress(@FloatRange(from=0.0, to=1.0) float progress) {
        if (this.layerModel.getTimeStretch() != 0.0f) {
            progress /= this.layerModel.getTimeStretch();
        }
        if (this.matteLayer != null) {
            float matteTimeStretch = this.matteLayer.layerModel.getTimeStretch();
            this.matteLayer.setProgress(progress * matteTimeStretch);
        }
        for (int i = 0; i < this.animations.size(); ++i) {
            this.animations.get(i).setProgress(progress);
        }
    }

    private void buildParentLayerListIfNeeded() {
        if (this.parentLayers != null) {
            return;
        }
        if (this.parentLayer == null) {
            this.parentLayers = Collections.emptyList();
            return;
        }
        this.parentLayers = new ArrayList<BaseLayer>();
        BaseLayer layer = this.parentLayer;
        while (layer != null) {
            this.parentLayers.add(layer);
            layer = layer.parentLayer;
        }
    }

    @Override
    public String getName() {
        return this.layerModel.getName();
    }

    @Override
    public void setContents(List<Content> contentsBefore, List<Content> contentsAfter) {
    }

    @Override
    public void addColorFilter(@Nullable String layerName, @Nullable String contentName, @Nullable ColorFilter colorFilter) {
    }
}

