/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.model.layer;

import android.graphics.Color;
import android.graphics.Rect;
import android.support.annotation.Nullable;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.animation.Keyframe;
import com.airbnb.lottie.model.animatable.AnimatableFloatValue;
import com.airbnb.lottie.model.animatable.AnimatableTextFrame;
import com.airbnb.lottie.model.animatable.AnimatableTextProperties;
import com.airbnb.lottie.model.animatable.AnimatableTransform;
import com.airbnb.lottie.model.content.ContentModel;
import com.airbnb.lottie.model.content.Mask;
import com.airbnb.lottie.model.content.ShapeGroup;
import com.airbnb.lottie.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONObject;

public class Layer {
    private static final String TAG = Layer.class.getSimpleName();
    private final List<ContentModel> shapes;
    private final LottieComposition composition;
    private final String layerName;
    private final long layerId;
    private final LayerType layerType;
    private final long parentId;
    @Nullable
    private final String refId;
    private final List<Mask> masks;
    private final AnimatableTransform transform;
    private final int solidWidth;
    private final int solidHeight;
    private final int solidColor;
    private final float timeStretch;
    private final float startProgress;
    private final int preCompWidth;
    private final int preCompHeight;
    @Nullable
    private final AnimatableTextFrame text;
    @Nullable
    private final AnimatableTextProperties textProperties;
    @Nullable
    private final AnimatableFloatValue timeRemapping;
    private final List<Keyframe<Float>> inOutKeyframes;
    private final MatteType matteType;

    private Layer(List<ContentModel> shapes, LottieComposition composition, String layerName, long layerId, LayerType layerType, long parentId, @Nullable String refId, List<Mask> masks, AnimatableTransform transform, int solidWidth, int solidHeight, int solidColor, float timeStretch, float startProgress, int preCompWidth, int preCompHeight, @Nullable AnimatableTextFrame text, @Nullable AnimatableTextProperties textProperties, List<Keyframe<Float>> inOutKeyframes, MatteType matteType, @Nullable AnimatableFloatValue timeRemapping) {
        this.shapes = shapes;
        this.composition = composition;
        this.layerName = layerName;
        this.layerId = layerId;
        this.layerType = layerType;
        this.parentId = parentId;
        this.refId = refId;
        this.masks = masks;
        this.transform = transform;
        this.solidWidth = solidWidth;
        this.solidHeight = solidHeight;
        this.solidColor = solidColor;
        this.timeStretch = timeStretch;
        this.startProgress = startProgress;
        this.preCompWidth = preCompWidth;
        this.preCompHeight = preCompHeight;
        this.text = text;
        this.textProperties = textProperties;
        this.inOutKeyframes = inOutKeyframes;
        this.matteType = matteType;
        this.timeRemapping = timeRemapping;
    }

    LottieComposition getComposition() {
        return this.composition;
    }

    float getTimeStretch() {
        return this.timeStretch;
    }

    float getStartProgress() {
        return this.startProgress;
    }

    List<Keyframe<Float>> getInOutKeyframes() {
        return this.inOutKeyframes;
    }

    public long getId() {
        return this.layerId;
    }

    String getName() {
        return this.layerName;
    }

    @Nullable
    String getRefId() {
        return this.refId;
    }

    int getPreCompWidth() {
        return this.preCompWidth;
    }

    int getPreCompHeight() {
        return this.preCompHeight;
    }

    List<Mask> getMasks() {
        return this.masks;
    }

    public LayerType getLayerType() {
        return this.layerType;
    }

    MatteType getMatteType() {
        return this.matteType;
    }

    long getParentId() {
        return this.parentId;
    }

    List<ContentModel> getShapes() {
        return this.shapes;
    }

    AnimatableTransform getTransform() {
        return this.transform;
    }

    int getSolidColor() {
        return this.solidColor;
    }

    int getSolidHeight() {
        return this.solidHeight;
    }

    int getSolidWidth() {
        return this.solidWidth;
    }

    @Nullable
    AnimatableTextFrame getText() {
        return this.text;
    }

    @Nullable
    AnimatableTextProperties getTextProperties() {
        return this.textProperties;
    }

    @Nullable
    AnimatableFloatValue getTimeRemapping() {
        return this.timeRemapping;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append(this.getName()).append("\n");
        Layer parent = this.composition.layerModelForId(this.getParentId());
        if (parent != null) {
            sb.append("\t\tParents: ").append(parent.getName());
            parent = this.composition.layerModelForId(parent.getParentId());
            while (parent != null) {
                sb.append("->").append(parent.getName());
                parent = this.composition.layerModelForId(parent.getParentId());
            }
            sb.append(prefix).append("\n");
        }
        if (!this.getMasks().isEmpty()) {
            sb.append(prefix).append("\tMasks: ").append(this.getMasks().size()).append("\n");
        }
        if (this.getSolidWidth() != 0 && this.getSolidHeight() != 0) {
            sb.append(prefix).append("\tBackground: ").append(String.format(Locale.US, "%dx%d %X\n", this.getSolidWidth(), this.getSolidHeight(), this.getSolidColor()));
        }
        if (!this.shapes.isEmpty()) {
            sb.append(prefix).append("\tShapes:\n");
            for (ContentModel shape : this.shapes) {
                sb.append(prefix).append("\t\t").append(shape).append("\n");
            }
        }
        return sb.toString();
    }

    public static class Factory {
        private Factory() {
        }

        public static Layer newInstance(LottieComposition composition) {
            Rect bounds = composition.getBounds();
            return new Layer(Collections.emptyList(), composition, "root", -1L, LayerType.PreComp, -1L, null, Collections.emptyList(), AnimatableTransform.Factory.newInstance(), 0, 0, 0, 0.0f, 0.0f, bounds.width(), bounds.height(), null, null, Collections.emptyList(), MatteType.None, null);
        }

        public static Layer newInstance(JSONObject json, LottieComposition composition) {
            String layerName = json.optString("nm");
            String refId = json.optString("refId");
            if (layerName.endsWith(".ai") || json.optString("cl", "").equals("ai")) {
                composition.addWarning("Convert your Illustrator layers to shape layers.");
            }
            long layerId = json.optLong("ind");
            int solidWidth = 0;
            int solidHeight = 0;
            int solidColor = 0;
            int preCompWidth = 0;
            int preCompHeight = 0;
            int layerTypeInt = json.optInt("ty", -1);
            LayerType layerType = layerTypeInt < LayerType.Unknown.ordinal() ? LayerType.values()[layerTypeInt] : LayerType.Unknown;
            if (layerType == LayerType.Text && !Utils.isAtLeastVersion(composition, 4, 8, 0)) {
                layerType = LayerType.Unknown;
                composition.addWarning("Text is only supported on bodymovin >= 4.8.0");
            }
            long parentId = json.optLong("parent", -1L);
            if (layerType == LayerType.Solid) {
                solidWidth = (int)((float)json.optInt("sw") * composition.getDpScale());
                solidHeight = (int)((float)json.optInt("sh") * composition.getDpScale());
                solidColor = Color.parseColor((String)json.optString("sc"));
            }
            AnimatableTransform transform = AnimatableTransform.Factory.newInstance(json.optJSONObject("ks"), composition);
            MatteType matteType = MatteType.values()[json.optInt("tt")];
            ArrayList<Mask> masks = new ArrayList<Mask>();
            JSONArray jsonMasks = json.optJSONArray("masksProperties");
            if (jsonMasks != null) {
                for (int i = 0; i < jsonMasks.length(); ++i) {
                    Mask mask = Mask.Factory.newMask(jsonMasks.optJSONObject(i), composition);
                    masks.add(mask);
                }
            }
            ArrayList<ContentModel> shapes = new ArrayList<ContentModel>();
            JSONArray shapesJson = json.optJSONArray("shapes");
            if (shapesJson != null) {
                for (int i = 0; i < shapesJson.length(); ++i) {
                    ContentModel shape = ShapeGroup.shapeItemWithJson(shapesJson.optJSONObject(i), composition);
                    if (shape == null) continue;
                    shapes.add(shape);
                }
            }
            AnimatableTextFrame text = null;
            AnimatableTextProperties textProperties = null;
            JSONObject textJson = json.optJSONObject("t");
            if (textJson != null) {
                text = AnimatableTextFrame.Factory.newInstance(textJson.optJSONObject("d"), composition);
                JSONObject propertiesJson = textJson.optJSONArray("a").optJSONObject(0);
                textProperties = AnimatableTextProperties.Factory.newInstance(propertiesJson, composition);
            }
            if (json.has("ef")) {
                JSONArray effects = json.optJSONArray("ef");
                Object[] effectNames = new String[effects.length()];
                for (int i = 0; i < effects.length(); ++i) {
                    effectNames[i] = effects.optJSONObject(i).optString("nm");
                }
                composition.addWarning("Lottie doesn't support layer effects. If you are using them for  fills, strokes, trim paths etc. then try adding them directly as contents  in your shape. Found: " + Arrays.toString(effectNames));
            }
            float timeStretch = (float)json.optDouble("sr", 1.0);
            float startFrame = (float)json.optDouble("st");
            float frames = composition.getDurationFrames();
            float startProgress = startFrame / frames;
            if (layerType == LayerType.PreComp) {
                preCompWidth = (int)((float)json.optInt("w") * composition.getDpScale());
                preCompHeight = (int)((float)json.optInt("h") * composition.getDpScale());
            }
            float inFrame = (float)json.optLong("ip") / timeStretch;
            float outFrame = (float)json.optLong("op") / timeStretch;
            ArrayList<Keyframe<Float>> inOutKeyframes = new ArrayList<Keyframe<Float>>();
            if (inFrame > 0.0f) {
                Keyframe<Float> preKeyframe = new Keyframe<Float>(composition, Float.valueOf(0.0f), Float.valueOf(0.0f), null, 0.0f, Float.valueOf(inFrame));
                inOutKeyframes.add(preKeyframe);
            }
            outFrame = (outFrame > 0.0f ? outFrame : (float)composition.getEndFrame()) + 1.0f;
            Keyframe<Float> visibleKeyframe = new Keyframe<Float>(composition, Float.valueOf(1.0f), Float.valueOf(1.0f), null, inFrame, Float.valueOf(outFrame));
            inOutKeyframes.add(visibleKeyframe);
            Keyframe<Float> outKeyframe = new Keyframe<Float>(composition, Float.valueOf(0.0f), Float.valueOf(0.0f), null, outFrame, Float.valueOf(Float.MAX_VALUE));
            inOutKeyframes.add(outKeyframe);
            AnimatableFloatValue timeRemapping = null;
            if (json.has("tm")) {
                timeRemapping = AnimatableFloatValue.Factory.newInstance(json.optJSONObject("tm"), composition, false);
            }
            return new Layer(shapes, composition, layerName, layerId, layerType, parentId, refId, masks, transform, solidWidth, solidHeight, solidColor, timeStretch, startProgress, preCompWidth, preCompHeight, text, textProperties, inOutKeyframes, matteType, timeRemapping);
        }
    }

    static enum MatteType {
        None,
        Add,
        Invert,
        Unknown;

    }

    public static enum LayerType {
        PreComp,
        Solid,
        Image,
        Null,
        Shape,
        Text,
        Unknown;

    }
}

