/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.support.v4.util.ArraySet;
import android.support.v4.util.Pair;
import android.util.Log;
import com.airbnb.lottie.utils.MeanCalculator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PerformanceTracker {
    private boolean enabled = false;
    private final Set<FrameListener> frameListeners = new ArraySet();
    private Map<String, MeanCalculator> layerRenderTimes = new HashMap<String, MeanCalculator>();
    private final Comparator<Pair<String, Float>> floatComparator = new Comparator<Pair<String, Float>>(){

        @Override
        public int compare(Pair<String, Float> o1, Pair<String, Float> o2) {
            float r1 = ((Float)o1.second).floatValue();
            float r2 = ((Float)o2.second).floatValue();
            if (r2 > r1) {
                return 1;
            }
            if (r1 > r2) {
                return -1;
            }
            return 0;
        }
    };

    void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void recordRenderTime(String layerName, float millis) {
        if (!this.enabled) {
            return;
        }
        MeanCalculator meanCalculator = this.layerRenderTimes.get(layerName);
        if (meanCalculator == null) {
            meanCalculator = new MeanCalculator();
            this.layerRenderTimes.put(layerName, meanCalculator);
        }
        meanCalculator.add(millis);
        if (layerName.equals("root")) {
            for (FrameListener listener : this.frameListeners) {
                listener.onFrameRendered(millis);
            }
        }
    }

    public void addFrameListener(FrameListener frameListener) {
        this.frameListeners.add(frameListener);
    }

    public void removeFrameListener(FrameListener frameListener) {
        this.frameListeners.add(frameListener);
    }

    public void clearRenderTimes() {
        this.layerRenderTimes.clear();
    }

    public void logRenderTimes() {
        if (!this.enabled) {
            return;
        }
        List<Pair<String, Float>> sortedRenderTimes = this.getSortedRenderTimes();
        Log.d((String)"LOTTIE", (String)"Render times:");
        for (int i = 0; i < sortedRenderTimes.size(); ++i) {
            Pair<String, Float> layer = sortedRenderTimes.get(i);
            Log.d((String)"LOTTIE", (String)String.format("\t\t%30s:%.2f", layer.first, layer.second));
        }
    }

    public List<Pair<String, Float>> getSortedRenderTimes() {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        ArrayList<Pair<String, Float>> sortedRenderTimes = new ArrayList<Pair<String, Float>>(this.layerRenderTimes.size());
        for (Map.Entry<String, MeanCalculator> e : this.layerRenderTimes.entrySet()) {
            sortedRenderTimes.add((Pair<String, Float>)new Pair((Object)e.getKey(), (Object)Float.valueOf(e.getValue().getMean())));
        }
        Collections.sort(sortedRenderTimes, this.floatComparator);
        return sortedRenderTimes;
    }

    public static interface FrameListener {
        public void onFrameRendered(float var1);
    }
}

