/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.model.animatable;

import android.graphics.PointF;
import android.support.annotation.Nullable;
import android.util.Log;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.LottieDrawable;
import com.airbnb.lottie.animation.content.Content;
import com.airbnb.lottie.animation.content.ModifierContent;
import com.airbnb.lottie.animation.keyframe.TransformKeyframeAnimation;
import com.airbnb.lottie.model.ScaleXY;
import com.airbnb.lottie.model.animatable.AnimatableFloatValue;
import com.airbnb.lottie.model.animatable.AnimatableIntegerValue;
import com.airbnb.lottie.model.animatable.AnimatablePathValue;
import com.airbnb.lottie.model.animatable.AnimatableScaleValue;
import com.airbnb.lottie.model.animatable.AnimatableValue;
import com.airbnb.lottie.model.content.ContentModel;
import com.airbnb.lottie.model.layer.BaseLayer;
import java.util.Collections;
import org.json.JSONObject;

public class AnimatableTransform
implements ModifierContent,
ContentModel {
    private final AnimatablePathValue anchorPoint;
    private final AnimatableValue<PointF, PointF> position;
    private final AnimatableScaleValue scale;
    private final AnimatableFloatValue rotation;
    private final AnimatableIntegerValue opacity;
    @Nullable
    private final AnimatableFloatValue startOpacity;
    @Nullable
    private final AnimatableFloatValue endOpacity;

    private AnimatableTransform(AnimatablePathValue anchorPoint, AnimatableValue<PointF, PointF> position, AnimatableScaleValue scale, AnimatableFloatValue rotation, AnimatableIntegerValue opacity, @Nullable AnimatableFloatValue startOpacity, @Nullable AnimatableFloatValue endOpacity) {
        this.anchorPoint = anchorPoint;
        this.position = position;
        this.scale = scale;
        this.rotation = rotation;
        this.opacity = opacity;
        this.startOpacity = startOpacity;
        this.endOpacity = endOpacity;
    }

    public AnimatablePathValue getAnchorPoint() {
        return this.anchorPoint;
    }

    public AnimatableValue<PointF, PointF> getPosition() {
        return this.position;
    }

    public AnimatableScaleValue getScale() {
        return this.scale;
    }

    public AnimatableFloatValue getRotation() {
        return this.rotation;
    }

    public AnimatableIntegerValue getOpacity() {
        return this.opacity;
    }

    @Nullable
    public AnimatableFloatValue getStartOpacity() {
        return this.startOpacity;
    }

    @Nullable
    public AnimatableFloatValue getEndOpacity() {
        return this.endOpacity;
    }

    public TransformKeyframeAnimation createAnimation() {
        return new TransformKeyframeAnimation(this);
    }

    @Override
    @Nullable
    public Content toContent(LottieDrawable drawable, BaseLayer layer) {
        return null;
    }

    public static class Factory {
        private Factory() {
        }

        public static AnimatableTransform newInstance() {
            AnimatablePathValue anchorPoint = new AnimatablePathValue();
            AnimatablePathValue position = new AnimatablePathValue();
            AnimatableScaleValue scale = AnimatableScaleValue.Factory.newInstance();
            AnimatableFloatValue rotation = AnimatableFloatValue.Factory.newInstance();
            AnimatableIntegerValue opacity = AnimatableIntegerValue.Factory.newInstance();
            AnimatableFloatValue startOpacity = AnimatableFloatValue.Factory.newInstance();
            AnimatableFloatValue endOpacity = AnimatableFloatValue.Factory.newInstance();
            return new AnimatableTransform(anchorPoint, position, scale, rotation, opacity, startOpacity, endOpacity);
        }

        public static AnimatableTransform newInstance(JSONObject json, LottieComposition composition) {
            JSONObject endOpacityJson;
            AnimatablePathValue anchorPoint;
            AnimatableValue<PointF, PointF> position = null;
            AnimatableFloatValue rotation = null;
            AnimatableFloatValue startOpacity = null;
            AnimatableFloatValue endOpacity = null;
            JSONObject anchorJson = json.optJSONObject("a");
            if (anchorJson != null) {
                anchorPoint = new AnimatablePathValue(anchorJson.opt("k"), composition);
            } else {
                Log.w((String)"LOTTIE", (String)"Layer has no transform property. You may be using an unsupported layer type such as a camera.");
                anchorPoint = new AnimatablePathValue();
            }
            JSONObject positionJson = json.optJSONObject("p");
            if (positionJson != null) {
                position = AnimatablePathValue.createAnimatablePathOrSplitDimensionPath(positionJson, composition);
            } else {
                Factory.throwMissingTransform("position");
            }
            JSONObject scaleJson = json.optJSONObject("s");
            AnimatableScaleValue scale = scaleJson != null ? AnimatableScaleValue.Factory.newInstance(scaleJson, composition) : new AnimatableScaleValue(Collections.emptyList(), new ScaleXY());
            JSONObject rotationJson = json.optJSONObject("r");
            if (rotationJson == null) {
                rotationJson = json.optJSONObject("rz");
            }
            if (rotationJson != null) {
                rotation = AnimatableFloatValue.Factory.newInstance(rotationJson, composition, false);
            } else {
                Factory.throwMissingTransform("rotation");
            }
            JSONObject opacityJson = json.optJSONObject("o");
            AnimatableIntegerValue opacity = opacityJson != null ? AnimatableIntegerValue.Factory.newInstance(opacityJson, composition) : new AnimatableIntegerValue(Collections.emptyList(), 100);
            JSONObject startOpacityJson = json.optJSONObject("so");
            if (startOpacityJson != null) {
                startOpacity = AnimatableFloatValue.Factory.newInstance(startOpacityJson, composition, false);
            }
            if ((endOpacityJson = json.optJSONObject("eo")) != null) {
                endOpacity = AnimatableFloatValue.Factory.newInstance(endOpacityJson, composition, false);
            }
            return new AnimatableTransform(anchorPoint, position, scale, rotation, opacity, startOpacity, endOpacity);
        }

        private static void throwMissingTransform(String missingProperty) {
            throw new IllegalArgumentException("Missing transform for " + missingProperty);
        }
    }
}

