/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.model.animatable;

import android.support.annotation.Nullable;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.animation.Keyframe;
import com.airbnb.lottie.model.animatable.AnimatableValue;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class AnimatableValueParser<T> {
    @Nullable
    private final JSONObject json;
    private final float scale;
    private final LottieComposition composition;
    private final AnimatableValue.Factory<T> valueFactory;

    private AnimatableValueParser(@Nullable JSONObject json, float scale, LottieComposition composition, AnimatableValue.Factory<T> valueFactory) {
        this.json = json;
        this.scale = scale;
        this.composition = composition;
        this.valueFactory = valueFactory;
    }

    static <T> AnimatableValueParser<T> newInstance(@Nullable JSONObject json, float scale, LottieComposition composition, AnimatableValue.Factory<T> valueFactory) {
        return new AnimatableValueParser<T>(json, scale, composition, valueFactory);
    }

    Result<T> parseJson() {
        List<Keyframe<T>> keyframes = this.parseKeyframes();
        T initialValue = this.parseInitialValue(keyframes);
        return new Result<T>(keyframes, initialValue);
    }

    private List<Keyframe<T>> parseKeyframes() {
        if (this.json != null) {
            Object k = this.json.opt("k");
            if (AnimatableValueParser.hasKeyframes(k)) {
                return Keyframe.Factory.parseKeyframes((JSONArray)k, this.composition, this.scale, this.valueFactory);
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    @Nullable
    private T parseInitialValue(List<Keyframe<T>> keyframes) {
        if (this.json != null) {
            if (!keyframes.isEmpty()) {
                return keyframes.get((int)0).startValue;
            }
            return this.valueFactory.valueFromObject(this.json.opt("k"), this.scale);
        }
        return null;
    }

    private static boolean hasKeyframes(Object json) {
        if (!(json instanceof JSONArray)) {
            return false;
        }
        Object firstObject = ((JSONArray)json).opt(0);
        return firstObject instanceof JSONObject && ((JSONObject)firstObject).has("t");
    }

    static class Result<T> {
        final List<Keyframe<T>> keyframes;
        @Nullable
        final T initialValue;

        Result(List<Keyframe<T>> keyframes, @Nullable T initialValue) {
            this.keyframes = keyframes;
            this.initialValue = initialValue;
        }
    }
}

