/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.utils;

import android.support.annotation.FloatRange;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.view.Choreographer;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.utils.BaseLottieAnimator;
import com.airbnb.lottie.utils.MiscUtils;

public class LottieValueAnimator
extends BaseLottieAnimator
implements Choreographer.FrameCallback {
    private float speed = 1.0f;
    private long frameTime = 0L;
    private float frame = 0.0f;
    private int repeatCount = 0;
    private float minFrame = -2.1474836E9f;
    private float maxFrame = 2.1474836E9f;
    @Nullable
    private LottieComposition composition;
    @VisibleForTesting
    protected boolean isRunning = false;

    public Object getAnimatedValue() {
        return Float.valueOf(this.getAnimatedValueAbsolute());
    }

    @FloatRange(from=0.0, to=1.0)
    public float getAnimatedValueAbsolute() {
        if (this.composition == null) {
            return 0.0f;
        }
        return (this.frame - this.composition.getStartFrame()) / (this.composition.getEndFrame() - this.composition.getStartFrame());
    }

    @FloatRange(from=0.0, to=1.0)
    public float getAnimatedFraction() {
        if (this.composition == null) {
            return 0.0f;
        }
        if (this.isReversed()) {
            return (this.getMaxFrame() - this.frame) / (this.getMaxFrame() - this.getMinFrame());
        }
        return (this.frame - this.getMinFrame()) / (this.getMaxFrame() - this.getMinFrame());
    }

    public long getDuration() {
        return this.composition == null ? 0L : (long)this.composition.getDuration();
    }

    public float getFrame() {
        return this.frame;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void doFrame(long frameTimeNanos) {
        float frameDuration;
        this.postFrameCallback();
        if (this.composition == null || !this.isRunning()) {
            return;
        }
        long now = System.nanoTime();
        long timeSinceFrame = now - this.frameTime;
        float frames = (float)timeSinceFrame / (frameDuration = this.getFrameDurationNs());
        int wholeFrames = (int)frames;
        if (wholeFrames == 0) {
            return;
        }
        this.frame += this.isReversed() ? (float)(-wholeFrames) : (float)wholeFrames;
        boolean ended = !MiscUtils.contains(this.frame, this.getMinFrame(), this.getMaxFrame());
        this.frame = MiscUtils.clamp(this.frame, this.getMinFrame(), this.getMaxFrame());
        float partialFramesDuration = (frames - (float)wholeFrames) * frameDuration;
        this.frameTime = (long)((float)now - partialFramesDuration);
        this.notifyUpdate();
        if (ended) {
            if (this.getRepeatCount() != -1 && this.repeatCount >= this.getRepeatCount()) {
                this.frame = this.getMaxFrame();
                this.notifyEnd(this.isReversed());
                this.removeFrameCallback();
            } else {
                this.notifyRepeat();
                ++this.repeatCount;
                if (this.getRepeatMode() == 2) {
                    this.reverseAnimationSpeed();
                } else {
                    this.frame = this.getMinFrame();
                }
                this.frameTime = now;
            }
        }
        this.verifyFrame();
    }

    private float getFrameDurationNs() {
        if (this.composition == null) {
            return Float.MAX_VALUE;
        }
        return 1.0E9f / this.composition.getFrameRate() / Math.abs(this.speed);
    }

    public void setComposition(LottieComposition composition) {
        this.composition = composition;
        this.frame = this.getMinFrame();
        this.frameTime = System.nanoTime();
    }

    public void setFrame(int frame) {
        if (this.frame == (float)frame) {
            return;
        }
        this.frame = MiscUtils.clamp((float)frame, this.getMinFrame(), this.getMaxFrame());
        this.verifyFrame();
        this.frameTime = System.nanoTime();
        this.notifyUpdate();
    }

    public void setMinFrame(int minFrame) {
        this.minFrame = minFrame;
        if (this.frame < (float)minFrame) {
            this.frame = minFrame;
        }
    }

    public void setMaxFrame(int maxFrame) {
        this.maxFrame = maxFrame;
        if (this.frame > (float)maxFrame) {
            this.frame = maxFrame;
        }
    }

    public void setMinAndMaxFrames(int minFrame, int maxFrame) {
        this.minFrame = minFrame;
        this.maxFrame = maxFrame;
        this.frame = MiscUtils.clamp(this.frame, (float)minFrame, (float)maxFrame);
    }

    public void reverseAnimationSpeed() {
        this.setSpeed(-this.getSpeed());
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public float getSpeed() {
        return this.speed;
    }

    public void playAnimation() {
        this.frame = this.isReversed() ? this.getMaxFrame() : this.getMinFrame();
        this.frameTime = System.nanoTime();
        this.repeatCount = 0;
        this.postFrameCallback();
        this.notifyStart(this.isReversed());
    }

    public void endAnimation() {
        this.removeFrameCallback();
        this.notifyEnd(this.isReversed());
    }

    public void pauseAnimation() {
        this.removeFrameCallback();
    }

    public void resumeAnimation() {
        this.postFrameCallback();
        this.frameTime = System.nanoTime();
        if (this.isReversed() && this.getFrame() == this.getMinFrame()) {
            this.frame = this.getMaxFrame();
        } else if (!this.isReversed() && this.getFrame() == this.getMaxFrame()) {
            this.frame = this.getMinFrame();
        }
    }

    public void cancel() {
        this.notifyCancel();
        this.removeFrameCallback();
    }

    private boolean isReversed() {
        return this.speed < 0.0f;
    }

    private float getMinFrame() {
        if (this.composition == null) {
            return 0.0f;
        }
        return this.minFrame == -2.1474836E9f ? 0.0f : this.minFrame;
    }

    private float getMaxFrame() {
        if (this.composition == null) {
            return 0.0f;
        }
        return this.maxFrame == 2.1474836E9f ? this.composition.getEndFrame() : this.maxFrame;
    }

    protected void postFrameCallback() {
        this.removeFrameCallback();
        Choreographer.getInstance().postFrameCallback((Choreographer.FrameCallback)this);
        this.isRunning = true;
    }

    protected void removeFrameCallback() {
        Choreographer.getInstance().removeFrameCallback((Choreographer.FrameCallback)this);
        this.isRunning = false;
    }

    private void verifyFrame() {
        if (this.composition == null) {
            return;
        }
        if (this.frame < this.minFrame || this.frame > this.maxFrame) {
            throw new IllegalStateException(String.format("Frame must be [%f,%f]. It is %f", Float.valueOf(this.minFrame), Float.valueOf(this.maxFrame), Float.valueOf(this.frame)));
        }
    }
}

