/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.airbnb.lottie.LottieAnimationView;
import com.airbnb.lottie.LottieDrawable;
import java.util.HashMap;
import java.util.Map;

public class TextDelegate {
    private final Map<String, String> stringMap = new HashMap<String, String>();
    @Nullable
    private final LottieAnimationView animationView;
    @Nullable
    private final LottieDrawable drawable;
    private boolean cacheText = true;

    @VisibleForTesting
    TextDelegate() {
        this.animationView = null;
        this.drawable = null;
    }

    public TextDelegate(LottieAnimationView animationView) {
        this.animationView = animationView;
        this.drawable = null;
    }

    public TextDelegate(LottieDrawable drawable) {
        this.drawable = drawable;
        this.animationView = null;
    }

    private String getText(String input) {
        return input;
    }

    public void setText(String input, String output) {
        this.stringMap.put(input, output);
        this.invalidate();
    }

    public void setCacheText(boolean cacheText) {
        this.cacheText = cacheText;
    }

    public void invalidateText(String input) {
        this.stringMap.remove(input);
        this.invalidate();
    }

    public void invalidateAllText() {
        this.stringMap.clear();
        this.invalidate();
    }

    public final String getTextInternal(String input) {
        if (this.cacheText && this.stringMap.containsKey(input)) {
            return this.stringMap.get(input);
        }
        String text = this.getText(input);
        if (this.cacheText) {
            this.stringMap.put(input, text);
        }
        return text;
    }

    private void invalidate() {
        if (this.animationView != null) {
            this.animationView.invalidate();
        }
        if (this.drawable != null) {
            this.drawable.invalidateSelf();
        }
    }
}

