/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.parser;

import android.graphics.Rect;
import android.support.v4.util.LongSparseArray;
import android.support.v4.util.SparseArrayCompat;
import android.util.JsonReader;
import com.airbnb.lottie.L;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.LottieImageAsset;
import com.airbnb.lottie.model.Font;
import com.airbnb.lottie.model.FontCharacter;
import com.airbnb.lottie.model.layer.Layer;
import com.airbnb.lottie.parser.FontCharacterParser;
import com.airbnb.lottie.parser.FontParser;
import com.airbnb.lottie.parser.LayerParser;
import com.airbnb.lottie.utils.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LottieCompositionParser {
    private LottieCompositionParser() {
    }

    public static LottieComposition parse(JsonReader reader) throws IOException {
        float scale = Utils.dpScale();
        float startFrame = 0.0f;
        float endFrame = 0.0f;
        float frameRate = 0.0f;
        LongSparseArray layerMap = new LongSparseArray();
        ArrayList<Layer> layers = new ArrayList<Layer>();
        int width = 0;
        int height = 0;
        HashMap<String, List<Layer>> precomps = new HashMap<String, List<Layer>>();
        HashMap<String, LottieImageAsset> images = new HashMap<String, LottieImageAsset>();
        HashMap<String, Font> fonts = new HashMap<String, Font>();
        SparseArrayCompat characters = new SparseArrayCompat();
        LottieComposition composition = new LottieComposition();
        reader.beginObject();
        block24: while (reader.hasNext()) {
            switch (reader.nextName()) {
                case "w": {
                    width = reader.nextInt();
                    continue block24;
                }
                case "h": {
                    height = reader.nextInt();
                    continue block24;
                }
                case "ip": {
                    startFrame = (float)reader.nextDouble();
                    continue block24;
                }
                case "op": {
                    endFrame = (float)reader.nextDouble();
                    continue block24;
                }
                case "fr": {
                    frameRate = (float)reader.nextDouble();
                    continue block24;
                }
                case "v": {
                    int patchVersion;
                    int minorVersion;
                    String version = reader.nextString();
                    String[] versions = version.split("\\.");
                    int majorVersion = Integer.parseInt(versions[0]);
                    if (Utils.isAtLeastVersion(majorVersion, minorVersion = Integer.parseInt(versions[1]), patchVersion = Integer.parseInt(versions[2]), 4, 4, 0)) continue block24;
                    composition.addWarning("Lottie only supports bodymovin >= 4.4.0");
                    continue block24;
                }
                case "layers": {
                    LottieCompositionParser.parseLayers(reader, composition, layers, (LongSparseArray<Layer>)layerMap);
                    continue block24;
                }
                case "assets": {
                    LottieCompositionParser.parseAssets(reader, composition, precomps, images);
                    continue block24;
                }
                case "fonts": {
                    LottieCompositionParser.parseFonts(reader, fonts);
                    continue block24;
                }
                case "chars": {
                    LottieCompositionParser.parseChars(reader, composition, (SparseArrayCompat<FontCharacter>)characters);
                    continue block24;
                }
            }
            reader.skipValue();
        }
        reader.endObject();
        int scaledWidth = (int)((float)width * scale);
        int scaledHeight = (int)((float)height * scale);
        Rect bounds = new Rect(0, 0, scaledWidth, scaledHeight);
        composition.init(bounds, startFrame, endFrame, frameRate, layers, (LongSparseArray<Layer>)layerMap, precomps, images, (SparseArrayCompat<FontCharacter>)characters, fonts);
        return composition;
    }

    private static void parseLayers(JsonReader reader, LottieComposition composition, List<Layer> layers, LongSparseArray<Layer> layerMap) throws IOException {
        int imageCount = 0;
        reader.beginArray();
        while (reader.hasNext()) {
            Layer layer = LayerParser.parse(reader, composition);
            if (layer.getLayerType() == Layer.LayerType.Image) {
                ++imageCount;
            }
            layers.add(layer);
            layerMap.put(layer.getId(), (Object)layer);
            if (imageCount <= 4) continue;
            L.warn("You have " + imageCount + " images. Lottie should primarily be used with shapes. If you are using Adobe Illustrator, convert the Illustrator layers to shape layers.");
        }
        reader.endArray();
    }

    private static void parseAssets(JsonReader reader, LottieComposition composition, Map<String, List<Layer>> precomps, Map<String, LottieImageAsset> images) throws IOException {
        reader.beginArray();
        while (reader.hasNext()) {
            String id = null;
            ArrayList<Layer> layers = new ArrayList<Layer>();
            LongSparseArray layerMap = new LongSparseArray();
            int width = 0;
            int height = 0;
            String imageFileName = null;
            String relativeFolder = null;
            reader.beginObject();
            block17: while (reader.hasNext()) {
                switch (reader.nextName()) {
                    case "id": {
                        id = reader.nextString();
                        continue block17;
                    }
                    case "layers": {
                        reader.beginArray();
                        while (reader.hasNext()) {
                            Layer layer = LayerParser.parse(reader, composition);
                            layerMap.put(layer.getId(), (Object)layer);
                            layers.add(layer);
                        }
                        reader.endArray();
                        continue block17;
                    }
                    case "w": {
                        width = reader.nextInt();
                        continue block17;
                    }
                    case "h": {
                        height = reader.nextInt();
                        continue block17;
                    }
                    case "p": {
                        imageFileName = reader.nextString();
                        continue block17;
                    }
                    case "u": {
                        relativeFolder = reader.nextString();
                        continue block17;
                    }
                }
                reader.skipValue();
            }
            reader.endObject();
            if (imageFileName != null) {
                LottieImageAsset image = new LottieImageAsset(width, height, id, imageFileName, relativeFolder);
                images.put(image.getId(), image);
                continue;
            }
            precomps.put(id, layers);
        }
        reader.endArray();
    }

    private static void parseFonts(JsonReader reader, Map<String, Font> fonts) throws IOException {
        reader.beginObject();
        block6: while (reader.hasNext()) {
            switch (reader.nextName()) {
                case "list": {
                    reader.beginArray();
                    while (reader.hasNext()) {
                        Font font = FontParser.parse(reader);
                        fonts.put(font.getName(), font);
                    }
                    reader.endArray();
                    continue block6;
                }
            }
            reader.skipValue();
        }
        reader.endObject();
    }

    private static void parseChars(JsonReader reader, LottieComposition composition, SparseArrayCompat<FontCharacter> characters) throws IOException {
        reader.beginArray();
        while (reader.hasNext()) {
            FontCharacter character = FontCharacterParser.parse(reader, composition);
            characters.put(character.hashCode(), (Object)character);
        }
        reader.endArray();
    }
}

