/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.value;

import android.graphics.PointF;
import android.support.annotation.NonNull;
import com.airbnb.lottie.utils.MiscUtils;
import com.airbnb.lottie.value.LottieFrameInfo;
import com.airbnb.lottie.value.LottieValueCallback;

public class LottieRelativePointValueCallback
extends LottieValueCallback<PointF> {
    private final PointF point = new PointF();

    public LottieRelativePointValueCallback() {
    }

    public LottieRelativePointValueCallback(@NonNull PointF staticValue) {
        super(staticValue);
    }

    @Override
    public final PointF getValue(LottieFrameInfo<PointF> frameInfo) {
        this.point.set(MiscUtils.lerp(frameInfo.getStartValue().x, frameInfo.getEndValue().x, frameInfo.getInterpolatedKeyframeProgress()), MiscUtils.lerp(frameInfo.getStartValue().y, frameInfo.getEndValue().y, frameInfo.getInterpolatedKeyframeProgress()));
        PointF offset = this.getOffset(frameInfo);
        this.point.offset(offset.x, offset.y);
        return this.point;
    }

    public PointF getOffset(LottieFrameInfo<PointF> frameInfo) {
        if (this.value == null) {
            throw new IllegalArgumentException("You must provide a static value in the constructor , call setValue, or override getValue.");
        }
        return (PointF)this.value;
    }
}

