/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RawRes;
import android.support.annotation.VisibleForTesting;
import android.support.v7.widget.AppCompatImageView;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.JsonReader;
import android.util.SparseArray;
import android.view.View;
import com.airbnb.lottie.Cancellable;
import com.airbnb.lottie.FontAssetDelegate;
import com.airbnb.lottie.ImageAssetDelegate;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.LottieDrawable;
import com.airbnb.lottie.LottieProperty;
import com.airbnb.lottie.OnCompositionLoadedListener;
import com.airbnb.lottie.PerformanceTracker;
import com.airbnb.lottie.R;
import com.airbnb.lottie.SimpleColorFilter;
import com.airbnb.lottie.TextDelegate;
import com.airbnb.lottie.model.KeyPath;
import com.airbnb.lottie.value.LottieFrameInfo;
import com.airbnb.lottie.value.LottieValueCallback;
import com.airbnb.lottie.value.SimpleLottieValueCallback;
import java.io.Reader;
import java.io.StringReader;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class LottieAnimationView
extends AppCompatImageView {
    public static final CacheStrategy DEFAULT_CACHE_STRATEGY = CacheStrategy.Weak;
    private static final String TAG = LottieAnimationView.class.getSimpleName();
    private static final SparseArray<LottieComposition> RAW_RES_STRONG_REF_CACHE = new SparseArray();
    private static final SparseArray<WeakReference<LottieComposition>> RAW_RES_WEAK_REF_CACHE = new SparseArray();
    private static final Map<String, LottieComposition> ASSET_STRONG_REF_CACHE = new HashMap<String, LottieComposition>();
    private static final Map<String, WeakReference<LottieComposition>> ASSET_WEAK_REF_CACHE = new HashMap<String, WeakReference<LottieComposition>>();
    private final OnCompositionLoadedListener loadedListener = new OnCompositionLoadedListener(){

        @Override
        public void onCompositionLoaded(@Nullable LottieComposition composition) {
            if (composition != null) {
                LottieAnimationView.this.setComposition(composition);
            }
            LottieAnimationView.this.compositionLoader = null;
        }
    };
    private final LottieDrawable lottieDrawable = new LottieDrawable();
    private CacheStrategy defaultCacheStrategy;
    private String animationName;
    @RawRes
    private int animationResId;
    private boolean wasAnimatingWhenDetached = false;
    private boolean autoPlay = false;
    private boolean useHardwareLayer = false;
    @Nullable
    private Cancellable compositionLoader;
    @Nullable
    private LottieComposition composition;

    public LottieAnimationView(Context context) {
        super(context);
        this.init(null);
    }

    public LottieAnimationView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public LottieAnimationView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    private void init(@Nullable AttributeSet attrs) {
        TypedArray ta = this.getContext().obtainStyledAttributes(attrs, R.styleable.LottieAnimationView);
        int cacheStrategyOrdinal = ta.getInt(R.styleable.LottieAnimationView_lottie_cacheStrategy, DEFAULT_CACHE_STRATEGY.ordinal());
        this.defaultCacheStrategy = CacheStrategy.values()[cacheStrategyOrdinal];
        if (!this.isInEditMode()) {
            String fileName;
            boolean hasRawRes = ta.hasValue(R.styleable.LottieAnimationView_lottie_rawRes);
            boolean hasFileName = ta.hasValue(R.styleable.LottieAnimationView_lottie_fileName);
            if (hasRawRes && hasFileName) {
                throw new IllegalArgumentException("lottie_rawRes and lottie_fileName cannot be used at the same time. Please use use only one at once.");
            }
            if (hasRawRes) {
                int rawResId = ta.getResourceId(R.styleable.LottieAnimationView_lottie_rawRes, 0);
                if (rawResId != 0) {
                    this.setAnimation(rawResId);
                }
            } else if (hasFileName && (fileName = ta.getString(R.styleable.LottieAnimationView_lottie_fileName)) != null) {
                this.setAnimation(fileName);
            }
        }
        if (ta.getBoolean(R.styleable.LottieAnimationView_lottie_autoPlay, false)) {
            this.wasAnimatingWhenDetached = true;
            this.autoPlay = true;
        }
        if (ta.getBoolean(R.styleable.LottieAnimationView_lottie_loop, false)) {
            this.lottieDrawable.setRepeatCount(-1);
        }
        if (ta.hasValue(R.styleable.LottieAnimationView_lottie_repeatMode)) {
            this.setRepeatMode(ta.getInt(R.styleable.LottieAnimationView_lottie_repeatMode, 1));
        }
        if (ta.hasValue(R.styleable.LottieAnimationView_lottie_repeatCount)) {
            this.setRepeatCount(ta.getInt(R.styleable.LottieAnimationView_lottie_repeatCount, -1));
        }
        this.setImageAssetsFolder(ta.getString(R.styleable.LottieAnimationView_lottie_imageAssetsFolder));
        this.setProgress(ta.getFloat(R.styleable.LottieAnimationView_lottie_progress, 0.0f));
        this.enableMergePathsForKitKatAndAbove(ta.getBoolean(R.styleable.LottieAnimationView_lottie_enableMergePathsForKitKatAndAbove, false));
        if (ta.hasValue(R.styleable.LottieAnimationView_lottie_colorFilter)) {
            SimpleColorFilter filter = new SimpleColorFilter(ta.getColor(R.styleable.LottieAnimationView_lottie_colorFilter, 0));
            KeyPath keyPath = new KeyPath("**");
            LottieValueCallback<SimpleColorFilter> callback = new LottieValueCallback<SimpleColorFilter>(filter);
            this.addValueCallback(keyPath, LottieProperty.COLOR_FILTER, callback);
        }
        if (ta.hasValue(R.styleable.LottieAnimationView_lottie_scale)) {
            this.lottieDrawable.setScale(ta.getFloat(R.styleable.LottieAnimationView_lottie_scale, 1.0f));
        }
        ta.recycle();
        this.enableOrDisableHardwareLayer();
    }

    public void setImageResource(int resId) {
        this.recycleBitmaps();
        this.cancelLoaderTask();
        super.setImageResource(resId);
    }

    public void setImageDrawable(Drawable drawable) {
        this.setImageDrawable(drawable, true);
    }

    private void setImageDrawable(Drawable drawable, boolean recycle) {
        if (recycle && drawable != this.lottieDrawable) {
            this.recycleBitmaps();
        }
        this.cancelLoaderTask();
        super.setImageDrawable(drawable);
    }

    public void setImageBitmap(Bitmap bm) {
        this.recycleBitmaps();
        this.cancelLoaderTask();
        super.setImageBitmap(bm);
    }

    public void invalidateDrawable(@NonNull Drawable dr) {
        if (this.getDrawable() == this.lottieDrawable) {
            super.invalidateDrawable((Drawable)this.lottieDrawable);
        } else {
            super.invalidateDrawable(dr);
        }
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.animationName = this.animationName;
        ss.animationResId = this.animationResId;
        ss.progress = this.lottieDrawable.getProgress();
        ss.isAnimating = this.lottieDrawable.isAnimating();
        ss.imageAssetsFolder = this.lottieDrawable.getImageAssetsFolder();
        ss.repeatMode = this.lottieDrawable.getRepeatMode();
        ss.repeatCount = this.lottieDrawable.getRepeatCount();
        return ss;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.animationName = ss.animationName;
        if (!TextUtils.isEmpty((CharSequence)this.animationName)) {
            this.setAnimation(this.animationName);
        }
        this.animationResId = ss.animationResId;
        if (this.animationResId != 0) {
            this.setAnimation(this.animationResId);
        }
        this.setProgress(ss.progress);
        if (ss.isAnimating) {
            this.playAnimation();
        }
        this.lottieDrawable.setImagesAssetsFolder(ss.imageAssetsFolder);
        this.setRepeatMode(ss.repeatMode);
        this.setRepeatCount(ss.repeatCount);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.autoPlay && this.wasAnimatingWhenDetached) {
            this.playAnimation();
        }
    }

    protected void onDetachedFromWindow() {
        if (this.isAnimating()) {
            this.cancelAnimation();
            this.wasAnimatingWhenDetached = true;
        }
        this.recycleBitmaps();
        super.onDetachedFromWindow();
    }

    @VisibleForTesting
    void recycleBitmaps() {
        if (this.lottieDrawable != null) {
            this.lottieDrawable.recycleBitmaps();
        }
    }

    public void enableMergePathsForKitKatAndAbove(boolean enable) {
        this.lottieDrawable.enableMergePathsForKitKatAndAbove(enable);
    }

    public boolean isMergePathsEnabledForKitKatAndAbove() {
        return this.lottieDrawable.isMergePathsEnabledForKitKatAndAbove();
    }

    @Deprecated
    public void useExperimentalHardwareAcceleration() {
        this.useHardwareAcceleration(true);
    }

    @Deprecated
    public void useExperimentalHardwareAcceleration(boolean use) {
        this.useHardwareAcceleration(use);
    }

    public void useHardwareAcceleration() {
        this.useHardwareAcceleration(true);
    }

    public void useHardwareAcceleration(boolean use) {
        this.useHardwareLayer = use;
        this.enableOrDisableHardwareLayer();
    }

    public boolean getUseHardwareAcceleration() {
        return this.useHardwareLayer;
    }

    public void setAnimation(@RawRes int animationResId) {
        this.setAnimation(animationResId, this.defaultCacheStrategy);
    }

    public void setAnimation(@RawRes int animationResId, CacheStrategy cacheStrategy) {
        this.animationResId = animationResId;
        this.animationName = null;
        if (RAW_RES_WEAK_REF_CACHE.indexOfKey(animationResId) > 0) {
            WeakReference compRef = (WeakReference)RAW_RES_WEAK_REF_CACHE.get(animationResId);
            LottieComposition ref = (LottieComposition)compRef.get();
            if (ref != null) {
                this.setComposition(ref);
                return;
            }
        } else if (RAW_RES_STRONG_REF_CACHE.indexOfKey(animationResId) > 0) {
            this.setComposition((LottieComposition)RAW_RES_STRONG_REF_CACHE.get(animationResId));
            return;
        }
        this.clearComposition();
        this.cancelLoaderTask();
        this.compositionLoader = LottieComposition.Factory.fromRawFile(this.getContext(), animationResId, composition -> {
            if (cacheStrategy == CacheStrategy.Strong) {
                RAW_RES_STRONG_REF_CACHE.put(animationResId, (Object)composition);
            } else if (cacheStrategy == CacheStrategy.Weak) {
                RAW_RES_WEAK_REF_CACHE.put(animationResId, new WeakReference<LottieComposition>(composition));
            }
            this.setComposition(composition);
        });
    }

    public void setAnimation(String animationName) {
        this.setAnimation(animationName, this.defaultCacheStrategy);
    }

    public void setAnimation(String animationName, CacheStrategy cacheStrategy) {
        this.animationName = animationName;
        this.animationResId = 0;
        if (ASSET_WEAK_REF_CACHE.containsKey(animationName)) {
            WeakReference<LottieComposition> compRef = ASSET_WEAK_REF_CACHE.get(animationName);
            LottieComposition ref = (LottieComposition)compRef.get();
            if (ref != null) {
                this.setComposition(ref);
                return;
            }
        } else if (ASSET_STRONG_REF_CACHE.containsKey(animationName)) {
            this.setComposition(ASSET_STRONG_REF_CACHE.get(animationName));
            return;
        }
        this.clearComposition();
        this.cancelLoaderTask();
        this.compositionLoader = LottieComposition.Factory.fromAssetFileName(this.getContext(), animationName, composition -> {
            if (cacheStrategy == CacheStrategy.Strong) {
                ASSET_STRONG_REF_CACHE.put(animationName, composition);
            } else if (cacheStrategy == CacheStrategy.Weak) {
                ASSET_WEAK_REF_CACHE.put(animationName, new WeakReference<LottieComposition>(composition));
            }
            this.setComposition(composition);
        });
    }

    @Deprecated
    public void setAnimation(JSONObject json) {
        this.setAnimation(new JsonReader((Reader)new StringReader(json.toString())));
    }

    public void setAnimationFromJson(String jsonString) {
        this.setAnimation(new JsonReader((Reader)new StringReader(jsonString)));
    }

    public void setAnimation(JsonReader reader) {
        this.clearComposition();
        this.cancelLoaderTask();
        this.compositionLoader = LottieComposition.Factory.fromJsonReader(reader, this.loadedListener);
    }

    private void cancelLoaderTask() {
        if (this.compositionLoader != null) {
            this.compositionLoader.cancel();
            this.compositionLoader = null;
        }
    }

    public void setComposition(@NonNull LottieComposition composition) {
        this.lottieDrawable.setCallback((Drawable.Callback)this);
        this.composition = composition;
        boolean isNewComposition = this.lottieDrawable.setComposition(composition);
        this.enableOrDisableHardwareLayer();
        if (this.getDrawable() == this.lottieDrawable && !isNewComposition) {
            return;
        }
        this.setImageDrawable(null);
        this.setImageDrawable(this.lottieDrawable);
        this.requestLayout();
    }

    @Nullable
    public LottieComposition getComposition() {
        return this.composition;
    }

    public boolean hasMasks() {
        return this.lottieDrawable.hasMasks();
    }

    public boolean hasMatte() {
        return this.lottieDrawable.hasMatte();
    }

    public void playAnimation() {
        this.lottieDrawable.playAnimation();
        this.enableOrDisableHardwareLayer();
    }

    public void resumeAnimation() {
        this.lottieDrawable.resumeAnimation();
        this.enableOrDisableHardwareLayer();
    }

    public void setMinFrame(int startFrame) {
        this.lottieDrawable.setMinFrame(startFrame);
    }

    public float getMinFrame() {
        return this.lottieDrawable.getMinFrame();
    }

    public void setMinProgress(float startProgress) {
        this.lottieDrawable.setMinProgress(startProgress);
    }

    public void setMaxFrame(int endFrame) {
        this.lottieDrawable.setMaxFrame(endFrame);
    }

    public float getMaxFrame() {
        return this.lottieDrawable.getMaxFrame();
    }

    public void setMaxProgress(@FloatRange(from=0.0, to=1.0) float endProgress) {
        this.lottieDrawable.setMaxProgress(endProgress);
    }

    public void setMinAndMaxFrame(int minFrame, int maxFrame) {
        this.lottieDrawable.setMinAndMaxFrame(minFrame, maxFrame);
    }

    public void setMinAndMaxProgress(@FloatRange(from=0.0, to=1.0) float minProgress, @FloatRange(from=0.0, to=1.0) float maxProgress) {
        this.lottieDrawable.setMinAndMaxProgress(minProgress, maxProgress);
    }

    public void reverseAnimationSpeed() {
        this.lottieDrawable.reverseAnimationSpeed();
    }

    public void setSpeed(float speed) {
        this.lottieDrawable.setSpeed(speed);
    }

    public float getSpeed() {
        return this.lottieDrawable.getSpeed();
    }

    public void addAnimatorUpdateListener(ValueAnimator.AnimatorUpdateListener updateListener) {
        this.lottieDrawable.addAnimatorUpdateListener(updateListener);
    }

    public void removeUpdateListener(ValueAnimator.AnimatorUpdateListener updateListener) {
        this.lottieDrawable.removeAnimatorUpdateListener(updateListener);
    }

    public void removeAllUpdateListeners() {
        this.lottieDrawable.removeAllUpdateListeners();
    }

    public void addAnimatorListener(Animator.AnimatorListener listener) {
        this.lottieDrawable.addAnimatorListener(listener);
    }

    public void removeAnimatorListener(Animator.AnimatorListener listener) {
        this.lottieDrawable.removeAnimatorListener(listener);
    }

    public void removeAllAnimatorListeners() {
        this.lottieDrawable.removeAllAnimatorListeners();
    }

    @Deprecated
    public void loop(boolean loop) {
        this.lottieDrawable.setRepeatCount(loop ? -1 : 0);
    }

    public void setRepeatMode(int mode) {
        this.lottieDrawable.setRepeatMode(mode);
    }

    public int getRepeatMode() {
        return this.lottieDrawable.getRepeatMode();
    }

    public void setRepeatCount(int count) {
        this.lottieDrawable.setRepeatCount(count);
    }

    public int getRepeatCount() {
        return this.lottieDrawable.getRepeatCount();
    }

    public boolean isAnimating() {
        return this.lottieDrawable.isAnimating();
    }

    public void setImageAssetsFolder(String imageAssetsFolder) {
        this.lottieDrawable.setImagesAssetsFolder(imageAssetsFolder);
    }

    @Nullable
    public String getImageAssetsFolder() {
        return this.lottieDrawable.getImageAssetsFolder();
    }

    @Nullable
    public Bitmap updateBitmap(String id, @Nullable Bitmap bitmap) {
        return this.lottieDrawable.updateBitmap(id, bitmap);
    }

    public void setImageAssetDelegate(ImageAssetDelegate assetDelegate) {
        this.lottieDrawable.setImageAssetDelegate(assetDelegate);
    }

    public void setFontAssetDelegate(FontAssetDelegate assetDelegate) {
        this.lottieDrawable.setFontAssetDelegate(assetDelegate);
    }

    public void setTextDelegate(TextDelegate textDelegate) {
        this.lottieDrawable.setTextDelegate(textDelegate);
    }

    public List<KeyPath> resolveKeyPath(KeyPath keyPath) {
        return this.lottieDrawable.resolveKeyPath(keyPath);
    }

    public <T> void addValueCallback(KeyPath keyPath, T property, LottieValueCallback<T> callback) {
        this.lottieDrawable.addValueCallback(keyPath, property, callback);
    }

    public <T> void addValueCallback(KeyPath keyPath, T property, final SimpleLottieValueCallback<T> callback) {
        this.lottieDrawable.addValueCallback(keyPath, property, new LottieValueCallback<T>(){

            @Override
            public T getValue(LottieFrameInfo<T> frameInfo) {
                return callback.getValue(frameInfo);
            }
        });
    }

    public void setScale(float scale) {
        this.lottieDrawable.setScale(scale);
        if (this.getDrawable() == this.lottieDrawable) {
            this.setImageDrawable(null, false);
            this.setImageDrawable(this.lottieDrawable, false);
        }
    }

    public float getScale() {
        return this.lottieDrawable.getScale();
    }

    public void cancelAnimation() {
        this.lottieDrawable.cancelAnimation();
        this.enableOrDisableHardwareLayer();
    }

    public void pauseAnimation() {
        this.lottieDrawable.pauseAnimation();
        this.enableOrDisableHardwareLayer();
    }

    public void setFrame(int frame) {
        this.lottieDrawable.setFrame(frame);
    }

    public int getFrame() {
        return this.lottieDrawable.getFrame();
    }

    public void setProgress(@FloatRange(from=0.0, to=1.0) float progress) {
        this.lottieDrawable.setProgress(progress);
    }

    @FloatRange(from=0.0, to=1.0)
    public float getProgress() {
        return this.lottieDrawable.getProgress();
    }

    public long getDuration() {
        return this.composition != null ? (long)this.composition.getDuration() : 0L;
    }

    public void setPerformanceTrackingEnabled(boolean enabled) {
        this.lottieDrawable.setPerformanceTrackingEnabled(enabled);
    }

    @Nullable
    public PerformanceTracker getPerformanceTracker() {
        return this.lottieDrawable.getPerformanceTracker();
    }

    private void clearComposition() {
        this.composition = null;
        this.lottieDrawable.clearComposition();
    }

    private void enableOrDisableHardwareLayer() {
        boolean useHardwareLayer = this.useHardwareLayer && this.lottieDrawable.isAnimating();
        this.setLayerType(useHardwareLayer ? 2 : 1, null);
    }

    private static class SavedState
    extends View.BaseSavedState {
        String animationName;
        int animationResId;
        float progress;
        boolean isAnimating;
        String imageAssetsFolder;
        int repeatMode;
        int repeatCount;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.animationName = in.readString();
            this.progress = in.readFloat();
            this.isAnimating = in.readInt() == 1;
            this.imageAssetsFolder = in.readString();
            this.repeatMode = in.readInt();
            this.repeatCount = in.readInt();
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeString(this.animationName);
            out.writeFloat(this.progress);
            out.writeInt(this.isAnimating ? 1 : 0);
            out.writeString(this.imageAssetsFolder);
            out.writeInt(this.repeatMode);
            out.writeInt(this.repeatCount);
        }
    }

    public static enum CacheStrategy {
        None,
        Weak,
        Strong;

    }
}

