/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.util.Log;
import com.airbnb.lottie.L;
import com.airbnb.lottie.LottieListener;
import com.airbnb.lottie.LottieResult;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;

public class LottieTask<T> {
    public Executor EXECUTOR = Executors.newCachedThreadPool();
    @Nullable
    private Thread taskObserver;
    private final Set<LottieListener<T>> successListeners = new LinkedHashSet<LottieListener<T>>(1);
    private final Set<LottieListener<Throwable>> failureListeners = new LinkedHashSet<LottieListener<Throwable>>(1);
    private final Handler handler = new Handler(Looper.getMainLooper());
    private final FutureTask<LottieResult<T>> task;
    @Nullable
    private LottieResult<T> result = null;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public LottieTask(Callable<LottieResult<T>> runnable) {
        this(runnable, false);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    LottieTask(Callable<LottieResult<T>> runnable, boolean runNow) {
        this.task = new FutureTask<LottieResult<T>>(runnable);
        if (runNow) {
            try {
                this.setResult(runnable.call());
            }
            catch (Throwable e) {
                this.setResult(new LottieResult(e));
            }
        } else {
            this.EXECUTOR.execute(this.task);
            this.startTaskObserverIfNeeded();
        }
    }

    private void setResult(@Nullable LottieResult<T> result) {
        if (this.result != null) {
            throw new IllegalStateException("A task may only be set once.");
        }
        this.result = result;
        this.notifyListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LottieTask<T> addListener(LottieListener<T> listener) {
        if (this.result != null && this.result.getValue() != null) {
            listener.onResult(this.result.getValue());
        }
        Set<LottieListener<T>> set = this.successListeners;
        synchronized (set) {
            this.successListeners.add(listener);
        }
        this.startTaskObserverIfNeeded();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LottieTask<T> removeListener(LottieListener<T> listener) {
        Set<LottieListener<T>> set = this.successListeners;
        synchronized (set) {
            this.successListeners.remove(listener);
        }
        this.stopTaskObserverIfNeeded();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LottieTask<T> addFailureListener(LottieListener<Throwable> listener) {
        if (this.result != null && this.result.getException() != null) {
            listener.onResult(this.result.getException());
        }
        Set<LottieListener<Throwable>> set = this.failureListeners;
        synchronized (set) {
            this.failureListeners.add(listener);
        }
        this.startTaskObserverIfNeeded();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LottieTask<T> removeFailureListener(LottieListener<T> listener) {
        Set<LottieListener<Throwable>> set = this.failureListeners;
        synchronized (set) {
            this.failureListeners.remove(listener);
        }
        this.stopTaskObserverIfNeeded();
        return this;
    }

    private void notifyListeners() {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                if (LottieTask.this.result == null || LottieTask.this.task.isCancelled()) {
                    return;
                }
                LottieResult result = LottieTask.this.result;
                if (result.getValue() != null) {
                    LottieTask.this.notifySuccessListeners(result.getValue());
                } else {
                    LottieTask.this.notifyFailureListeners(result.getException());
                }
            }
        });
    }

    private void notifySuccessListeners(T value) {
        ArrayList<LottieListener<T>> listenersCopy = new ArrayList<LottieListener<T>>(this.successListeners);
        for (LottieListener lottieListener : listenersCopy) {
            lottieListener.onResult(value);
        }
    }

    private void notifyFailureListeners(Throwable e) {
        ArrayList<LottieListener<Throwable>> listenersCopy = new ArrayList<LottieListener<Throwable>>(this.failureListeners);
        if (listenersCopy.isEmpty()) {
            Log.w((String)"LOTTIE", (String)"Lottie encountered an error but no failure listener was added.", (Throwable)e);
            return;
        }
        for (LottieListener lottieListener : listenersCopy) {
            lottieListener.onResult(e);
        }
    }

    private void startTaskObserverIfNeeded() {
        if (this.taskObserverAlive() || this.result != null) {
            return;
        }
        this.taskObserver = new Thread("LottieTaskObserver"){

            @Override
            public void run() {
                while (!this.isInterrupted()) {
                    if (!LottieTask.this.task.isDone()) continue;
                    try {
                        LottieTask.this.setResult((LottieResult)LottieTask.this.task.get());
                    }
                    catch (InterruptedException | ExecutionException e) {
                        LottieTask.this.setResult(new LottieResult(e));
                    }
                    LottieTask.this.stopTaskObserverIfNeeded();
                }
                return;
            }
        };
        this.taskObserver.start();
        L.debug("Starting TaskObserver thread");
    }

    private void stopTaskObserverIfNeeded() {
        if (!this.taskObserverAlive()) {
            return;
        }
        if (this.successListeners.isEmpty() || this.result != null) {
            this.taskObserver.interrupt();
            this.taskObserver = null;
            L.debug("Stopping TaskObserver thread");
        }
    }

    private boolean taskObserverAlive() {
        return this.taskObserver != null && this.taskObserver.isAlive();
    }
}

