/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.model.content;

import android.graphics.Paint;
import android.support.annotation.Nullable;
import com.airbnb.lottie.LottieDrawable;
import com.airbnb.lottie.animation.content.Content;
import com.airbnb.lottie.animation.content.StrokeContent;
import com.airbnb.lottie.model.animatable.AnimatableColorValue;
import com.airbnb.lottie.model.animatable.AnimatableFloatValue;
import com.airbnb.lottie.model.animatable.AnimatableIntegerValue;
import com.airbnb.lottie.model.content.ContentModel;
import com.airbnb.lottie.model.layer.BaseLayer;
import java.util.List;

public class ShapeStroke
implements ContentModel {
    private final String name;
    @Nullable
    private final AnimatableFloatValue offset;
    private final List<AnimatableFloatValue> lineDashPattern;
    private final AnimatableColorValue color;
    private final AnimatableIntegerValue opacity;
    private final AnimatableFloatValue width;
    private final LineCapType capType;
    private final LineJoinType joinType;
    private final float miterLimit;

    public ShapeStroke(String name, @Nullable AnimatableFloatValue offset, List<AnimatableFloatValue> lineDashPattern, AnimatableColorValue color, AnimatableIntegerValue opacity, AnimatableFloatValue width, LineCapType capType, LineJoinType joinType, float miterLimit) {
        this.name = name;
        this.offset = offset;
        this.lineDashPattern = lineDashPattern;
        this.color = color;
        this.opacity = opacity;
        this.width = width;
        this.capType = capType;
        this.joinType = joinType;
        this.miterLimit = miterLimit;
    }

    @Override
    public Content toContent(LottieDrawable drawable, BaseLayer layer) {
        return new StrokeContent(drawable, layer, this);
    }

    public String getName() {
        return this.name;
    }

    public AnimatableColorValue getColor() {
        return this.color;
    }

    public AnimatableIntegerValue getOpacity() {
        return this.opacity;
    }

    public AnimatableFloatValue getWidth() {
        return this.width;
    }

    public List<AnimatableFloatValue> getLineDashPattern() {
        return this.lineDashPattern;
    }

    public AnimatableFloatValue getDashOffset() {
        return this.offset;
    }

    public LineCapType getCapType() {
        return this.capType;
    }

    public LineJoinType getJoinType() {
        return this.joinType;
    }

    public float getMiterLimit() {
        return this.miterLimit;
    }

    public static enum LineJoinType {
        Miter,
        Round,
        Bevel;


        public Paint.Join toPaintJoin() {
            switch (this) {
                case Bevel: {
                    return Paint.Join.BEVEL;
                }
                case Miter: {
                    return Paint.Join.MITER;
                }
                case Round: {
                    return Paint.Join.ROUND;
                }
            }
            return null;
        }
    }

    public static enum LineCapType {
        Butt,
        Round,
        Unknown;


        public Paint.Cap toPaintCap() {
            switch (this) {
                case Butt: {
                    return Paint.Cap.BUTT;
                }
                case Round: {
                    return Paint.Cap.ROUND;
                }
            }
            return Paint.Cap.SQUARE;
        }
    }
}

