/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.network;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.support.v4.util.Pair;
import com.airbnb.lottie.L;
import com.airbnb.lottie.network.FileExtension;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class NetworkCache {
    private final Context appContext;
    private final String url;

    NetworkCache(Context appContext, String url) {
        this.appContext = appContext.getApplicationContext();
        this.url = url;
    }

    @Nullable
    @WorkerThread
    Pair<FileExtension, InputStream> fetch() {
        FileInputStream inputStream;
        File cachedFile = null;
        try {
            cachedFile = this.getCachedFile(this.url);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        if (cachedFile == null) {
            return null;
        }
        try {
            inputStream = new FileInputStream(cachedFile);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        FileExtension extension = cachedFile.getAbsolutePath().endsWith(".zip") ? FileExtension.Zip : FileExtension.Json;
        L.debug("Cache hit for " + this.url + " at " + cachedFile.getAbsolutePath());
        return new Pair((Object)extension, (Object)inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    File writeTempCacheFile(InputStream stream, FileExtension extension) throws IOException {
        String fileName = NetworkCache.filenameForUrl(this.url, extension, true);
        File file = new File(this.appContext.getCacheDir(), fileName);
        try (FileOutputStream output = new FileOutputStream(file);){
            int read;
            byte[] buffer = new byte[1024];
            while ((read = stream.read(buffer)) != -1) {
                ((OutputStream)output).write(buffer, 0, read);
            }
            output.flush();
        }
        finally {
            stream.close();
        }
        return file;
    }

    void renameTempFile(FileExtension extension) {
        String fileName = NetworkCache.filenameForUrl(this.url, extension, true);
        File file = new File(this.appContext.getCacheDir(), fileName);
        String newFileName = file.getAbsolutePath().replace(".temp", "");
        File newFile = new File(newFileName);
        boolean renamed = file.renameTo(newFile);
        L.debug("Copying temp file to real file (" + newFile + ")");
        if (!renamed) {
            L.warn("Unable to rename cache file " + file.getAbsolutePath() + " to " + newFile.getAbsolutePath() + ".");
        }
    }

    @Nullable
    private File getCachedFile(String url) throws FileNotFoundException {
        File jsonFile = new File(this.appContext.getCacheDir(), NetworkCache.filenameForUrl(url, FileExtension.Json, false));
        if (jsonFile.exists()) {
            return jsonFile;
        }
        File zipFile = new File(this.appContext.getCacheDir(), NetworkCache.filenameForUrl(url, FileExtension.Zip, false));
        if (zipFile.exists()) {
            return zipFile;
        }
        return null;
    }

    private static String filenameForUrl(String url, FileExtension extension, boolean isTemp) {
        return "lottie_cache_" + url.replaceAll("\\W+", "") + (isTemp ? extension.extension : extension.tempExtension());
    }
}

