/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.animation.content;

import com.airbnb.lottie.animation.content.Content;
import com.airbnb.lottie.animation.keyframe.BaseKeyframeAnimation;
import com.airbnb.lottie.model.content.ShapeTrimPath;
import com.airbnb.lottie.model.layer.BaseLayer;
import java.util.ArrayList;
import java.util.List;

public class TrimPathContent
implements Content,
BaseKeyframeAnimation.AnimationListener {
    private final String name;
    private final List<BaseKeyframeAnimation.AnimationListener> listeners = new ArrayList<BaseKeyframeAnimation.AnimationListener>();
    private final ShapeTrimPath.Type type;
    private final BaseKeyframeAnimation<?, Float> startAnimation;
    private final BaseKeyframeAnimation<?, Float> endAnimation;
    private final BaseKeyframeAnimation<?, Float> offsetAnimation;

    public TrimPathContent(BaseLayer layer, ShapeTrimPath trimPath) {
        this.name = trimPath.getName();
        this.type = trimPath.getType();
        this.startAnimation = trimPath.getStart().createAnimation();
        this.endAnimation = trimPath.getEnd().createAnimation();
        this.offsetAnimation = trimPath.getOffset().createAnimation();
        layer.addAnimation(this.startAnimation);
        layer.addAnimation(this.endAnimation);
        layer.addAnimation(this.offsetAnimation);
        this.startAnimation.addUpdateListener(this);
        this.endAnimation.addUpdateListener(this);
        this.offsetAnimation.addUpdateListener(this);
    }

    @Override
    public void onValueChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).onValueChanged();
        }
    }

    @Override
    public void setContents(List<Content> contentsBefore, List<Content> contentsAfter) {
    }

    @Override
    public String getName() {
        return this.name;
    }

    void addListener(BaseKeyframeAnimation.AnimationListener listener) {
        this.listeners.add(listener);
    }

    ShapeTrimPath.Type getType() {
        return this.type;
    }

    public BaseKeyframeAnimation<?, Float> getStart() {
        return this.startAnimation;
    }

    public BaseKeyframeAnimation<?, Float> getEnd() {
        return this.endAnimation;
    }

    public BaseKeyframeAnimation<?, Float> getOffset() {
        return this.offsetAnimation;
    }
}

