/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.parser;

import android.util.JsonReader;
import android.util.Log;
import androidx.annotation.Nullable;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.model.content.ContentModel;
import com.airbnb.lottie.parser.AnimatableTransformParser;
import com.airbnb.lottie.parser.CircleShapeParser;
import com.airbnb.lottie.parser.GradientFillParser;
import com.airbnb.lottie.parser.GradientStrokeParser;
import com.airbnb.lottie.parser.MergePathsParser;
import com.airbnb.lottie.parser.PolystarShapeParser;
import com.airbnb.lottie.parser.RectangleShapeParser;
import com.airbnb.lottie.parser.RepeaterParser;
import com.airbnb.lottie.parser.ShapeFillParser;
import com.airbnb.lottie.parser.ShapeGroupParser;
import com.airbnb.lottie.parser.ShapePathParser;
import com.airbnb.lottie.parser.ShapeStrokeParser;
import com.airbnb.lottie.parser.ShapeTrimPathParser;
import java.io.IOException;

class ContentModelParser {
    private ContentModelParser() {
    }

    @Nullable
    static ContentModel parse(JsonReader reader, LottieComposition composition) throws IOException {
        String type = null;
        reader.beginObject();
        int d = 2;
        block38: while (reader.hasNext()) {
            switch (reader.nextName()) {
                case "ty": {
                    type = reader.nextString();
                    break block38;
                }
                case "d": {
                    d = reader.nextInt();
                    continue block38;
                }
                default: {
                    reader.skipValue();
                    continue block38;
                }
            }
        }
        if (type == null) {
            return null;
        }
        ContentModel model = null;
        switch (type) {
            case "gr": {
                model = ShapeGroupParser.parse(reader, composition);
                break;
            }
            case "st": {
                model = ShapeStrokeParser.parse(reader, composition);
                break;
            }
            case "gs": {
                model = GradientStrokeParser.parse(reader, composition);
                break;
            }
            case "fl": {
                model = ShapeFillParser.parse(reader, composition);
                break;
            }
            case "gf": {
                model = GradientFillParser.parse(reader, composition);
                break;
            }
            case "tr": {
                model = AnimatableTransformParser.parse(reader, composition);
                break;
            }
            case "sh": {
                model = ShapePathParser.parse(reader, composition);
                break;
            }
            case "el": {
                model = CircleShapeParser.parse(reader, composition, d);
                break;
            }
            case "rc": {
                model = RectangleShapeParser.parse(reader, composition);
                break;
            }
            case "tm": {
                model = ShapeTrimPathParser.parse(reader, composition);
                break;
            }
            case "sr": {
                model = PolystarShapeParser.parse(reader, composition);
                break;
            }
            case "mm": {
                model = MergePathsParser.parse(reader);
                composition.addWarning("Animation contains merge paths. Merge paths are only supported on KitKat+ and must be manually enabled by calling enableMergePathsForKitKatAndAbove().");
                break;
            }
            case "rp": {
                model = RepeaterParser.parse(reader, composition);
                break;
            }
            default: {
                Log.w((String)"LOTTIE", (String)("Unknown shape type " + type));
            }
        }
        while (reader.hasNext()) {
            reader.skipValue();
        }
        reader.endObject();
        return model;
    }
}

