/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.parser;

import android.util.JsonReader;
import android.util.JsonToken;
import com.airbnb.lottie.parser.ValueParser;
import com.airbnb.lottie.value.ScaleXY;
import java.io.IOException;

public class ScaleXYParser
implements ValueParser<ScaleXY> {
    public static final ScaleXYParser INSTANCE = new ScaleXYParser();

    private ScaleXYParser() {
    }

    @Override
    public ScaleXY parse(JsonReader reader, float scale) throws IOException {
        boolean isArray;
        boolean bl = isArray = reader.peek() == JsonToken.BEGIN_ARRAY;
        if (isArray) {
            reader.beginArray();
        }
        float sx = (float)reader.nextDouble();
        float sy = (float)reader.nextDouble();
        while (reader.hasNext()) {
            reader.skipValue();
        }
        if (isArray) {
            reader.endArray();
        }
        return new ScaleXY(sx / 100.0f * scale, sy / 100.0f * scale);
    }
}

