/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.parser;

import android.util.JsonReader;
import android.util.Log;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.model.animatable.AnimatableIntegerValue;
import com.airbnb.lottie.model.animatable.AnimatableShapeValue;
import com.airbnb.lottie.model.content.Mask;
import com.airbnb.lottie.parser.AnimatableValueParser;
import java.io.IOException;

class MaskParser {
    private MaskParser() {
    }

    static Mask parse(JsonReader reader, LottieComposition composition) throws IOException {
        Mask.MaskMode maskMode = null;
        AnimatableShapeValue maskPath = null;
        AnimatableIntegerValue opacity = null;
        boolean inverted = false;
        reader.beginObject();
        while (reader.hasNext()) {
            String mode;
            block6 : switch (mode = reader.nextName()) {
                case "mode": {
                    switch (reader.nextString()) {
                        case "a": {
                            maskMode = Mask.MaskMode.MASK_MODE_ADD;
                            break block6;
                        }
                        case "s": {
                            maskMode = Mask.MaskMode.MASK_MODE_SUBTRACT;
                            break block6;
                        }
                        case "i": {
                            composition.addWarning("Animation contains intersect masks. They are not supported but will be treated like add masks.");
                            maskMode = Mask.MaskMode.MASK_MODE_INTERSECT;
                            break block6;
                        }
                    }
                    Log.w((String)"LOTTIE", (String)("Unknown mask mode " + mode + ". Defaulting to Add."));
                    maskMode = Mask.MaskMode.MASK_MODE_ADD;
                    break;
                }
                case "pt": {
                    maskPath = AnimatableValueParser.parseShapeData(reader, composition);
                    break;
                }
                case "o": {
                    opacity = AnimatableValueParser.parseInteger(reader, composition);
                    break;
                }
                case "inv": {
                    inverted = reader.nextBoolean();
                    break;
                }
                default: {
                    reader.skipValue();
                }
            }
        }
        reader.endObject();
        return new Mask(maskMode, maskPath, opacity, inverted);
    }
}

