/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.parser;

import android.graphics.PointF;
import android.util.JsonReader;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.model.animatable.AnimatablePointValue;
import com.airbnb.lottie.model.animatable.AnimatableValue;
import com.airbnb.lottie.model.content.CircleShape;
import com.airbnb.lottie.parser.AnimatablePathValueParser;
import com.airbnb.lottie.parser.AnimatableValueParser;
import java.io.IOException;

class CircleShapeParser {
    private CircleShapeParser() {
    }

    static CircleShape parse(JsonReader reader, LottieComposition composition, int d) throws IOException {
        String name = null;
        AnimatableValue<PointF, PointF> position = null;
        AnimatablePointValue size = null;
        boolean reversed = d == 3;
        boolean hidden = false;
        block14: while (reader.hasNext()) {
            switch (reader.nextName()) {
                case "nm": {
                    name = reader.nextString();
                    continue block14;
                }
                case "p": {
                    position = AnimatablePathValueParser.parseSplitPath(reader, composition);
                    continue block14;
                }
                case "s": {
                    size = AnimatableValueParser.parsePoint(reader, composition);
                    continue block14;
                }
                case "hd": {
                    hidden = reader.nextBoolean();
                    continue block14;
                }
                case "d": {
                    reversed = reader.nextInt() == 3;
                    continue block14;
                }
            }
            reader.skipValue();
        }
        return new CircleShape(name, position, size, reversed, hidden);
    }
}

