/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.parser;

import android.graphics.PointF;
import com.airbnb.lottie.parser.JsonUtils;
import com.airbnb.lottie.parser.ValueParser;
import com.airbnb.lottie.parser.moshi.JsonReader;
import java.io.IOException;

public class PointFParser
implements ValueParser<PointF> {
    public static final PointFParser INSTANCE = new PointFParser();

    private PointFParser() {
    }

    @Override
    public PointF parse(JsonReader reader, float scale) throws IOException {
        JsonReader.Token token = reader.peek();
        if (token == JsonReader.Token.BEGIN_ARRAY) {
            return JsonUtils.jsonToPoint(reader, scale);
        }
        if (token == JsonReader.Token.BEGIN_OBJECT) {
            return JsonUtils.jsonToPoint(reader, scale);
        }
        if (token == JsonReader.Token.NUMBER) {
            PointF point = new PointF((float)reader.nextDouble() * scale, (float)reader.nextDouble() * scale);
            while (reader.hasNext()) {
                reader.skipValue();
            }
            return point;
        }
        throw new IllegalArgumentException("Cannot convert json to point. Next token is " + (Object)((Object)token));
    }
}

