/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.model.layer;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.Typeface;
import androidx.annotation.Nullable;
import androidx.collection.LongSparseArray;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.LottieDrawable;
import com.airbnb.lottie.LottieProperty;
import com.airbnb.lottie.TextDelegate;
import com.airbnb.lottie.animation.content.ContentGroup;
import com.airbnb.lottie.animation.keyframe.BaseKeyframeAnimation;
import com.airbnb.lottie.animation.keyframe.TextKeyframeAnimation;
import com.airbnb.lottie.animation.keyframe.ValueCallbackKeyframeAnimation;
import com.airbnb.lottie.model.DocumentData;
import com.airbnb.lottie.model.Font;
import com.airbnb.lottie.model.FontCharacter;
import com.airbnb.lottie.model.animatable.AnimatableTextProperties;
import com.airbnb.lottie.model.content.ShapeGroup;
import com.airbnb.lottie.model.layer.BaseLayer;
import com.airbnb.lottie.model.layer.Layer;
import com.airbnb.lottie.utils.Utils;
import com.airbnb.lottie.value.LottieValueCallback;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TextLayer
extends BaseLayer {
    private final StringBuilder stringBuilder = new StringBuilder(2);
    private final RectF rectF = new RectF();
    private final Matrix matrix = new Matrix();
    private final Paint fillPaint = new Paint(1){
        {
            this.setStyle(Paint.Style.FILL);
        }
    };
    private final Paint strokePaint = new Paint(1){
        {
            this.setStyle(Paint.Style.STROKE);
        }
    };
    private final Map<FontCharacter, List<ContentGroup>> contentsForCharacter = new HashMap<FontCharacter, List<ContentGroup>>();
    private final LongSparseArray<String> codePointCache = new LongSparseArray();
    private final TextKeyframeAnimation textAnimation;
    private final LottieDrawable lottieDrawable;
    private final LottieComposition composition;
    @Nullable
    private BaseKeyframeAnimation<Integer, Integer> colorAnimation;
    @Nullable
    private BaseKeyframeAnimation<Integer, Integer> strokeColorAnimation;
    @Nullable
    private BaseKeyframeAnimation<Float, Float> strokeWidthAnimation;
    @Nullable
    private BaseKeyframeAnimation<Float, Float> trackingAnimation;
    @Nullable
    private BaseKeyframeAnimation<Float, Float> textSizeAnimation;

    TextLayer(LottieDrawable lottieDrawable, Layer layerModel) {
        super(lottieDrawable, layerModel);
        this.lottieDrawable = lottieDrawable;
        this.composition = layerModel.getComposition();
        this.textAnimation = layerModel.getText().createAnimation();
        this.textAnimation.addUpdateListener(this);
        this.addAnimation(this.textAnimation);
        AnimatableTextProperties textProperties = layerModel.getTextProperties();
        if (textProperties != null && textProperties.color != null) {
            this.colorAnimation = textProperties.color.createAnimation();
            this.colorAnimation.addUpdateListener(this);
            this.addAnimation(this.colorAnimation);
        }
        if (textProperties != null && textProperties.stroke != null) {
            this.strokeColorAnimation = textProperties.stroke.createAnimation();
            this.strokeColorAnimation.addUpdateListener(this);
            this.addAnimation(this.strokeColorAnimation);
        }
        if (textProperties != null && textProperties.strokeWidth != null) {
            this.strokeWidthAnimation = textProperties.strokeWidth.createAnimation();
            this.strokeWidthAnimation.addUpdateListener(this);
            this.addAnimation(this.strokeWidthAnimation);
        }
        if (textProperties != null && textProperties.tracking != null) {
            this.trackingAnimation = textProperties.tracking.createAnimation();
            this.trackingAnimation.addUpdateListener(this);
            this.addAnimation(this.trackingAnimation);
        }
    }

    @Override
    public void getBounds(RectF outBounds, Matrix parentMatrix, boolean applyParents) {
        super.getBounds(outBounds, parentMatrix, applyParents);
        outBounds.set(0.0f, 0.0f, (float)this.composition.getBounds().width(), (float)this.composition.getBounds().height());
    }

    @Override
    void drawLayer(Canvas canvas, Matrix parentMatrix, int parentAlpha) {
        canvas.save();
        if (!this.lottieDrawable.useTextGlyphs()) {
            canvas.setMatrix(parentMatrix);
        }
        DocumentData documentData = (DocumentData)this.textAnimation.getValue();
        Font font = this.composition.getFonts().get(documentData.fontName);
        if (font == null) {
            canvas.restore();
            return;
        }
        if (this.colorAnimation != null) {
            this.fillPaint.setColor(this.colorAnimation.getValue().intValue());
        } else {
            this.fillPaint.setColor(documentData.color);
        }
        if (this.strokeColorAnimation != null) {
            this.strokePaint.setColor(this.strokeColorAnimation.getValue().intValue());
        } else {
            this.strokePaint.setColor(documentData.strokeColor);
        }
        int opacity = this.transform.getOpacity() == null ? 100 : this.transform.getOpacity().getValue();
        int alpha = opacity * 255 / 100;
        this.fillPaint.setAlpha(alpha);
        this.strokePaint.setAlpha(alpha);
        if (this.strokeWidthAnimation != null) {
            this.strokePaint.setStrokeWidth(this.strokeWidthAnimation.getValue().floatValue());
        } else {
            float parentScale = Utils.getScale(parentMatrix);
            this.strokePaint.setStrokeWidth(documentData.strokeWidth * Utils.dpScale() * parentScale);
        }
        if (this.lottieDrawable.useTextGlyphs()) {
            this.drawTextGlyphs(documentData, parentMatrix, font, canvas);
        } else {
            this.drawTextWithFont(documentData, font, parentMatrix, canvas);
        }
        canvas.restore();
    }

    private void drawTextGlyphs(DocumentData documentData, Matrix parentMatrix, Font font, Canvas canvas) {
        float textSize = this.textSizeAnimation == null ? documentData.size : this.textSizeAnimation.getValue().floatValue();
        float fontScale = textSize / 100.0f;
        float parentScale = Utils.getScale(parentMatrix);
        String text = documentData.text;
        float lineHeight = documentData.lineHeight * Utils.dpScale();
        List<String> textLines = this.getTextLines(text);
        int textLineCount = textLines.size();
        for (int l = 0; l < textLineCount; ++l) {
            String textLine = textLines.get(l);
            float textLineWidth = this.getTextLineWidthForGlyphs(textLine, font, fontScale, parentScale);
            canvas.save();
            this.applyJustification(documentData.justification, canvas, textLineWidth);
            float multilineTranslateY = (float)(textLineCount - 1) * lineHeight / 2.0f;
            float translateY = (float)l * lineHeight - multilineTranslateY;
            canvas.translate(0.0f, translateY);
            this.drawGlyphTextLine(textLine, documentData, parentMatrix, font, canvas, parentScale, fontScale);
            canvas.restore();
        }
    }

    private void drawGlyphTextLine(String text, DocumentData documentData, Matrix parentMatrix, Font font, Canvas canvas, float parentScale, float fontScale) {
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            int characterHash = FontCharacter.hashFor(c, font.getFamily(), font.getStyle());
            FontCharacter character = (FontCharacter)this.composition.getCharacters().get(characterHash);
            if (character == null) continue;
            this.drawCharacterAsGlyph(character, parentMatrix, fontScale, documentData, canvas);
            float tx = (float)character.getWidth() * fontScale * Utils.dpScale() * parentScale;
            float tracking = (float)documentData.tracking / 10.0f;
            if (this.trackingAnimation != null) {
                tracking += this.trackingAnimation.getValue().floatValue();
            }
            canvas.translate(tx += tracking * parentScale, 0.0f);
        }
    }

    private void drawTextWithFont(DocumentData documentData, Font font, Matrix parentMatrix, Canvas canvas) {
        float parentScale = Utils.getScale(parentMatrix);
        Typeface typeface = this.lottieDrawable.getTypeface(font.getFamily(), font.getStyle());
        if (typeface == null) {
            return;
        }
        String text = documentData.text;
        TextDelegate textDelegate = this.lottieDrawable.getTextDelegate();
        if (textDelegate != null) {
            text = textDelegate.getTextInternal(text);
        }
        this.fillPaint.setTypeface(typeface);
        float textSize = this.textSizeAnimation == null ? documentData.size : this.textSizeAnimation.getValue().floatValue();
        this.fillPaint.setTextSize(textSize * Utils.dpScale());
        this.strokePaint.setTypeface(this.fillPaint.getTypeface());
        this.strokePaint.setTextSize(this.fillPaint.getTextSize());
        float lineHeight = documentData.lineHeight * Utils.dpScale();
        List<String> textLines = this.getTextLines(text);
        int textLineCount = textLines.size();
        for (int l = 0; l < textLineCount; ++l) {
            String textLine = textLines.get(l);
            float textLineWidth = this.strokePaint.measureText(textLine);
            this.applyJustification(documentData.justification, canvas, textLineWidth);
            float multilineTranslateY = (float)(textLineCount - 1) * lineHeight / 2.0f;
            float translateY = (float)l * lineHeight - multilineTranslateY;
            canvas.translate(0.0f, translateY);
            this.drawFontTextLine(textLine, documentData, canvas, parentScale);
            canvas.setMatrix(parentMatrix);
        }
    }

    private List<String> getTextLines(String text) {
        String formattedText = text.replaceAll("\r\n", "\r").replaceAll("\n", "\r");
        String[] textLinesArray = formattedText.split("\r");
        return Arrays.asList(textLinesArray);
    }

    private void drawFontTextLine(String text, DocumentData documentData, Canvas canvas, float parentScale) {
        int i = 0;
        while (i < text.length()) {
            String charString = this.codePointToString(text, i);
            i += charString.length();
            this.drawCharacterFromFont(charString, documentData, canvas);
            float charWidth = this.fillPaint.measureText(charString, 0, 1);
            float tracking = (float)documentData.tracking / 10.0f;
            if (this.trackingAnimation != null) {
                tracking += this.trackingAnimation.getValue().floatValue();
            }
            float tx = charWidth + tracking * parentScale;
            canvas.translate(tx, 0.0f);
        }
    }

    private float getTextLineWidthForGlyphs(String textLine, Font font, float fontScale, float parentScale) {
        float textLineWidth = 0.0f;
        for (int i = 0; i < textLine.length(); ++i) {
            char c = textLine.charAt(i);
            int characterHash = FontCharacter.hashFor(c, font.getFamily(), font.getStyle());
            FontCharacter character = (FontCharacter)this.composition.getCharacters().get(characterHash);
            if (character == null) continue;
            textLineWidth = (float)((double)textLineWidth + character.getWidth() * (double)fontScale * (double)Utils.dpScale() * (double)parentScale);
        }
        return textLineWidth;
    }

    private void applyJustification(DocumentData.Justification justification, Canvas canvas, float textLineWidth) {
        switch (justification) {
            case LEFT_ALIGN: {
                break;
            }
            case RIGHT_ALIGN: {
                canvas.translate(-textLineWidth, 0.0f);
                break;
            }
            case CENTER: {
                canvas.translate(-textLineWidth / 2.0f, 0.0f);
            }
        }
    }

    private void drawCharacterAsGlyph(FontCharacter character, Matrix parentMatrix, float fontScale, DocumentData documentData, Canvas canvas) {
        List<ContentGroup> contentGroups = this.getContentsForCharacter(character);
        for (int j = 0; j < contentGroups.size(); ++j) {
            Path path = contentGroups.get(j).getPath();
            path.computeBounds(this.rectF, false);
            this.matrix.set(parentMatrix);
            this.matrix.preTranslate(0.0f, -documentData.baselineShift * Utils.dpScale());
            this.matrix.preScale(fontScale, fontScale);
            path.transform(this.matrix);
            if (documentData.strokeOverFill) {
                this.drawGlyph(path, this.fillPaint, canvas);
                this.drawGlyph(path, this.strokePaint, canvas);
                continue;
            }
            this.drawGlyph(path, this.strokePaint, canvas);
            this.drawGlyph(path, this.fillPaint, canvas);
        }
    }

    private void drawGlyph(Path path, Paint paint, Canvas canvas) {
        if (paint.getColor() == 0) {
            return;
        }
        if (paint.getStyle() == Paint.Style.STROKE && paint.getStrokeWidth() == 0.0f) {
            return;
        }
        canvas.drawPath(path, paint);
    }

    private void drawCharacterFromFont(String character, DocumentData documentData, Canvas canvas) {
        if (documentData.strokeOverFill) {
            this.drawCharacter(character, this.fillPaint, canvas);
            this.drawCharacter(character, this.strokePaint, canvas);
        } else {
            this.drawCharacter(character, this.strokePaint, canvas);
            this.drawCharacter(character, this.fillPaint, canvas);
        }
    }

    private void drawCharacter(String character, Paint paint, Canvas canvas) {
        if (paint.getColor() == 0) {
            return;
        }
        if (paint.getStyle() == Paint.Style.STROKE && paint.getStrokeWidth() == 0.0f) {
            return;
        }
        canvas.drawText(character, 0, character.length(), 0.0f, 0.0f, paint);
    }

    private List<ContentGroup> getContentsForCharacter(FontCharacter character) {
        if (this.contentsForCharacter.containsKey(character)) {
            return this.contentsForCharacter.get(character);
        }
        List<ShapeGroup> shapes = character.getShapes();
        int size = shapes.size();
        ArrayList<ContentGroup> contents = new ArrayList<ContentGroup>(size);
        for (int i = 0; i < size; ++i) {
            ShapeGroup sg = shapes.get(i);
            contents.add(new ContentGroup(this.lottieDrawable, this, sg));
        }
        this.contentsForCharacter.put(character, contents);
        return contents;
    }

    private String codePointToString(String text, int startIndex) {
        int codePoint;
        int nextCodePoint;
        int index;
        int nextCodePointLength;
        int firstCodePoint = text.codePointAt(startIndex);
        int firstCodePointLength = Character.charCount(firstCodePoint);
        int key = firstCodePoint;
        for (index = startIndex + firstCodePointLength; index < text.length() && this.isModifier(nextCodePoint = text.codePointAt(index)); index += nextCodePointLength) {
            nextCodePointLength = Character.charCount(nextCodePoint);
            key = key * 31 + nextCodePoint;
        }
        if (this.codePointCache.containsKey((long)key)) {
            return (String)this.codePointCache.get((long)key);
        }
        this.stringBuilder.setLength(0);
        for (int i = startIndex; i < index; i += Character.charCount(codePoint)) {
            codePoint = text.codePointAt(i);
            this.stringBuilder.appendCodePoint(codePoint);
        }
        String str = this.stringBuilder.toString();
        this.codePointCache.put((long)key, (Object)str);
        return str;
    }

    private boolean isModifier(int codePoint) {
        return Character.getType(codePoint) == 16 || Character.getType(codePoint) == 27 || Character.getType(codePoint) == 6 || Character.getType(codePoint) == 28 || Character.getType(codePoint) == 19;
    }

    @Override
    public <T> void addValueCallback(T property, @Nullable LottieValueCallback<T> callback) {
        super.addValueCallback(property, callback);
        if (property == LottieProperty.COLOR) {
            if (this.colorAnimation != null) {
                this.colorAnimation.setValueCallback(callback);
            } else if (callback == null) {
                if (this.colorAnimation != null) {
                    this.removeAnimation(this.colorAnimation);
                }
                this.colorAnimation = null;
            } else {
                this.colorAnimation = new ValueCallbackKeyframeAnimation<Integer, T>(callback);
                this.colorAnimation.addUpdateListener(this);
                this.addAnimation(this.colorAnimation);
            }
        } else if (property == LottieProperty.STROKE_COLOR) {
            if (this.strokeColorAnimation != null) {
                this.strokeColorAnimation.setValueCallback(callback);
            } else if (callback == null) {
                if (this.strokeColorAnimation != null) {
                    this.removeAnimation(this.strokeColorAnimation);
                }
                this.strokeColorAnimation = null;
            } else {
                this.strokeColorAnimation = new ValueCallbackKeyframeAnimation<Integer, T>(callback);
                this.strokeColorAnimation.addUpdateListener(this);
                this.addAnimation(this.strokeColorAnimation);
            }
        } else if (property == LottieProperty.STROKE_WIDTH) {
            if (this.strokeWidthAnimation != null) {
                this.strokeWidthAnimation.setValueCallback(callback);
            } else if (callback == null) {
                if (this.strokeWidthAnimation != null) {
                    this.removeAnimation(this.strokeWidthAnimation);
                }
                this.strokeWidthAnimation = null;
            } else {
                this.strokeWidthAnimation = new ValueCallbackKeyframeAnimation<Float, T>(callback);
                this.strokeWidthAnimation.addUpdateListener(this);
                this.addAnimation(this.strokeWidthAnimation);
            }
        } else if (property == LottieProperty.TEXT_TRACKING) {
            if (this.trackingAnimation != null) {
                this.trackingAnimation.setValueCallback(callback);
            } else if (callback == null) {
                if (this.trackingAnimation != null) {
                    this.removeAnimation(this.trackingAnimation);
                }
                this.trackingAnimation = null;
            } else {
                this.trackingAnimation = new ValueCallbackKeyframeAnimation<Float, T>(callback);
                this.trackingAnimation.addUpdateListener(this);
                this.addAnimation(this.trackingAnimation);
            }
        } else if (property == LottieProperty.TEXT_SIZE) {
            if (callback == null) {
                if (this.textSizeAnimation != null) {
                    this.removeAnimation(this.textSizeAnimation);
                }
                this.textSizeAnimation = null;
            } else {
                this.textSizeAnimation = new ValueCallbackKeyframeAnimation<Float, T>(callback);
                this.textSizeAnimation.addUpdateListener(this);
                this.addAnimation(this.textSizeAnimation);
            }
        }
    }
}

