/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.model;

import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.collection.LruCache;
import com.airbnb.lottie.LottieComposition;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class LottieCompositionCache {
    private static final LottieCompositionCache INSTANCE = new LottieCompositionCache();
    private final LruCache<String, LottieComposition> cache = new LruCache(20);

    public static LottieCompositionCache getInstance() {
        return INSTANCE;
    }

    @VisibleForTesting
    LottieCompositionCache() {
    }

    @Nullable
    public LottieComposition get(@Nullable String cacheKey) {
        if (cacheKey == null) {
            return null;
        }
        return (LottieComposition)this.cache.get((Object)cacheKey);
    }

    public void put(@Nullable String cacheKey, LottieComposition composition) {
        if (cacheKey == null) {
            return;
        }
        this.cache.put((Object)cacheKey, (Object)composition);
    }

    public void clear() {
        this.cache.evictAll();
    }

    public void resize(int size) {
        this.cache.resize(size);
    }
}

