/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.network;

import android.content.Context;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import androidx.core.util.Pair;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.LottieCompositionFactory;
import com.airbnb.lottie.LottieResult;
import com.airbnb.lottie.network.FileExtension;
import com.airbnb.lottie.network.NetworkCache;
import com.airbnb.lottie.utils.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.zip.ZipInputStream;

public class NetworkFetcher {
    private final Context appContext;
    private final String url;
    @Nullable
    private final NetworkCache networkCache;

    public static LottieResult<LottieComposition> fetchSync(Context context, String url, @Nullable String cacheKey) {
        return new NetworkFetcher(context, url, cacheKey).fetchSync();
    }

    private NetworkFetcher(Context context, String url, @Nullable String cacheKey) {
        this.appContext = context.getApplicationContext();
        this.url = url;
        this.networkCache = cacheKey == null ? null : new NetworkCache(this.appContext);
    }

    @WorkerThread
    public LottieResult<LottieComposition> fetchSync() {
        LottieComposition result = this.fetchFromCache();
        if (result != null) {
            return new LottieResult<LottieComposition>(result);
        }
        Logger.debug("Animation for " + this.url + " not found in cache. Fetching from network.");
        return this.fetchFromNetwork();
    }

    @Nullable
    @WorkerThread
    private LottieComposition fetchFromCache() {
        if (this.networkCache == null) {
            return null;
        }
        Pair<FileExtension, InputStream> cacheResult = this.networkCache.fetch(this.url);
        if (cacheResult == null) {
            return null;
        }
        FileExtension extension = (FileExtension)((Object)cacheResult.first);
        InputStream inputStream = (InputStream)cacheResult.second;
        LottieResult<LottieComposition> result = extension == FileExtension.ZIP ? LottieCompositionFactory.fromZipStreamSync(new ZipInputStream(inputStream), this.url) : LottieCompositionFactory.fromJsonInputStreamSync(inputStream, this.url);
        if (result.getValue() != null) {
            return result.getValue();
        }
        return null;
    }

    @WorkerThread
    private LottieResult<LottieComposition> fetchFromNetwork() {
        try {
            return this.fetchFromNetworkInternal();
        }
        catch (IOException e) {
            return new LottieResult<LottieComposition>(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private LottieResult<LottieComposition> fetchFromNetworkInternal() throws IOException {
        Logger.debug("Fetching " + this.url);
        HttpURLConnection connection = (HttpURLConnection)new URL(this.url).openConnection();
        connection.setRequestMethod("GET");
        try {
            connection.connect();
            if (connection.getErrorStream() != null || connection.getResponseCode() != 200) {
                String error = this.getErrorFromConnection(connection);
                LottieResult<LottieComposition> lottieResult = new LottieResult<LottieComposition>(new IllegalArgumentException("Unable to fetch " + this.url + ". Failed with " + connection.getResponseCode() + "\n" + error));
                return lottieResult;
            }
            LottieResult<LottieComposition> result = this.getResultFromConnection(connection);
            Logger.debug("Completed fetch from network. Success: " + (result.getValue() != null));
            LottieResult<LottieComposition> lottieResult = result;
            return lottieResult;
        }
        catch (Exception e) {
            LottieResult<LottieComposition> lottieResult = new LottieResult<LottieComposition>(e);
            return lottieResult;
        }
        finally {
            connection.disconnect();
        }
    }

    private String getErrorFromConnection(HttpURLConnection connection) throws IOException {
        int responseCode = connection.getResponseCode();
        BufferedReader r = new BufferedReader(new InputStreamReader(connection.getErrorStream()));
        StringBuilder error = new StringBuilder();
        try {
            String line;
            while ((line = r.readLine()) != null) {
                error.append(line).append('\n');
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                r.close();
            }
            catch (Exception exception) {}
        }
        return error.toString();
    }

    @Nullable
    private LottieResult<LottieComposition> getResultFromConnection(HttpURLConnection connection) throws IOException {
        LottieResult<LottieComposition> result;
        FileExtension extension;
        String contentType = connection.getContentType();
        if (contentType == null) {
            contentType = "application/json";
        }
        if (contentType.contains("application/zip")) {
            Logger.debug("Handling zip response.");
            extension = FileExtension.ZIP;
            if (this.networkCache == null) {
                result = LottieCompositionFactory.fromZipStreamSync(new ZipInputStream(connection.getInputStream()), null);
            } else {
                File file = this.networkCache.writeTempCacheFile(this.url, connection.getInputStream(), extension);
                result = LottieCompositionFactory.fromZipStreamSync(new ZipInputStream(new FileInputStream(file)), this.url);
            }
        } else {
            Logger.debug("Received json response.");
            extension = FileExtension.JSON;
            if (this.networkCache == null) {
                result = LottieCompositionFactory.fromJsonInputStreamSync(connection.getInputStream(), null);
            } else {
                File file = this.networkCache.writeTempCacheFile(this.url, connection.getInputStream(), extension);
                result = LottieCompositionFactory.fromJsonInputStreamSync(new FileInputStream(new File(file.getAbsolutePath())), this.url);
            }
        }
        if (this.networkCache != null && result.getValue() != null) {
            this.networkCache.renameTempFile(this.url, extension);
        }
        return result;
    }
}

