/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.parser;

import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.model.animatable.AnimatableFloatValue;
import com.airbnb.lottie.model.animatable.AnimatableGradientColorValue;
import com.airbnb.lottie.model.animatable.AnimatableIntegerValue;
import com.airbnb.lottie.model.animatable.AnimatablePointValue;
import com.airbnb.lottie.model.content.GradientStroke;
import com.airbnb.lottie.model.content.GradientType;
import com.airbnb.lottie.model.content.ShapeStroke;
import com.airbnb.lottie.parser.AnimatableValueParser;
import com.airbnb.lottie.parser.moshi.JsonReader;
import com.airbnb.lottie.value.Keyframe;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;

class GradientStrokeParser {
    private static JsonReader.Options NAMES = JsonReader.Options.of("nm", "g", "o", "t", "s", "e", "w", "lc", "lj", "ml", "hd", "d");
    private static final JsonReader.Options GRADIENT_NAMES = JsonReader.Options.of("p", "k");
    private static final JsonReader.Options DASH_PATTERN_NAMES = JsonReader.Options.of("n", "v");

    private GradientStrokeParser() {
    }

    static GradientStroke parse(JsonReader reader, LottieComposition composition) throws IOException {
        String name = null;
        AnimatableGradientColorValue color = null;
        AnimatableIntegerValue opacity = null;
        GradientType gradientType = null;
        AnimatablePointValue startPoint = null;
        AnimatablePointValue endPoint = null;
        AnimatableFloatValue width = null;
        ShapeStroke.LineCapType capType = null;
        ShapeStroke.LineJoinType joinType = null;
        AnimatableFloatValue offset = null;
        float miterLimit = 0.0f;
        boolean hidden = false;
        ArrayList<AnimatableFloatValue> lineDashPattern = new ArrayList<AnimatableFloatValue>();
        block22: while (reader.hasNext()) {
            switch (reader.selectName(NAMES)) {
                case 0: {
                    name = reader.nextString();
                    continue block22;
                }
                case 1: {
                    int points = -1;
                    reader.beginObject();
                    block23: while (reader.hasNext()) {
                        switch (reader.selectName(GRADIENT_NAMES)) {
                            case 0: {
                                points = reader.nextInt();
                                continue block23;
                            }
                            case 1: {
                                color = AnimatableValueParser.parseGradientColor(reader, composition, points);
                                continue block23;
                            }
                        }
                        reader.skipName();
                        reader.skipValue();
                    }
                    reader.endObject();
                    continue block22;
                }
                case 2: {
                    opacity = AnimatableValueParser.parseInteger(reader, composition);
                    continue block22;
                }
                case 3: {
                    gradientType = reader.nextInt() == 1 ? GradientType.LINEAR : GradientType.RADIAL;
                    continue block22;
                }
                case 4: {
                    startPoint = AnimatableValueParser.parsePoint(reader, composition);
                    continue block22;
                }
                case 5: {
                    endPoint = AnimatableValueParser.parsePoint(reader, composition);
                    continue block22;
                }
                case 6: {
                    width = AnimatableValueParser.parseFloat(reader, composition);
                    continue block22;
                }
                case 7: {
                    capType = ShapeStroke.LineCapType.values()[reader.nextInt() - 1];
                    continue block22;
                }
                case 8: {
                    joinType = ShapeStroke.LineJoinType.values()[reader.nextInt() - 1];
                    continue block22;
                }
                case 9: {
                    miterLimit = (float)reader.nextDouble();
                    continue block22;
                }
                case 10: {
                    hidden = reader.nextBoolean();
                    continue block22;
                }
                case 11: {
                    reader.beginArray();
                    while (reader.hasNext()) {
                        String n = null;
                        AnimatableFloatValue val = null;
                        reader.beginObject();
                        block25: while (reader.hasNext()) {
                            switch (reader.selectName(DASH_PATTERN_NAMES)) {
                                case 0: {
                                    n = reader.nextString();
                                    continue block25;
                                }
                                case 1: {
                                    val = AnimatableValueParser.parseFloat(reader, composition);
                                    continue block25;
                                }
                            }
                            reader.skipName();
                            reader.skipValue();
                        }
                        reader.endObject();
                        if (n.equals("o")) {
                            offset = val;
                            continue;
                        }
                        if (!n.equals("d") && !n.equals("g")) continue;
                        composition.setHasDashPattern(true);
                        lineDashPattern.add(val);
                    }
                    reader.endArray();
                    if (lineDashPattern.size() != 1) continue block22;
                    lineDashPattern.add((AnimatableFloatValue)lineDashPattern.get(0));
                    continue block22;
                }
            }
            reader.skipName();
            reader.skipValue();
        }
        opacity = opacity == null ? new AnimatableIntegerValue(Collections.singletonList(new Keyframe<Integer>(100))) : opacity;
        return new GradientStroke(name, gradientType, color, opacity, startPoint, endPoint, width, capType, joinType, miterLimit, lineDashPattern, offset, hidden);
    }
}

