/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.parser;

import android.graphics.PointF;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import androidx.annotation.Nullable;
import androidx.collection.SparseArrayCompat;
import androidx.core.view.animation.PathInterpolatorCompat;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.parser.JsonUtils;
import com.airbnb.lottie.parser.ValueParser;
import com.airbnb.lottie.parser.moshi.JsonReader;
import com.airbnb.lottie.utils.MiscUtils;
import com.airbnb.lottie.utils.Utils;
import com.airbnb.lottie.value.Keyframe;
import java.io.IOException;
import java.lang.ref.WeakReference;

class KeyframeParser {
    private static final float MAX_CP_VALUE = 100.0f;
    private static final Interpolator LINEAR_INTERPOLATOR = new LinearInterpolator();
    private static SparseArrayCompat<WeakReference<Interpolator>> pathInterpolatorCache;
    static JsonReader.Options NAMES;
    static JsonReader.Options INTERPOLATOR_NAMES;

    KeyframeParser() {
    }

    private static SparseArrayCompat<WeakReference<Interpolator>> pathInterpolatorCache() {
        if (pathInterpolatorCache == null) {
            pathInterpolatorCache = new SparseArrayCompat();
        }
        return pathInterpolatorCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static WeakReference<Interpolator> getInterpolator(int hash) {
        Class<KeyframeParser> clazz = KeyframeParser.class;
        synchronized (KeyframeParser.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return (WeakReference)KeyframeParser.pathInterpolatorCache().get(hash);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putInterpolator(int hash, WeakReference<Interpolator> interpolator) {
        Class<KeyframeParser> clazz = KeyframeParser.class;
        synchronized (KeyframeParser.class) {
            pathInterpolatorCache.put(hash, interpolator);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    static <T> Keyframe<T> parse(JsonReader reader, LottieComposition composition, float scale, ValueParser<T> valueParser, boolean animated, boolean multiDimensional) throws IOException {
        if (animated && multiDimensional) {
            return KeyframeParser.parseMultiDimensionalKeyframe(composition, reader, scale, valueParser);
        }
        if (animated) {
            return KeyframeParser.parseKeyframe(composition, reader, scale, valueParser);
        }
        return KeyframeParser.parseStaticValue(reader, scale, valueParser);
    }

    private static <T> Keyframe<T> parseKeyframe(LottieComposition composition, JsonReader reader, float scale, ValueParser<T> valueParser) throws IOException {
        PointF cp1 = null;
        PointF cp2 = null;
        float startFrame = 0.0f;
        Object startValue = null;
        Object endValue = null;
        boolean hold = false;
        Interpolator interpolator = null;
        PointF pathCp1 = null;
        PointF pathCp2 = null;
        reader.beginObject();
        block10: while (reader.hasNext()) {
            switch (reader.selectName(NAMES)) {
                case 0: {
                    startFrame = (float)reader.nextDouble();
                    continue block10;
                }
                case 1: {
                    startValue = valueParser.parse(reader, scale);
                    continue block10;
                }
                case 2: {
                    endValue = valueParser.parse(reader, scale);
                    continue block10;
                }
                case 3: {
                    cp1 = JsonUtils.jsonToPoint(reader, 1.0f);
                    continue block10;
                }
                case 4: {
                    cp2 = JsonUtils.jsonToPoint(reader, 1.0f);
                    continue block10;
                }
                case 5: {
                    hold = reader.nextInt() == 1;
                    continue block10;
                }
                case 6: {
                    pathCp1 = JsonUtils.jsonToPoint(reader, scale);
                    continue block10;
                }
                case 7: {
                    pathCp2 = JsonUtils.jsonToPoint(reader, scale);
                    continue block10;
                }
            }
            reader.skipValue();
        }
        reader.endObject();
        if (hold) {
            endValue = startValue;
            interpolator = LINEAR_INTERPOLATOR;
        } else {
            interpolator = cp1 != null && cp2 != null ? KeyframeParser.interpolatorFor(cp1, cp2) : LINEAR_INTERPOLATOR;
        }
        Keyframe<Object> keyframe = new Keyframe<Object>(composition, startValue, endValue, interpolator, startFrame, null);
        keyframe.pathCp1 = pathCp1;
        keyframe.pathCp2 = pathCp2;
        return keyframe;
    }

    private static <T> Keyframe<T> parseMultiDimensionalKeyframe(LottieComposition composition, JsonReader reader, float scale, ValueParser<T> valueParser) throws IOException {
        PointF cp1 = null;
        PointF cp2 = null;
        PointF xCp1 = null;
        PointF xCp2 = null;
        PointF yCp1 = null;
        PointF yCp2 = null;
        float startFrame = 0.0f;
        Object startValue = null;
        Object endValue = null;
        boolean hold = false;
        Interpolator interpolator = null;
        Interpolator xInterpolator = null;
        Interpolator yInterpolator = null;
        PointF pathCp1 = null;
        PointF pathCp2 = null;
        reader.beginObject();
        block18: while (reader.hasNext()) {
            switch (reader.selectName(NAMES)) {
                case 0: {
                    startFrame = (float)reader.nextDouble();
                    continue block18;
                }
                case 1: {
                    startValue = valueParser.parse(reader, scale);
                    continue block18;
                }
                case 2: {
                    endValue = valueParser.parse(reader, scale);
                    continue block18;
                }
                case 3: {
                    if (reader.peek() == JsonReader.Token.BEGIN_OBJECT) {
                        reader.beginObject();
                        float xCp1x = 0.0f;
                        float xCp1y = 0.0f;
                        float yCp1x = 0.0f;
                        float yCp1y = 0.0f;
                        block19: while (reader.hasNext()) {
                            switch (reader.selectName(INTERPOLATOR_NAMES)) {
                                case 0: {
                                    if (reader.peek() == JsonReader.Token.NUMBER) {
                                        yCp1x = xCp1x = (float)reader.nextDouble();
                                        continue block19;
                                    }
                                    reader.beginArray();
                                    xCp1x = (float)reader.nextDouble();
                                    yCp1x = reader.peek() == JsonReader.Token.NUMBER ? (float)reader.nextDouble() : xCp1x;
                                    reader.endArray();
                                    continue block19;
                                }
                                case 1: {
                                    if (reader.peek() == JsonReader.Token.NUMBER) {
                                        yCp1y = xCp1y = (float)reader.nextDouble();
                                        continue block19;
                                    }
                                    reader.beginArray();
                                    xCp1y = (float)reader.nextDouble();
                                    yCp1y = reader.peek() == JsonReader.Token.NUMBER ? (float)reader.nextDouble() : xCp1y;
                                    reader.endArray();
                                    continue block19;
                                }
                            }
                            reader.skipValue();
                        }
                        xCp1 = new PointF(xCp1x, xCp1y);
                        yCp1 = new PointF(yCp1x, yCp1y);
                        reader.endObject();
                        continue block18;
                    }
                    cp1 = JsonUtils.jsonToPoint(reader, scale);
                    continue block18;
                }
                case 4: {
                    if (reader.peek() == JsonReader.Token.BEGIN_OBJECT) {
                        reader.beginObject();
                        float xCp2x = 0.0f;
                        float xCp2y = 0.0f;
                        float yCp2x = 0.0f;
                        float yCp2y = 0.0f;
                        block20: while (reader.hasNext()) {
                            switch (reader.selectName(INTERPOLATOR_NAMES)) {
                                case 0: {
                                    if (reader.peek() == JsonReader.Token.NUMBER) {
                                        yCp2x = xCp2x = (float)reader.nextDouble();
                                        continue block20;
                                    }
                                    reader.beginArray();
                                    xCp2x = (float)reader.nextDouble();
                                    yCp2x = reader.peek() == JsonReader.Token.NUMBER ? (float)reader.nextDouble() : xCp2x;
                                    reader.endArray();
                                    continue block20;
                                }
                                case 1: {
                                    if (reader.peek() == JsonReader.Token.NUMBER) {
                                        yCp2y = xCp2y = (float)reader.nextDouble();
                                        continue block20;
                                    }
                                    reader.beginArray();
                                    xCp2y = (float)reader.nextDouble();
                                    yCp2y = reader.peek() == JsonReader.Token.NUMBER ? (float)reader.nextDouble() : xCp2y;
                                    reader.endArray();
                                    continue block20;
                                }
                            }
                            reader.skipValue();
                        }
                        xCp2 = new PointF(xCp2x, xCp2y);
                        yCp2 = new PointF(yCp2x, yCp2y);
                        reader.endObject();
                        continue block18;
                    }
                    cp2 = JsonUtils.jsonToPoint(reader, scale);
                    continue block18;
                }
                case 5: {
                    hold = reader.nextInt() == 1;
                    continue block18;
                }
                case 6: {
                    pathCp1 = JsonUtils.jsonToPoint(reader, scale);
                    continue block18;
                }
                case 7: {
                    pathCp2 = JsonUtils.jsonToPoint(reader, scale);
                    continue block18;
                }
            }
            reader.skipValue();
        }
        reader.endObject();
        if (hold) {
            endValue = startValue;
            interpolator = LINEAR_INTERPOLATOR;
        } else if (cp1 != null && cp2 != null) {
            interpolator = KeyframeParser.interpolatorFor(cp1, cp2);
        } else if (xCp1 != null && yCp1 != null && xCp2 != null && yCp2 != null) {
            xInterpolator = KeyframeParser.interpolatorFor(xCp1, xCp2);
            yInterpolator = KeyframeParser.interpolatorFor(yCp1, yCp2);
        } else {
            interpolator = LINEAR_INTERPOLATOR;
        }
        Keyframe<Object> keyframe = xInterpolator != null && yInterpolator != null ? new Keyframe<Object>(composition, startValue, endValue, xInterpolator, yInterpolator, startFrame, null) : new Keyframe<Object>(composition, startValue, endValue, interpolator, startFrame, null);
        keyframe.pathCp1 = pathCp1;
        keyframe.pathCp2 = pathCp2;
        return keyframe;
    }

    private static Interpolator interpolatorFor(PointF cp1, PointF cp2) {
        Object interpolator = null;
        cp1.x = MiscUtils.clamp(cp1.x, -1.0f, 1.0f);
        cp1.y = MiscUtils.clamp(cp1.y, -100.0f, 100.0f);
        cp2.x = MiscUtils.clamp(cp2.x, -1.0f, 1.0f);
        cp2.y = MiscUtils.clamp(cp2.y, -100.0f, 100.0f);
        int hash = Utils.hashFor(cp1.x, cp1.y, cp2.x, cp2.y);
        WeakReference<Interpolator> interpolatorRef = KeyframeParser.getInterpolator(hash);
        if (interpolatorRef != null) {
            interpolator = (Interpolator)interpolatorRef.get();
        }
        if (interpolatorRef == null || interpolator == null) {
            try {
                interpolator = PathInterpolatorCompat.create((float)cp1.x, (float)cp1.y, (float)cp2.x, (float)cp2.y);
            }
            catch (IllegalArgumentException e) {
                interpolator = "The Path cannot loop back on itself.".equals(e.getMessage()) ? PathInterpolatorCompat.create((float)Math.min(cp1.x, 1.0f), (float)cp1.y, (float)Math.max(cp2.x, 0.0f), (float)cp2.y) : new LinearInterpolator();
            }
            try {
                KeyframeParser.putInterpolator(hash, new WeakReference<Interpolator>((Interpolator)interpolator));
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return interpolator;
    }

    private static <T> Keyframe<T> parseStaticValue(JsonReader reader, float scale, ValueParser<T> valueParser) throws IOException {
        T value = valueParser.parse(reader, scale);
        return new Keyframe<T>(value);
    }

    static {
        NAMES = JsonReader.Options.of("t", "s", "e", "o", "i", "h", "to", "ti");
        INTERPOLATOR_NAMES = JsonReader.Options.of("x", "y");
    }
}

