/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.model.layer;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.RectF;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.airbnb.lottie.LottieDrawable;
import com.airbnb.lottie.animation.content.ContentGroup;
import com.airbnb.lottie.model.KeyPath;
import com.airbnb.lottie.model.content.BlurEffect;
import com.airbnb.lottie.model.content.ShapeGroup;
import com.airbnb.lottie.model.layer.BaseLayer;
import com.airbnb.lottie.model.layer.CompositionLayer;
import com.airbnb.lottie.model.layer.Layer;
import com.airbnb.lottie.parser.DropShadowEffect;
import java.util.Collections;
import java.util.List;

public class ShapeLayer
extends BaseLayer {
    private final ContentGroup contentGroup;
    private final CompositionLayer compositionLayer;

    ShapeLayer(LottieDrawable lottieDrawable, Layer layerModel, CompositionLayer compositionLayer) {
        super(lottieDrawable, layerModel);
        this.compositionLayer = compositionLayer;
        ShapeGroup shapeGroup = new ShapeGroup("__container", layerModel.getShapes(), false);
        this.contentGroup = new ContentGroup(lottieDrawable, this, shapeGroup);
        this.contentGroup.setContents(Collections.emptyList(), Collections.emptyList());
    }

    @Override
    void drawLayer(@NonNull Canvas canvas, Matrix parentMatrix, int parentAlpha) {
        this.contentGroup.draw(canvas, parentMatrix, parentAlpha);
    }

    @Override
    public void getBounds(RectF outBounds, Matrix parentMatrix, boolean applyParents) {
        super.getBounds(outBounds, parentMatrix, applyParents);
        this.contentGroup.getBounds(outBounds, this.boundsMatrix, applyParents);
    }

    @Override
    @Nullable
    public BlurEffect getBlurEffect() {
        BlurEffect layerBlur = super.getBlurEffect();
        if (layerBlur != null) {
            return layerBlur;
        }
        return this.compositionLayer.getBlurEffect();
    }

    @Override
    @Nullable
    public DropShadowEffect getDropShadowEffect() {
        DropShadowEffect layerDropShadow = super.getDropShadowEffect();
        if (layerDropShadow != null) {
            return layerDropShadow;
        }
        return this.compositionLayer.getDropShadowEffect();
    }

    @Override
    protected void resolveChildKeyPath(KeyPath keyPath, int depth, List<KeyPath> accumulator, KeyPath currentPartialKeyPath) {
        this.contentGroup.resolveKeyPath(keyPath, depth, accumulator, currentPartialKeyPath);
    }
}

