/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.ImageView;
import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import com.airbnb.lottie.AsyncUpdates;
import com.airbnb.lottie.FontAssetDelegate;
import com.airbnb.lottie.ImageAssetDelegate;
import com.airbnb.lottie.L;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.LottieImageAsset;
import com.airbnb.lottie.LottieProperty;
import com.airbnb.lottie.PerformanceTracker;
import com.airbnb.lottie.RenderMode;
import com.airbnb.lottie.TextDelegate;
import com.airbnb.lottie.animation.LPaint;
import com.airbnb.lottie.manager.FontAssetManager;
import com.airbnb.lottie.manager.ImageAssetManager;
import com.airbnb.lottie.model.Font;
import com.airbnb.lottie.model.KeyPath;
import com.airbnb.lottie.model.Marker;
import com.airbnb.lottie.model.layer.CompositionLayer;
import com.airbnb.lottie.parser.LayerParser;
import com.airbnb.lottie.utils.Logger;
import com.airbnb.lottie.utils.LottieThreadFactory;
import com.airbnb.lottie.utils.LottieValueAnimator;
import com.airbnb.lottie.utils.MiscUtils;
import com.airbnb.lottie.value.LottieFrameInfo;
import com.airbnb.lottie.value.LottieValueCallback;
import com.airbnb.lottie.value.SimpleLottieValueCallback;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class LottieDrawable
extends Drawable
implements Drawable.Callback,
Animatable {
    private static final boolean invalidateSelfOnMainThread = Build.VERSION.SDK_INT <= 25;
    private LottieComposition composition;
    private final LottieValueAnimator animator = new LottieValueAnimator();
    private boolean systemAnimationsEnabled = true;
    private boolean ignoreSystemAnimationsDisabled = false;
    private boolean safeMode = false;
    private OnVisibleAction onVisibleAction = OnVisibleAction.NONE;
    private final ArrayList<LazyCompositionTask> lazyCompositionTasks = new ArrayList();
    @Nullable
    private ImageAssetManager imageAssetManager;
    @Nullable
    private String imageAssetsFolder;
    @Nullable
    private ImageAssetDelegate imageAssetDelegate;
    @Nullable
    private FontAssetManager fontAssetManager;
    @Nullable
    private Map<String, Typeface> fontMap;
    @Nullable
    String defaultFontFileExtension;
    @Nullable
    FontAssetDelegate fontAssetDelegate;
    @Nullable
    TextDelegate textDelegate;
    private boolean enableMergePaths;
    private boolean maintainOriginalImageBounds = false;
    private boolean clipToCompositionBounds = true;
    @Nullable
    private CompositionLayer compositionLayer;
    private int alpha = 255;
    private boolean performanceTrackingEnabled;
    private boolean outlineMasksAndMattes;
    private boolean isApplyingOpacityToLayersEnabled;
    private RenderMode renderMode = RenderMode.AUTOMATIC;
    private boolean useSoftwareRendering = false;
    private final Matrix renderingMatrix = new Matrix();
    private Bitmap softwareRenderingBitmap;
    private Canvas softwareRenderingCanvas;
    private Rect canvasClipBounds;
    private RectF canvasClipBoundsRectF;
    private Paint softwareRenderingPaint;
    private Rect softwareRenderingSrcBoundsRect;
    private Rect softwareRenderingDstBoundsRect;
    private RectF softwareRenderingDstBoundsRectF;
    private RectF softwareRenderingTransformedBounds;
    private Matrix softwareRenderingOriginalCanvasMatrix;
    private Matrix softwareRenderingOriginalCanvasMatrixInverse;
    private boolean isDirty = false;
    @Nullable
    private AsyncUpdates asyncUpdates;
    private final ValueAnimator.AnimatorUpdateListener progressUpdateListener = animation -> {
        if (this.getAsyncUpdatesEnabled()) {
            this.invalidateSelf();
        } else if (this.compositionLayer != null) {
            this.compositionLayer.setProgress(this.animator.getAnimatedValueAbsolute());
        }
    };
    private final Semaphore setProgressDrawLock = new Semaphore(1);
    private static final Executor setProgressExecutor = new ThreadPoolExecutor(0, 2, 35L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new LottieThreadFactory());
    private Handler mainThreadHandler;
    private Runnable invalidateSelfRunnable;
    private final Runnable updateProgressRunnable = () -> {
        CompositionLayer compositionLayer = this.compositionLayer;
        if (compositionLayer == null) {
            return;
        }
        try {
            this.setProgressDrawLock.acquire();
            compositionLayer.setProgress(this.animator.getAnimatedValueAbsolute());
            if (invalidateSelfOnMainThread && this.isDirty) {
                if (this.mainThreadHandler == null) {
                    this.mainThreadHandler = new Handler(Looper.getMainLooper());
                    this.invalidateSelfRunnable = () -> {
                        Drawable.Callback callback = this.getCallback();
                        if (callback != null) {
                            callback.invalidateDrawable((Drawable)this);
                        }
                    };
                }
                this.mainThreadHandler.post(this.invalidateSelfRunnable);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.setProgressDrawLock.release();
        }
    };
    private float lastDrawnProgress = -3.4028235E38f;
    private static final float MAX_DELTA_MS_ASYNC_SET_PROGRESS = 50.0f;
    public static final int RESTART = 1;
    public static final int REVERSE = 2;
    public static final int INFINITE = -1;

    public LottieDrawable() {
        this.animator.addUpdateListener(this.progressUpdateListener);
    }

    public boolean hasMasks() {
        return this.compositionLayer != null && this.compositionLayer.hasMasks();
    }

    public boolean hasMatte() {
        return this.compositionLayer != null && this.compositionLayer.hasMatte();
    }

    public boolean enableMergePathsForKitKatAndAbove() {
        return this.enableMergePaths;
    }

    public void enableMergePathsForKitKatAndAbove(boolean enable) {
        if (this.enableMergePaths == enable) {
            return;
        }
        if (Build.VERSION.SDK_INT < 19) {
            Logger.warning("Merge paths are not supported pre-Kit Kat.");
            return;
        }
        this.enableMergePaths = enable;
        if (this.composition != null) {
            this.buildCompositionLayer();
        }
    }

    public boolean isMergePathsEnabledForKitKatAndAbove() {
        return this.enableMergePaths;
    }

    public void setClipToCompositionBounds(boolean clipToCompositionBounds) {
        if (clipToCompositionBounds != this.clipToCompositionBounds) {
            this.clipToCompositionBounds = clipToCompositionBounds;
            CompositionLayer compositionLayer = this.compositionLayer;
            if (compositionLayer != null) {
                compositionLayer.setClipToCompositionBounds(clipToCompositionBounds);
            }
            this.invalidateSelf();
        }
    }

    public boolean getClipToCompositionBounds() {
        return this.clipToCompositionBounds;
    }

    public void setImagesAssetsFolder(@Nullable String imageAssetsFolder) {
        this.imageAssetsFolder = imageAssetsFolder;
    }

    @Nullable
    public String getImageAssetsFolder() {
        return this.imageAssetsFolder;
    }

    public void setMaintainOriginalImageBounds(boolean maintainOriginalImageBounds) {
        this.maintainOriginalImageBounds = maintainOriginalImageBounds;
    }

    public boolean getMaintainOriginalImageBounds() {
        return this.maintainOriginalImageBounds;
    }

    public boolean setComposition(LottieComposition composition) {
        if (this.composition == composition) {
            return false;
        }
        this.isDirty = true;
        this.clearComposition();
        this.composition = composition;
        this.buildCompositionLayer();
        this.animator.setComposition(composition);
        this.setProgress(this.animator.getAnimatedFraction());
        Iterator<LazyCompositionTask> it = new ArrayList<LazyCompositionTask>(this.lazyCompositionTasks).iterator();
        while (it.hasNext()) {
            LazyCompositionTask t = it.next();
            if (t != null) {
                t.run(composition);
            }
            it.remove();
        }
        this.lazyCompositionTasks.clear();
        composition.setPerformanceTrackingEnabled(this.performanceTrackingEnabled);
        this.computeRenderMode();
        Drawable.Callback callback = this.getCallback();
        if (callback instanceof ImageView) {
            ((ImageView)callback).setImageDrawable(null);
            ((ImageView)callback).setImageDrawable((Drawable)this);
        }
        return true;
    }

    public void setRenderMode(RenderMode renderMode) {
        this.renderMode = renderMode;
        this.computeRenderMode();
    }

    public AsyncUpdates getAsyncUpdates() {
        AsyncUpdates asyncUpdates = this.asyncUpdates;
        if (asyncUpdates != null) {
            return asyncUpdates;
        }
        return L.getDefaultAsyncUpdates();
    }

    public boolean getAsyncUpdatesEnabled() {
        return this.getAsyncUpdates() == AsyncUpdates.ENABLED;
    }

    public void setAsyncUpdates(@Nullable AsyncUpdates asyncUpdates) {
        this.asyncUpdates = asyncUpdates;
    }

    public RenderMode getRenderMode() {
        return this.useSoftwareRendering ? RenderMode.SOFTWARE : RenderMode.HARDWARE;
    }

    private void computeRenderMode() {
        LottieComposition composition = this.composition;
        if (composition == null) {
            return;
        }
        this.useSoftwareRendering = this.renderMode.useSoftwareRendering(Build.VERSION.SDK_INT, composition.hasDashPattern(), composition.getMaskAndMatteCount());
    }

    public void setPerformanceTrackingEnabled(boolean enabled) {
        this.performanceTrackingEnabled = enabled;
        if (this.composition != null) {
            this.composition.setPerformanceTrackingEnabled(enabled);
        }
    }

    public void setOutlineMasksAndMattes(boolean outline) {
        if (this.outlineMasksAndMattes == outline) {
            return;
        }
        this.outlineMasksAndMattes = outline;
        if (this.compositionLayer != null) {
            this.compositionLayer.setOutlineMasksAndMattes(outline);
        }
    }

    @Nullable
    public PerformanceTracker getPerformanceTracker() {
        if (this.composition != null) {
            return this.composition.getPerformanceTracker();
        }
        return null;
    }

    public void setApplyingOpacityToLayersEnabled(boolean isApplyingOpacityToLayersEnabled) {
        this.isApplyingOpacityToLayersEnabled = isApplyingOpacityToLayersEnabled;
    }

    @Deprecated
    public void disableExtraScaleModeInFitXY() {
    }

    public boolean isApplyingOpacityToLayersEnabled() {
        return this.isApplyingOpacityToLayersEnabled;
    }

    private void buildCompositionLayer() {
        LottieComposition composition = this.composition;
        if (composition == null) {
            return;
        }
        this.compositionLayer = new CompositionLayer(this, LayerParser.parse(composition), composition.getLayers(), composition);
        if (this.outlineMasksAndMattes) {
            this.compositionLayer.setOutlineMasksAndMattes(true);
        }
        this.compositionLayer.setClipToCompositionBounds(this.clipToCompositionBounds);
    }

    public void clearComposition() {
        if (this.animator.isRunning()) {
            this.animator.cancel();
            if (!this.isVisible()) {
                this.onVisibleAction = OnVisibleAction.NONE;
            }
        }
        this.composition = null;
        this.compositionLayer = null;
        this.imageAssetManager = null;
        this.lastDrawnProgress = -3.4028235E38f;
        this.animator.clearComposition();
        this.invalidateSelf();
    }

    public void setSafeMode(boolean safeMode) {
        this.safeMode = safeMode;
    }

    public void invalidateSelf() {
        if (this.isDirty) {
            return;
        }
        this.isDirty = true;
        if (invalidateSelfOnMainThread && Looper.getMainLooper() != Looper.myLooper()) {
            return;
        }
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.invalidateDrawable((Drawable)this);
        }
    }

    public void setAlpha(@IntRange(from=0L, to=255L) int alpha) {
        this.alpha = alpha;
        this.invalidateSelf();
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        Logger.warning("Use addColorFilter instead.");
    }

    public int getOpacity() {
        return -3;
    }

    private boolean shouldSetProgressBeforeDrawing() {
        float currentProgress;
        LottieComposition composition = this.composition;
        if (composition == null) {
            return false;
        }
        float lastDrawnProgress = this.lastDrawnProgress;
        this.lastDrawnProgress = currentProgress = this.animator.getAnimatedValueAbsolute();
        float duration = composition.getDuration();
        float deltaProgress = Math.abs(currentProgress - lastDrawnProgress);
        float deltaMs = deltaProgress * duration;
        return deltaMs >= 50.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(@NonNull Canvas canvas) {
        CompositionLayer compositionLayer = this.compositionLayer;
        if (compositionLayer == null) {
            return;
        }
        boolean asyncUpdatesEnabled = this.getAsyncUpdatesEnabled();
        try {
            block17: {
                if (asyncUpdatesEnabled) {
                    this.setProgressDrawLock.acquire();
                }
                L.beginSection("Drawable#draw");
                if (asyncUpdatesEnabled && this.shouldSetProgressBeforeDrawing()) {
                    this.setProgress(this.animator.getAnimatedValueAbsolute());
                }
                if (this.safeMode) {
                    try {
                        if (this.useSoftwareRendering) {
                            this.renderAndDrawAsBitmap(canvas, compositionLayer);
                            break block17;
                        }
                        this.drawDirectlyToCanvas(canvas);
                    }
                    catch (Throwable e) {
                        Logger.error("Lottie crashed in draw!", e);
                    }
                } else if (this.useSoftwareRendering) {
                    this.renderAndDrawAsBitmap(canvas, compositionLayer);
                } else {
                    this.drawDirectlyToCanvas(canvas);
                }
            }
            this.isDirty = false;
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            L.endSection("Drawable#draw");
            if (asyncUpdatesEnabled) {
                this.setProgressDrawLock.release();
                if (compositionLayer.getProgress() != this.animator.getAnimatedValueAbsolute()) {
                    setProgressExecutor.execute(this.updateProgressRunnable);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void draw(Canvas canvas, Matrix matrix) {
        CompositionLayer compositionLayer = this.compositionLayer;
        LottieComposition composition = this.composition;
        if (compositionLayer == null || composition == null) {
            return;
        }
        boolean asyncUpdatesEnabled = this.getAsyncUpdatesEnabled();
        try {
            if (asyncUpdatesEnabled) {
                this.setProgressDrawLock.acquire();
                if (this.shouldSetProgressBeforeDrawing()) {
                    this.setProgress(this.animator.getAnimatedValueAbsolute());
                }
            }
            if (this.useSoftwareRendering) {
                canvas.save();
                canvas.concat(matrix);
                this.renderAndDrawAsBitmap(canvas, compositionLayer);
                canvas.restore();
            } else {
                compositionLayer.draw(canvas, matrix, this.alpha);
            }
            this.isDirty = false;
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            if (asyncUpdatesEnabled) {
                this.setProgressDrawLock.release();
                if (compositionLayer.getProgress() != this.animator.getAnimatedValueAbsolute()) {
                    setProgressExecutor.execute(this.updateProgressRunnable);
                }
            }
        }
    }

    @MainThread
    public void start() {
        Drawable.Callback callback = this.getCallback();
        if (callback instanceof View && ((View)callback).isInEditMode()) {
            return;
        }
        this.playAnimation();
    }

    @MainThread
    public void stop() {
        this.endAnimation();
    }

    public boolean isRunning() {
        return this.isAnimating();
    }

    @MainThread
    public void playAnimation() {
        if (this.compositionLayer == null) {
            this.lazyCompositionTasks.add(c -> this.playAnimation());
            return;
        }
        this.computeRenderMode();
        if (this.animationsEnabled() || this.getRepeatCount() == 0) {
            if (this.isVisible()) {
                this.animator.playAnimation();
                this.onVisibleAction = OnVisibleAction.NONE;
            } else {
                this.onVisibleAction = OnVisibleAction.PLAY;
            }
        }
        if (!this.animationsEnabled()) {
            this.setFrame((int)(this.getSpeed() < 0.0f ? this.getMinFrame() : this.getMaxFrame()));
            this.animator.endAnimation();
            if (!this.isVisible()) {
                this.onVisibleAction = OnVisibleAction.NONE;
            }
        }
    }

    @MainThread
    public void endAnimation() {
        this.lazyCompositionTasks.clear();
        this.animator.endAnimation();
        if (!this.isVisible()) {
            this.onVisibleAction = OnVisibleAction.NONE;
        }
    }

    @MainThread
    public void resumeAnimation() {
        if (this.compositionLayer == null) {
            this.lazyCompositionTasks.add(c -> this.resumeAnimation());
            return;
        }
        this.computeRenderMode();
        if (this.animationsEnabled() || this.getRepeatCount() == 0) {
            if (this.isVisible()) {
                this.animator.resumeAnimation();
                this.onVisibleAction = OnVisibleAction.NONE;
            } else {
                this.onVisibleAction = OnVisibleAction.RESUME;
            }
        }
        if (!this.animationsEnabled()) {
            this.setFrame((int)(this.getSpeed() < 0.0f ? this.getMinFrame() : this.getMaxFrame()));
            this.animator.endAnimation();
            if (!this.isVisible()) {
                this.onVisibleAction = OnVisibleAction.NONE;
            }
        }
    }

    public void setMinFrame(int minFrame) {
        if (this.composition == null) {
            this.lazyCompositionTasks.add(c -> this.setMinFrame(minFrame));
            return;
        }
        this.animator.setMinFrame(minFrame);
    }

    public float getMinFrame() {
        return this.animator.getMinFrame();
    }

    public void setMinProgress(float minProgress) {
        if (this.composition == null) {
            this.lazyCompositionTasks.add(c -> this.setMinProgress(minProgress));
            return;
        }
        this.setMinFrame((int)MiscUtils.lerp(this.composition.getStartFrame(), this.composition.getEndFrame(), minProgress));
    }

    public void setMaxFrame(int maxFrame) {
        if (this.composition == null) {
            this.lazyCompositionTasks.add(c -> this.setMaxFrame(maxFrame));
            return;
        }
        this.animator.setMaxFrame((float)maxFrame + 0.99f);
    }

    public float getMaxFrame() {
        return this.animator.getMaxFrame();
    }

    public void setMaxProgress(@FloatRange(from=0.0, to=1.0) float maxProgress) {
        if (this.composition == null) {
            this.lazyCompositionTasks.add(c -> this.setMaxProgress(maxProgress));
            return;
        }
        this.animator.setMaxFrame(MiscUtils.lerp(this.composition.getStartFrame(), this.composition.getEndFrame(), maxProgress));
    }

    public void setMinFrame(String markerName) {
        if (this.composition == null) {
            this.lazyCompositionTasks.add(c -> this.setMinFrame(markerName));
            return;
        }
        Marker marker = this.composition.getMarker(markerName);
        if (marker == null) {
            throw new IllegalArgumentException("Cannot find marker with name " + markerName + ".");
        }
        this.setMinFrame((int)marker.startFrame);
    }

    public void setMaxFrame(String markerName) {
        if (this.composition == null) {
            this.lazyCompositionTasks.add(c -> this.setMaxFrame(markerName));
            return;
        }
        Marker marker = this.composition.getMarker(markerName);
        if (marker == null) {
            throw new IllegalArgumentException("Cannot find marker with name " + markerName + ".");
        }
        this.setMaxFrame((int)(marker.startFrame + marker.durationFrames));
    }

    public void setMinAndMaxFrame(String markerName) {
        if (this.composition == null) {
            this.lazyCompositionTasks.add(c -> this.setMinAndMaxFrame(markerName));
            return;
        }
        Marker marker = this.composition.getMarker(markerName);
        if (marker == null) {
            throw new IllegalArgumentException("Cannot find marker with name " + markerName + ".");
        }
        int startFrame = (int)marker.startFrame;
        this.setMinAndMaxFrame(startFrame, startFrame + (int)marker.durationFrames);
    }

    public void setMinAndMaxFrame(String startMarkerName, String endMarkerName, boolean playEndMarkerStartFrame) {
        if (this.composition == null) {
            this.lazyCompositionTasks.add(c -> this.setMinAndMaxFrame(startMarkerName, endMarkerName, playEndMarkerStartFrame));
            return;
        }
        Marker startMarker = this.composition.getMarker(startMarkerName);
        if (startMarker == null) {
            throw new IllegalArgumentException("Cannot find marker with name " + startMarkerName + ".");
        }
        int startFrame = (int)startMarker.startFrame;
        Marker endMarker = this.composition.getMarker(endMarkerName);
        if (endMarker == null) {
            throw new IllegalArgumentException("Cannot find marker with name " + endMarkerName + ".");
        }
        int endFrame = (int)(endMarker.startFrame + (playEndMarkerStartFrame ? 1.0f : 0.0f));
        this.setMinAndMaxFrame(startFrame, endFrame);
    }

    public void setMinAndMaxFrame(int minFrame, int maxFrame) {
        if (this.composition == null) {
            this.lazyCompositionTasks.add(c -> this.setMinAndMaxFrame(minFrame, maxFrame));
            return;
        }
        this.animator.setMinAndMaxFrames(minFrame, (float)maxFrame + 0.99f);
    }

    public void setMinAndMaxProgress(@FloatRange(from=0.0, to=1.0) float minProgress, @FloatRange(from=0.0, to=1.0) float maxProgress) {
        if (this.composition == null) {
            this.lazyCompositionTasks.add(c -> this.setMinAndMaxProgress(minProgress, maxProgress));
            return;
        }
        this.setMinAndMaxFrame((int)MiscUtils.lerp(this.composition.getStartFrame(), this.composition.getEndFrame(), minProgress), (int)MiscUtils.lerp(this.composition.getStartFrame(), this.composition.getEndFrame(), maxProgress));
    }

    public void reverseAnimationSpeed() {
        this.animator.reverseAnimationSpeed();
    }

    public void setSpeed(float speed) {
        this.animator.setSpeed(speed);
    }

    public float getSpeed() {
        return this.animator.getSpeed();
    }

    public void addAnimatorUpdateListener(ValueAnimator.AnimatorUpdateListener updateListener) {
        this.animator.addUpdateListener(updateListener);
    }

    public void removeAnimatorUpdateListener(ValueAnimator.AnimatorUpdateListener updateListener) {
        this.animator.removeUpdateListener(updateListener);
    }

    public void removeAllUpdateListeners() {
        this.animator.removeAllUpdateListeners();
        this.animator.addUpdateListener(this.progressUpdateListener);
    }

    public void addAnimatorListener(Animator.AnimatorListener listener) {
        this.animator.addListener(listener);
    }

    public void removeAnimatorListener(Animator.AnimatorListener listener) {
        this.animator.removeListener(listener);
    }

    public void removeAllAnimatorListeners() {
        this.animator.removeAllListeners();
    }

    @RequiresApi(api=19)
    public void addAnimatorPauseListener(Animator.AnimatorPauseListener listener) {
        this.animator.addPauseListener(listener);
    }

    @RequiresApi(api=19)
    public void removeAnimatorPauseListener(Animator.AnimatorPauseListener listener) {
        this.animator.removePauseListener(listener);
    }

    public void setFrame(int frame) {
        if (this.composition == null) {
            this.lazyCompositionTasks.add(c -> this.setFrame(frame));
            return;
        }
        this.animator.setFrame(frame);
    }

    public int getFrame() {
        return (int)this.animator.getFrame();
    }

    public void setProgress(@FloatRange(from=0.0, to=1.0) float progress) {
        if (this.composition == null) {
            this.lazyCompositionTasks.add(c -> this.setProgress(progress));
            return;
        }
        L.beginSection("Drawable#setProgress");
        this.animator.setFrame(this.composition.getFrameForProgress(progress));
        L.endSection("Drawable#setProgress");
    }

    @Deprecated
    public void loop(boolean loop) {
        this.animator.setRepeatCount(loop ? -1 : 0);
    }

    public void setRepeatMode(int mode) {
        this.animator.setRepeatMode(mode);
    }

    @SuppressLint(value={"WrongConstant"})
    public int getRepeatMode() {
        return this.animator.getRepeatMode();
    }

    public void setRepeatCount(int count) {
        this.animator.setRepeatCount(count);
    }

    public int getRepeatCount() {
        return this.animator.getRepeatCount();
    }

    public boolean isLooping() {
        return this.animator.getRepeatCount() == -1;
    }

    public boolean isAnimating() {
        if (this.animator == null) {
            return false;
        }
        return this.animator.isRunning();
    }

    boolean isAnimatingOrWillAnimateOnVisible() {
        if (this.isVisible()) {
            return this.animator.isRunning();
        }
        return this.onVisibleAction == OnVisibleAction.PLAY || this.onVisibleAction == OnVisibleAction.RESUME;
    }

    private boolean animationsEnabled() {
        return this.systemAnimationsEnabled || this.ignoreSystemAnimationsDisabled;
    }

    public void setSystemAnimationsAreEnabled(Boolean areEnabled) {
        this.systemAnimationsEnabled = areEnabled;
    }

    public void setIgnoreDisabledSystemAnimations(boolean ignore) {
        this.ignoreSystemAnimationsDisabled = ignore;
    }

    public void setUseCompositionFrameRate(boolean useCompositionFrameRate) {
        this.animator.setUseCompositionFrameRate(useCompositionFrameRate);
    }

    public void setImageAssetDelegate(ImageAssetDelegate assetDelegate) {
        this.imageAssetDelegate = assetDelegate;
        if (this.imageAssetManager != null) {
            this.imageAssetManager.setDelegate(assetDelegate);
        }
    }

    public void setFontAssetDelegate(FontAssetDelegate assetDelegate) {
        this.fontAssetDelegate = assetDelegate;
        if (this.fontAssetManager != null) {
            this.fontAssetManager.setDelegate(assetDelegate);
        }
    }

    public void setFontMap(@Nullable Map<String, Typeface> fontMap) {
        if (fontMap == this.fontMap) {
            return;
        }
        this.fontMap = fontMap;
        this.invalidateSelf();
    }

    public void setTextDelegate(TextDelegate textDelegate) {
        this.textDelegate = textDelegate;
    }

    @Nullable
    public TextDelegate getTextDelegate() {
        return this.textDelegate;
    }

    public boolean useTextGlyphs() {
        return this.fontMap == null && this.textDelegate == null && this.composition.getCharacters().size() > 0;
    }

    public LottieComposition getComposition() {
        return this.composition;
    }

    public void cancelAnimation() {
        this.lazyCompositionTasks.clear();
        this.animator.cancel();
        if (!this.isVisible()) {
            this.onVisibleAction = OnVisibleAction.NONE;
        }
    }

    public void pauseAnimation() {
        this.lazyCompositionTasks.clear();
        this.animator.pauseAnimation();
        if (!this.isVisible()) {
            this.onVisibleAction = OnVisibleAction.NONE;
        }
    }

    @FloatRange(from=0.0, to=1.0)
    public float getProgress() {
        return this.animator.getAnimatedValueAbsolute();
    }

    public int getIntrinsicWidth() {
        return this.composition == null ? -1 : this.composition.getBounds().width();
    }

    public int getIntrinsicHeight() {
        return this.composition == null ? -1 : this.composition.getBounds().height();
    }

    public List<KeyPath> resolveKeyPath(KeyPath keyPath) {
        if (this.compositionLayer == null) {
            Logger.warning("Cannot resolve KeyPath. Composition is not set yet.");
            return Collections.emptyList();
        }
        ArrayList<KeyPath> keyPaths = new ArrayList<KeyPath>();
        this.compositionLayer.resolveKeyPath(keyPath, 0, keyPaths, new KeyPath(new String[0]));
        return keyPaths;
    }

    public <T> void addValueCallback(KeyPath keyPath, T property, @Nullable LottieValueCallback<T> callback) {
        boolean invalidate;
        if (this.compositionLayer == null) {
            this.lazyCompositionTasks.add(c -> this.addValueCallback(keyPath, property, callback));
            return;
        }
        if (keyPath == KeyPath.COMPOSITION) {
            this.compositionLayer.addValueCallback(property, callback);
            invalidate = true;
        } else if (keyPath.getResolvedElement() != null) {
            keyPath.getResolvedElement().addValueCallback(property, callback);
            invalidate = true;
        } else {
            List<KeyPath> elements = this.resolveKeyPath(keyPath);
            for (int i = 0; i < elements.size(); ++i) {
                elements.get(i).getResolvedElement().addValueCallback(property, callback);
            }
            boolean bl = invalidate = !elements.isEmpty();
        }
        if (invalidate) {
            this.invalidateSelf();
            if (property == LottieProperty.TIME_REMAP) {
                this.setProgress(this.getProgress());
            }
        }
    }

    public <T> void addValueCallback(KeyPath keyPath, T property, final SimpleLottieValueCallback<T> callback) {
        this.addValueCallback(keyPath, property, new LottieValueCallback<T>(){

            @Override
            public T getValue(LottieFrameInfo<T> frameInfo) {
                return callback.getValue(frameInfo);
            }
        });
    }

    @Nullable
    public Bitmap updateBitmap(String id, @Nullable Bitmap bitmap) {
        ImageAssetManager bm = this.getImageAssetManager();
        if (bm == null) {
            Logger.warning("Cannot update bitmap. Most likely the drawable is not added to a View which prevents Lottie from getting a Context.");
            return null;
        }
        Bitmap ret = bm.updateBitmap(id, bitmap);
        this.invalidateSelf();
        return ret;
    }

    @Deprecated
    @Nullable
    public Bitmap getImageAsset(String id) {
        LottieImageAsset imageAsset;
        ImageAssetManager bm = this.getImageAssetManager();
        if (bm != null) {
            return bm.bitmapForId(id);
        }
        LottieImageAsset lottieImageAsset = imageAsset = this.composition == null ? null : this.composition.getImages().get(id);
        if (imageAsset != null) {
            return imageAsset.getBitmap();
        }
        return null;
    }

    @Nullable
    public Bitmap getBitmapForId(String id) {
        ImageAssetManager assetManager = this.getImageAssetManager();
        if (assetManager != null) {
            return assetManager.bitmapForId(id);
        }
        return null;
    }

    @Nullable
    public LottieImageAsset getLottieImageAssetForId(String id) {
        LottieComposition composition = this.composition;
        if (composition == null) {
            return null;
        }
        return composition.getImages().get(id);
    }

    private ImageAssetManager getImageAssetManager() {
        if (this.imageAssetManager != null && !this.imageAssetManager.hasSameContext(this.getContext())) {
            this.imageAssetManager = null;
        }
        if (this.imageAssetManager == null) {
            this.imageAssetManager = new ImageAssetManager(this.getCallback(), this.imageAssetsFolder, this.imageAssetDelegate, this.composition.getImages());
        }
        return this.imageAssetManager;
    }

    @Nullable
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public Typeface getTypeface(Font font) {
        FontAssetManager assetManager;
        Map<String, Typeface> fontMap = this.fontMap;
        if (fontMap != null) {
            String key = font.getFamily();
            if (fontMap.containsKey(key)) {
                return fontMap.get(key);
            }
            key = font.getName();
            if (fontMap.containsKey(key)) {
                return fontMap.get(key);
            }
            key = font.getFamily() + "-" + font.getStyle();
            if (fontMap.containsKey(key)) {
                return fontMap.get(key);
            }
        }
        if ((assetManager = this.getFontAssetManager()) != null) {
            return assetManager.getTypeface(font);
        }
        return null;
    }

    private FontAssetManager getFontAssetManager() {
        if (this.getCallback() == null) {
            return null;
        }
        if (this.fontAssetManager == null) {
            this.fontAssetManager = new FontAssetManager(this.getCallback(), this.fontAssetDelegate);
            String defaultExtension = this.defaultFontFileExtension;
            if (defaultExtension != null) {
                this.fontAssetManager.setDefaultFontFileExtension(this.defaultFontFileExtension);
            }
        }
        return this.fontAssetManager;
    }

    public void setDefaultFontFileExtension(String extension) {
        this.defaultFontFileExtension = extension;
        FontAssetManager fam = this.getFontAssetManager();
        if (fam != null) {
            fam.setDefaultFontFileExtension(extension);
        }
    }

    @Nullable
    private Context getContext() {
        Drawable.Callback callback = this.getCallback();
        if (callback == null) {
            return null;
        }
        if (callback instanceof View) {
            return ((View)callback).getContext();
        }
        return null;
    }

    public boolean setVisible(boolean visible, boolean restart) {
        boolean wasNotVisibleAlready = !this.isVisible();
        boolean ret = super.setVisible(visible, restart);
        if (visible) {
            if (this.onVisibleAction == OnVisibleAction.PLAY) {
                this.playAnimation();
            } else if (this.onVisibleAction == OnVisibleAction.RESUME) {
                this.resumeAnimation();
            }
        } else if (this.animator.isRunning()) {
            this.pauseAnimation();
            this.onVisibleAction = OnVisibleAction.RESUME;
        } else if (!wasNotVisibleAlready) {
            this.onVisibleAction = OnVisibleAction.NONE;
        }
        return ret;
    }

    public void invalidateDrawable(@NonNull Drawable who) {
        Drawable.Callback callback = this.getCallback();
        if (callback == null) {
            return;
        }
        callback.invalidateDrawable((Drawable)this);
    }

    public void scheduleDrawable(@NonNull Drawable who, @NonNull Runnable what, long when) {
        Drawable.Callback callback = this.getCallback();
        if (callback == null) {
            return;
        }
        callback.scheduleDrawable((Drawable)this, what, when);
    }

    public void unscheduleDrawable(@NonNull Drawable who, @NonNull Runnable what) {
        Drawable.Callback callback = this.getCallback();
        if (callback == null) {
            return;
        }
        callback.unscheduleDrawable((Drawable)this, what);
    }

    private void drawDirectlyToCanvas(Canvas canvas) {
        CompositionLayer compositionLayer = this.compositionLayer;
        LottieComposition composition = this.composition;
        if (compositionLayer == null || composition == null) {
            return;
        }
        this.renderingMatrix.reset();
        Rect bounds = this.getBounds();
        if (!bounds.isEmpty()) {
            float scaleX = (float)bounds.width() / (float)composition.getBounds().width();
            float scaleY = (float)bounds.height() / (float)composition.getBounds().height();
            this.renderingMatrix.preScale(scaleX, scaleY);
            this.renderingMatrix.preTranslate((float)bounds.left, (float)bounds.top);
        }
        compositionLayer.draw(canvas, this.renderingMatrix, this.alpha);
    }

    private void renderAndDrawAsBitmap(Canvas originalCanvas, CompositionLayer compositionLayer) {
        if (this.composition == null || compositionLayer == null) {
            return;
        }
        this.ensureSoftwareRenderingObjectsInitialized();
        originalCanvas.getMatrix(this.softwareRenderingOriginalCanvasMatrix);
        originalCanvas.getClipBounds(this.canvasClipBounds);
        this.convertRect(this.canvasClipBounds, this.canvasClipBoundsRectF);
        this.softwareRenderingOriginalCanvasMatrix.mapRect(this.canvasClipBoundsRectF);
        this.convertRect(this.canvasClipBoundsRectF, this.canvasClipBounds);
        if (this.clipToCompositionBounds) {
            this.softwareRenderingTransformedBounds.set(0.0f, 0.0f, (float)this.getIntrinsicWidth(), (float)this.getIntrinsicHeight());
        } else {
            compositionLayer.getBounds(this.softwareRenderingTransformedBounds, null, false);
        }
        this.softwareRenderingOriginalCanvasMatrix.mapRect(this.softwareRenderingTransformedBounds);
        Rect bounds = this.getBounds();
        float scaleX = (float)bounds.width() / (float)this.getIntrinsicWidth();
        float scaleY = (float)bounds.height() / (float)this.getIntrinsicHeight();
        this.scaleRect(this.softwareRenderingTransformedBounds, scaleX, scaleY);
        if (!this.ignoreCanvasClipBounds()) {
            this.softwareRenderingTransformedBounds.intersect((float)this.canvasClipBounds.left, (float)this.canvasClipBounds.top, (float)this.canvasClipBounds.right, (float)this.canvasClipBounds.bottom);
        }
        int renderWidth = (int)Math.ceil(this.softwareRenderingTransformedBounds.width());
        int renderHeight = (int)Math.ceil(this.softwareRenderingTransformedBounds.height());
        if (renderWidth <= 0 || renderHeight <= 0) {
            return;
        }
        this.ensureSoftwareRenderingBitmap(renderWidth, renderHeight);
        if (this.isDirty) {
            this.renderingMatrix.set(this.softwareRenderingOriginalCanvasMatrix);
            this.renderingMatrix.preScale(scaleX, scaleY);
            this.renderingMatrix.postTranslate(-this.softwareRenderingTransformedBounds.left, -this.softwareRenderingTransformedBounds.top);
            this.softwareRenderingBitmap.eraseColor(0);
            compositionLayer.draw(this.softwareRenderingCanvas, this.renderingMatrix, this.alpha);
            this.softwareRenderingOriginalCanvasMatrix.invert(this.softwareRenderingOriginalCanvasMatrixInverse);
            this.softwareRenderingOriginalCanvasMatrixInverse.mapRect(this.softwareRenderingDstBoundsRectF, this.softwareRenderingTransformedBounds);
            this.convertRect(this.softwareRenderingDstBoundsRectF, this.softwareRenderingDstBoundsRect);
        }
        this.softwareRenderingSrcBoundsRect.set(0, 0, renderWidth, renderHeight);
        originalCanvas.drawBitmap(this.softwareRenderingBitmap, this.softwareRenderingSrcBoundsRect, this.softwareRenderingDstBoundsRect, this.softwareRenderingPaint);
    }

    private void ensureSoftwareRenderingObjectsInitialized() {
        if (this.softwareRenderingCanvas != null) {
            return;
        }
        this.softwareRenderingCanvas = new Canvas();
        this.softwareRenderingTransformedBounds = new RectF();
        this.softwareRenderingOriginalCanvasMatrix = new Matrix();
        this.softwareRenderingOriginalCanvasMatrixInverse = new Matrix();
        this.canvasClipBounds = new Rect();
        this.canvasClipBoundsRectF = new RectF();
        this.softwareRenderingPaint = new LPaint();
        this.softwareRenderingSrcBoundsRect = new Rect();
        this.softwareRenderingDstBoundsRect = new Rect();
        this.softwareRenderingDstBoundsRectF = new RectF();
    }

    private void ensureSoftwareRenderingBitmap(int renderWidth, int renderHeight) {
        if (this.softwareRenderingBitmap == null || this.softwareRenderingBitmap.getWidth() < renderWidth || this.softwareRenderingBitmap.getHeight() < renderHeight) {
            this.softwareRenderingBitmap = Bitmap.createBitmap((int)renderWidth, (int)renderHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            this.softwareRenderingCanvas.setBitmap(this.softwareRenderingBitmap);
            this.isDirty = true;
        } else if (this.softwareRenderingBitmap.getWidth() > renderWidth || this.softwareRenderingBitmap.getHeight() > renderHeight) {
            this.softwareRenderingBitmap = Bitmap.createBitmap((Bitmap)this.softwareRenderingBitmap, (int)0, (int)0, (int)renderWidth, (int)renderHeight);
            this.softwareRenderingCanvas.setBitmap(this.softwareRenderingBitmap);
            this.isDirty = true;
        }
    }

    private void convertRect(RectF src, Rect dst) {
        dst.set((int)Math.floor(src.left), (int)Math.floor(src.top), (int)Math.ceil(src.right), (int)Math.ceil(src.bottom));
    }

    private void convertRect(Rect src, RectF dst) {
        dst.set((float)src.left, (float)src.top, (float)src.right, (float)src.bottom);
    }

    private void scaleRect(RectF rect, float scaleX, float scaleY) {
        rect.set(rect.left * scaleX, rect.top * scaleY, rect.right * scaleX, rect.bottom * scaleY);
    }

    private boolean ignoreCanvasClipBounds() {
        Drawable.Callback callback = this.getCallback();
        if (!(callback instanceof View)) {
            return false;
        }
        ViewParent parent = ((View)callback).getParent();
        if (Build.VERSION.SDK_INT >= 18 && parent instanceof ViewGroup) {
            return !((ViewGroup)parent).getClipChildren();
        }
        return false;
    }

    private static enum OnVisibleAction {
        NONE,
        PLAY,
        RESUME;

    }

    private static interface LazyCompositionTask {
        public void run(LottieComposition var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RepeatMode {
    }
}

