/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.animation.content;

import android.graphics.PointF;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.airbnb.lottie.LottieDrawable;
import com.airbnb.lottie.animation.content.Content;
import com.airbnb.lottie.animation.content.ShapeModifierContent;
import com.airbnb.lottie.animation.keyframe.BaseKeyframeAnimation;
import com.airbnb.lottie.model.CubicCurveData;
import com.airbnb.lottie.model.content.RoundedCorners;
import com.airbnb.lottie.model.content.ShapeData;
import com.airbnb.lottie.model.layer.BaseLayer;
import java.util.ArrayList;
import java.util.List;

public class RoundedCornersContent
implements ShapeModifierContent,
BaseKeyframeAnimation.AnimationListener {
    private static final float ROUNDED_CORNER_MAGIC_NUMBER = 0.5519f;
    private final LottieDrawable lottieDrawable;
    private final String name;
    private final BaseKeyframeAnimation<Float, Float> roundedCorners;
    @Nullable
    private ShapeData shapeData;

    public RoundedCornersContent(LottieDrawable lottieDrawable, BaseLayer layer, RoundedCorners roundedCorners) {
        this.lottieDrawable = lottieDrawable;
        this.name = roundedCorners.getName();
        this.roundedCorners = roundedCorners.getCornerRadius().createAnimation();
        layer.addAnimation(this.roundedCorners);
        this.roundedCorners.addUpdateListener(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void onValueChanged() {
        this.lottieDrawable.invalidateSelf();
    }

    @Override
    public void setContents(List<Content> contentsBefore, List<Content> contentsAfter) {
    }

    public BaseKeyframeAnimation<Float, Float> getRoundedCorners() {
        return this.roundedCorners;
    }

    @Override
    public ShapeData modifyShape(ShapeData startingShapeData) {
        List<CubicCurveData> startingCurves = startingShapeData.getCurves();
        if (startingCurves.size() <= 2) {
            return startingShapeData;
        }
        float roundedness = this.roundedCorners.getValue().floatValue();
        if (roundedness == 0.0f) {
            return startingShapeData;
        }
        ShapeData modifiedShapeData = this.getShapeData(startingShapeData);
        modifiedShapeData.setInitialPoint(startingShapeData.getInitialPoint().x, startingShapeData.getInitialPoint().y);
        List<CubicCurveData> modifiedCurves = modifiedShapeData.getCurves();
        int modifiedCurvesIndex = 0;
        boolean isClosed = startingShapeData.isClosed();
        for (int i = 0; i < startingCurves.size(); ++i) {
            boolean isEndOfCurve;
            CubicCurveData startingCurve = startingCurves.get(i);
            CubicCurveData previousCurve = startingCurves.get(RoundedCornersContent.floorMod(i - 1, startingCurves.size()));
            CubicCurveData previousPreviousCurve = startingCurves.get(RoundedCornersContent.floorMod(i - 2, startingCurves.size()));
            PointF vertex = i == 0 && !isClosed ? startingShapeData.getInitialPoint() : previousCurve.getVertex();
            PointF inPoint = i == 0 && !isClosed ? vertex : previousCurve.getControlPoint2();
            PointF outPoint = startingCurve.getControlPoint1();
            PointF previousVertex = previousPreviousCurve.getVertex();
            PointF nextVertex = startingCurve.getVertex();
            boolean bl = isEndOfCurve = !startingShapeData.isClosed() && (i == 0 || i == startingCurves.size() - 1);
            if (inPoint.equals((Object)vertex) && outPoint.equals((Object)vertex) && !isEndOfCurve) {
                float dxToPreviousVertex = vertex.x - previousVertex.x;
                float dyToPreviousVertex = vertex.y - previousVertex.y;
                float dxToNextVertex = nextVertex.x - vertex.x;
                float dyToNextVertex = nextVertex.y - vertex.y;
                float dToPreviousVertex = (float)Math.hypot(dxToPreviousVertex, dyToPreviousVertex);
                float dToNextVertex = (float)Math.hypot(dxToNextVertex, dyToNextVertex);
                float previousVertexPercent = Math.min(roundedness / dToPreviousVertex, 0.5f);
                float nextVertexPercent = Math.min(roundedness / dToNextVertex, 0.5f);
                float newVertex1X = vertex.x + (previousVertex.x - vertex.x) * previousVertexPercent;
                float newVertex1Y = vertex.y + (previousVertex.y - vertex.y) * previousVertexPercent;
                float newVertex2X = vertex.x + (nextVertex.x - vertex.x) * nextVertexPercent;
                float newVertex2Y = vertex.y + (nextVertex.y - vertex.y) * nextVertexPercent;
                float newVertex1OutPointX = newVertex1X - (newVertex1X - vertex.x) * 0.5519f;
                float newVertex1OutPointY = newVertex1Y - (newVertex1Y - vertex.y) * 0.5519f;
                float newVertex2InPointX = newVertex2X - (newVertex2X - vertex.x) * 0.5519f;
                float newVertex2InPointY = newVertex2Y - (newVertex2Y - vertex.y) * 0.5519f;
                CubicCurveData previousCurveData = modifiedCurves.get(RoundedCornersContent.floorMod(modifiedCurvesIndex - 1, modifiedCurves.size()));
                CubicCurveData currentCurveData = modifiedCurves.get(modifiedCurvesIndex);
                previousCurveData.setControlPoint2(newVertex1X, newVertex1Y);
                previousCurveData.setVertex(newVertex1X, newVertex1Y);
                if (i == 0) {
                    modifiedShapeData.setInitialPoint(newVertex1X, newVertex1Y);
                }
                currentCurveData.setControlPoint1(newVertex1OutPointX, newVertex1OutPointY);
                previousCurveData = currentCurveData;
                currentCurveData = modifiedCurves.get(++modifiedCurvesIndex);
                previousCurveData.setControlPoint2(newVertex2InPointX, newVertex2InPointY);
                previousCurveData.setVertex(newVertex2X, newVertex2Y);
                currentCurveData.setControlPoint1(newVertex2X, newVertex2Y);
                ++modifiedCurvesIndex;
                continue;
            }
            CubicCurveData previousCurveData = modifiedCurves.get(RoundedCornersContent.floorMod(modifiedCurvesIndex - 1, modifiedCurves.size()));
            CubicCurveData currentCurveData = modifiedCurves.get(modifiedCurvesIndex);
            previousCurveData.setControlPoint2(previousCurve.getControlPoint2().x, previousCurve.getControlPoint2().y);
            previousCurveData.setVertex(previousCurve.getVertex().x, previousCurve.getVertex().y);
            currentCurveData.setControlPoint1(startingCurve.getControlPoint1().x, startingCurve.getControlPoint1().y);
            ++modifiedCurvesIndex;
        }
        return modifiedShapeData;
    }

    @NonNull
    private ShapeData getShapeData(ShapeData startingShapeData) {
        List<CubicCurveData> startingCurves = startingShapeData.getCurves();
        boolean isClosed = startingShapeData.isClosed();
        int vertices = 0;
        for (int i = startingCurves.size() - 1; i >= 0; --i) {
            boolean isEndOfCurve;
            CubicCurveData startingCurve = startingCurves.get(i);
            CubicCurveData previousCurve = startingCurves.get(RoundedCornersContent.floorMod(i - 1, startingCurves.size()));
            PointF vertex = i == 0 && !isClosed ? startingShapeData.getInitialPoint() : previousCurve.getVertex();
            PointF inPoint = i == 0 && !isClosed ? vertex : previousCurve.getControlPoint2();
            PointF outPoint = startingCurve.getControlPoint1();
            boolean bl = isEndOfCurve = !startingShapeData.isClosed() && (i == 0 || i == startingCurves.size() - 1);
            if (inPoint.equals((Object)vertex) && outPoint.equals((Object)vertex) && !isEndOfCurve) {
                vertices += 2;
                continue;
            }
            ++vertices;
        }
        if (this.shapeData == null || this.shapeData.getCurves().size() != vertices) {
            ArrayList<CubicCurveData> newCurves = new ArrayList<CubicCurveData>(vertices);
            for (int i = 0; i < vertices; ++i) {
                newCurves.add(new CubicCurveData());
            }
            this.shapeData = new ShapeData(new PointF(0.0f, 0.0f), false, newCurves);
        }
        this.shapeData.setClosed(isClosed);
        return this.shapeData;
    }

    private static int floorMod(int x, int y) {
        return x - RoundedCornersContent.floorDiv(x, y) * y;
    }

    private static int floorDiv(int x, int y) {
        int r = x / y;
        if ((x ^ y) < 0 && r * y != x) {
            --r;
        }
        return r;
    }
}

