/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.model.content;

import com.airbnb.lottie.utils.GammaEvaluator;
import com.airbnb.lottie.utils.MiscUtils;
import java.util.Arrays;

public class GradientColor {
    private final float[] positions;
    private final int[] colors;

    public GradientColor(float[] positions, int[] colors) {
        this.positions = positions;
        this.colors = colors;
    }

    public float[] getPositions() {
        return this.positions;
    }

    public int[] getColors() {
        return this.colors;
    }

    public int getSize() {
        return this.colors.length;
    }

    public void lerp(GradientColor gc1, GradientColor gc2, float progress) {
        int i;
        if (gc1.colors.length != gc2.colors.length) {
            throw new IllegalArgumentException("Cannot interpolate between gradients. Lengths vary (" + gc1.colors.length + " vs " + gc2.colors.length + ")");
        }
        for (i = 0; i < gc1.colors.length; ++i) {
            this.positions[i] = MiscUtils.lerp(gc1.positions[i], gc2.positions[i], progress);
            this.colors[i] = GammaEvaluator.evaluate(progress, gc1.colors[i], gc2.colors[i]);
        }
        for (i = gc1.colors.length; i < this.positions.length; ++i) {
            this.positions[i] = this.positions[gc1.colors.length - 1];
            this.colors[i] = this.colors[gc1.colors.length - 1];
        }
    }

    public GradientColor copyWithPositions(float[] positions) {
        int[] colors = new int[positions.length];
        for (int i = 0; i < positions.length; ++i) {
            colors[i] = this.getColorForPosition(positions[i]);
        }
        return new GradientColor(positions, colors);
    }

    private int getColorForPosition(float position) {
        int existingIndex = Arrays.binarySearch(this.positions, position);
        if (existingIndex >= 0) {
            return this.colors[existingIndex];
        }
        int insertionPoint = -(existingIndex + 1);
        if (insertionPoint == 0) {
            return this.colors[0];
        }
        if (insertionPoint == this.colors.length - 1) {
            return this.colors[this.colors.length - 1];
        }
        float startPosition = this.positions[insertionPoint - 1];
        float endPosition = this.positions[insertionPoint];
        int startColor = this.colors[insertionPoint - 1];
        int endColor = this.colors[insertionPoint];
        float fraction = (position - startPosition) / (endPosition - startPosition);
        return GammaEvaluator.evaluate(fraction, startColor, endColor);
    }
}

