/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.animation.content;

import android.graphics.Path;
import androidx.annotation.Nullable;
import com.airbnb.lottie.LottieDrawable;
import com.airbnb.lottie.LottieProperty;
import com.airbnb.lottie.animation.content.CompoundTrimPathContent;
import com.airbnb.lottie.animation.content.Content;
import com.airbnb.lottie.animation.content.KeyPathElementContent;
import com.airbnb.lottie.animation.content.PathContent;
import com.airbnb.lottie.animation.content.ShapeModifierContent;
import com.airbnb.lottie.animation.content.TrimPathContent;
import com.airbnb.lottie.animation.keyframe.BaseKeyframeAnimation;
import com.airbnb.lottie.animation.keyframe.ShapeKeyframeAnimation;
import com.airbnb.lottie.model.KeyPath;
import com.airbnb.lottie.model.content.ShapePath;
import com.airbnb.lottie.model.content.ShapeTrimPath;
import com.airbnb.lottie.model.layer.BaseLayer;
import com.airbnb.lottie.utils.MiscUtils;
import com.airbnb.lottie.value.LottieValueCallback;
import java.util.ArrayList;
import java.util.List;

public class ShapeContent
implements PathContent,
BaseKeyframeAnimation.AnimationListener,
KeyPathElementContent {
    private final Path path = new Path();
    private final String name;
    private final boolean hidden;
    private final LottieDrawable lottieDrawable;
    private final ShapeKeyframeAnimation shapeAnimation;
    @Nullable
    private List<ShapeModifierContent> shapeModifierContents;
    private boolean isPathValid;
    private final CompoundTrimPathContent trimPaths = new CompoundTrimPathContent();

    public ShapeContent(LottieDrawable lottieDrawable, BaseLayer layer, ShapePath shape) {
        this.name = shape.getName();
        this.hidden = shape.isHidden();
        this.lottieDrawable = lottieDrawable;
        this.shapeAnimation = shape.getShapePath().createAnimation();
        layer.addAnimation(this.shapeAnimation);
        this.shapeAnimation.addUpdateListener(this);
    }

    @Override
    public void onValueChanged() {
        this.invalidate();
    }

    private void invalidate() {
        this.isPathValid = false;
        this.lottieDrawable.invalidateSelf();
    }

    @Override
    public void setContents(List<Content> contentsBefore, List<Content> contentsAfter) {
        ArrayList<ShapeModifierContent> shapeModifierContents = null;
        for (int i = 0; i < contentsBefore.size(); ++i) {
            Content content = contentsBefore.get(i);
            if (content instanceof TrimPathContent && ((TrimPathContent)content).getType() == ShapeTrimPath.Type.SIMULTANEOUSLY) {
                TrimPathContent trimPath = (TrimPathContent)content;
                this.trimPaths.addTrimPath(trimPath);
                trimPath.addListener(this);
                continue;
            }
            if (!(content instanceof ShapeModifierContent)) continue;
            if (shapeModifierContents == null) {
                shapeModifierContents = new ArrayList<ShapeModifierContent>();
            }
            shapeModifierContents.add((ShapeModifierContent)content);
        }
        this.shapeAnimation.setShapeModifiers(shapeModifierContents);
    }

    @Override
    public Path getPath() {
        if (this.isPathValid && !this.shapeAnimation.hasValueCallback()) {
            return this.path;
        }
        this.path.reset();
        if (this.hidden) {
            this.isPathValid = true;
            return this.path;
        }
        Path shapeAnimationPath = (Path)this.shapeAnimation.getValue();
        if (shapeAnimationPath == null) {
            return this.path;
        }
        this.path.set(shapeAnimationPath);
        this.path.setFillType(Path.FillType.EVEN_ODD);
        this.trimPaths.apply(this.path);
        this.isPathValid = true;
        return this.path;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void resolveKeyPath(KeyPath keyPath, int depth, List<KeyPath> accumulator, KeyPath currentPartialKeyPath) {
        MiscUtils.resolveKeyPath(keyPath, depth, accumulator, currentPartialKeyPath, this);
    }

    @Override
    public <T> void addValueCallback(T property, @Nullable LottieValueCallback<T> callback) {
        if (property == LottieProperty.PATH) {
            this.shapeAnimation.setValueCallback(callback);
        }
    }
}

