/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.model.layer;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.Typeface;
import androidx.annotation.Nullable;
import androidx.collection.LongSparseArray;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.LottieDrawable;
import com.airbnb.lottie.LottieProperty;
import com.airbnb.lottie.TextDelegate;
import com.airbnb.lottie.animation.content.ContentGroup;
import com.airbnb.lottie.animation.keyframe.BaseKeyframeAnimation;
import com.airbnb.lottie.animation.keyframe.TextKeyframeAnimation;
import com.airbnb.lottie.animation.keyframe.ValueCallbackKeyframeAnimation;
import com.airbnb.lottie.model.DocumentData;
import com.airbnb.lottie.model.Font;
import com.airbnb.lottie.model.FontCharacter;
import com.airbnb.lottie.model.animatable.AnimatableTextProperties;
import com.airbnb.lottie.model.content.ShapeGroup;
import com.airbnb.lottie.model.content.TextRangeUnits;
import com.airbnb.lottie.model.layer.BaseLayer;
import com.airbnb.lottie.model.layer.Layer;
import com.airbnb.lottie.utils.Utils;
import com.airbnb.lottie.value.LottieValueCallback;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TextLayer
extends BaseLayer {
    private final StringBuilder stringBuilder = new StringBuilder(2);
    private final RectF rectF = new RectF();
    private final Matrix matrix = new Matrix();
    private final Paint fillPaint = new Paint(1){
        {
            this.setStyle(Paint.Style.FILL);
        }
    };
    private final Paint strokePaint = new Paint(1){
        {
            this.setStyle(Paint.Style.STROKE);
        }
    };
    private final Map<FontCharacter, List<ContentGroup>> contentsForCharacter = new HashMap<FontCharacter, List<ContentGroup>>();
    private final LongSparseArray<String> codePointCache = new LongSparseArray();
    private final List<TextSubLine> textSubLines = new ArrayList<TextSubLine>();
    private final TextKeyframeAnimation textAnimation;
    private final LottieDrawable lottieDrawable;
    private final LottieComposition composition;
    private TextRangeUnits textRangeUnits = TextRangeUnits.INDEX;
    @Nullable
    private BaseKeyframeAnimation<Integer, Integer> colorAnimation;
    @Nullable
    private BaseKeyframeAnimation<Integer, Integer> colorCallbackAnimation;
    @Nullable
    private BaseKeyframeAnimation<Integer, Integer> strokeColorAnimation;
    @Nullable
    private BaseKeyframeAnimation<Integer, Integer> strokeColorCallbackAnimation;
    @Nullable
    private BaseKeyframeAnimation<Float, Float> strokeWidthAnimation;
    @Nullable
    private BaseKeyframeAnimation<Float, Float> strokeWidthCallbackAnimation;
    @Nullable
    private BaseKeyframeAnimation<Float, Float> trackingAnimation;
    @Nullable
    private BaseKeyframeAnimation<Float, Float> trackingCallbackAnimation;
    @Nullable
    private BaseKeyframeAnimation<Integer, Integer> opacityAnimation;
    @Nullable
    private BaseKeyframeAnimation<Float, Float> textSizeCallbackAnimation;
    @Nullable
    private BaseKeyframeAnimation<Typeface, Typeface> typefaceCallbackAnimation;
    @Nullable
    private BaseKeyframeAnimation<Integer, Integer> textRangeStartAnimation;
    @Nullable
    private BaseKeyframeAnimation<Integer, Integer> textRangeEndAnimation;
    @Nullable
    private BaseKeyframeAnimation<Integer, Integer> textRangeOffsetAnimation;

    TextLayer(LottieDrawable lottieDrawable, Layer layerModel) {
        super(lottieDrawable, layerModel);
        this.lottieDrawable = lottieDrawable;
        this.composition = layerModel.getComposition();
        this.textAnimation = layerModel.getText().createAnimation();
        this.textAnimation.addUpdateListener(this);
        this.addAnimation(this.textAnimation);
        AnimatableTextProperties textProperties = layerModel.getTextProperties();
        if (textProperties != null && textProperties.textStyle != null && textProperties.textStyle.color != null) {
            this.colorAnimation = textProperties.textStyle.color.createAnimation();
            this.colorAnimation.addUpdateListener(this);
            this.addAnimation(this.colorAnimation);
        }
        if (textProperties != null && textProperties.textStyle != null && textProperties.textStyle.stroke != null) {
            this.strokeColorAnimation = textProperties.textStyle.stroke.createAnimation();
            this.strokeColorAnimation.addUpdateListener(this);
            this.addAnimation(this.strokeColorAnimation);
        }
        if (textProperties != null && textProperties.textStyle != null && textProperties.textStyle.strokeWidth != null) {
            this.strokeWidthAnimation = textProperties.textStyle.strokeWidth.createAnimation();
            this.strokeWidthAnimation.addUpdateListener(this);
            this.addAnimation(this.strokeWidthAnimation);
        }
        if (textProperties != null && textProperties.textStyle != null && textProperties.textStyle.tracking != null) {
            this.trackingAnimation = textProperties.textStyle.tracking.createAnimation();
            this.trackingAnimation.addUpdateListener(this);
            this.addAnimation(this.trackingAnimation);
        }
        if (textProperties != null && textProperties.textStyle != null && textProperties.textStyle.opacity != null) {
            this.opacityAnimation = textProperties.textStyle.opacity.createAnimation();
            this.opacityAnimation.addUpdateListener(this);
            this.addAnimation(this.opacityAnimation);
        }
        if (textProperties != null && textProperties.rangeSelector != null && textProperties.rangeSelector.start != null) {
            this.textRangeStartAnimation = textProperties.rangeSelector.start.createAnimation();
            this.textRangeStartAnimation.addUpdateListener(this);
            this.addAnimation(this.textRangeStartAnimation);
        }
        if (textProperties != null && textProperties.rangeSelector != null && textProperties.rangeSelector.end != null) {
            this.textRangeEndAnimation = textProperties.rangeSelector.end.createAnimation();
            this.textRangeEndAnimation.addUpdateListener(this);
            this.addAnimation(this.textRangeEndAnimation);
        }
        if (textProperties != null && textProperties.rangeSelector != null && textProperties.rangeSelector.offset != null) {
            this.textRangeOffsetAnimation = textProperties.rangeSelector.offset.createAnimation();
            this.textRangeOffsetAnimation.addUpdateListener(this);
            this.addAnimation(this.textRangeOffsetAnimation);
        }
        if (textProperties != null && textProperties.rangeSelector != null) {
            this.textRangeUnits = textProperties.rangeSelector.units;
        }
    }

    @Override
    public void getBounds(RectF outBounds, Matrix parentMatrix, boolean applyParents) {
        super.getBounds(outBounds, parentMatrix, applyParents);
        outBounds.set(0.0f, 0.0f, (float)this.composition.getBounds().width(), (float)this.composition.getBounds().height());
    }

    @Override
    void drawLayer(Canvas canvas, Matrix parentMatrix, int parentAlpha) {
        DocumentData documentData = (DocumentData)this.textAnimation.getValue();
        Font font = this.composition.getFonts().get(documentData.fontName);
        if (font == null) {
            return;
        }
        canvas.save();
        canvas.concat(parentMatrix);
        this.configurePaint(documentData, parentAlpha, 0);
        if (this.lottieDrawable.useTextGlyphs()) {
            this.drawTextWithGlyphs(documentData, parentMatrix, font, canvas, parentAlpha);
        } else {
            this.drawTextWithFont(documentData, font, canvas, parentAlpha);
        }
        canvas.restore();
    }

    private void configurePaint(DocumentData documentData, int parentAlpha, int indexInDocument) {
        if (this.colorCallbackAnimation != null) {
            this.fillPaint.setColor(this.colorCallbackAnimation.getValue().intValue());
        } else if (this.colorAnimation != null && this.isIndexInRangeSelection(indexInDocument)) {
            this.fillPaint.setColor(this.colorAnimation.getValue().intValue());
        } else {
            this.fillPaint.setColor(documentData.color);
        }
        if (this.strokeColorCallbackAnimation != null) {
            this.strokePaint.setColor(this.strokeColorCallbackAnimation.getValue().intValue());
        } else if (this.strokeColorAnimation != null && this.isIndexInRangeSelection(indexInDocument)) {
            this.strokePaint.setColor(this.strokeColorAnimation.getValue().intValue());
        } else {
            this.strokePaint.setColor(documentData.strokeColor);
        }
        int transformOpacity = this.transform.getOpacity() == null ? 100 : this.transform.getOpacity().getValue();
        int textRangeOpacity = this.opacityAnimation != null && this.isIndexInRangeSelection(indexInDocument) ? this.opacityAnimation.getValue() : 100;
        int alpha = Math.round((float)transformOpacity * 255.0f / 100.0f * ((float)textRangeOpacity / 100.0f) * (float)parentAlpha / 255.0f);
        this.fillPaint.setAlpha(alpha);
        this.strokePaint.setAlpha(alpha);
        if (this.strokeWidthCallbackAnimation != null) {
            this.strokePaint.setStrokeWidth(this.strokeWidthCallbackAnimation.getValue().floatValue());
        } else if (this.strokeWidthAnimation != null && this.isIndexInRangeSelection(indexInDocument)) {
            this.strokePaint.setStrokeWidth(this.strokeWidthAnimation.getValue().floatValue());
        } else {
            this.strokePaint.setStrokeWidth(documentData.strokeWidth * Utils.dpScale());
        }
    }

    private boolean isIndexInRangeSelection(int indexInDocument) {
        int textLength = ((DocumentData)this.textAnimation.getValue()).text.length();
        if (this.textRangeStartAnimation != null && this.textRangeEndAnimation != null) {
            int rangeStart = Math.min(this.textRangeStartAnimation.getValue(), this.textRangeEndAnimation.getValue());
            int rangeEnd = Math.max(this.textRangeStartAnimation.getValue(), this.textRangeEndAnimation.getValue());
            if (this.textRangeOffsetAnimation != null) {
                int offset = this.textRangeOffsetAnimation.getValue();
                rangeStart += offset;
                rangeEnd += offset;
            }
            if (this.textRangeUnits == TextRangeUnits.INDEX) {
                return indexInDocument >= rangeStart && indexInDocument < rangeEnd;
            }
            float currentIndexAsPercent = (float)indexInDocument / (float)textLength * 100.0f;
            return currentIndexAsPercent >= (float)rangeStart && currentIndexAsPercent < (float)rangeEnd;
        }
        return true;
    }

    private void drawTextWithGlyphs(DocumentData documentData, Matrix parentMatrix, Font font, Canvas canvas, int parentAlpha) {
        float textSize = this.textSizeCallbackAnimation != null ? this.textSizeCallbackAnimation.getValue().floatValue() : documentData.size;
        float fontScale = textSize / 100.0f;
        float parentScale = Utils.getScale(parentMatrix);
        String text = documentData.text;
        List<String> textLines = this.getTextLines(text);
        int textLineCount = textLines.size();
        float tracking = (float)documentData.tracking / 10.0f;
        if (this.trackingCallbackAnimation != null) {
            tracking += this.trackingCallbackAnimation.getValue().floatValue();
        } else if (this.trackingAnimation != null) {
            tracking += this.trackingAnimation.getValue().floatValue();
        }
        int lineIndex = -1;
        for (int i = 0; i < textLineCount; ++i) {
            String textLine = textLines.get(i);
            float boxWidth = documentData.boxSize == null ? 0.0f : documentData.boxSize.x;
            List<TextSubLine> lines = this.splitGlyphTextIntoLines(textLine, boxWidth, font, fontScale, tracking, true);
            for (int j = 0; j < lines.size(); ++j) {
                TextSubLine line = lines.get(j);
                canvas.save();
                if (this.offsetCanvas(canvas, documentData, ++lineIndex, line.width)) {
                    this.drawGlyphTextLine(line.text, documentData, font, canvas, parentScale, fontScale, tracking, parentAlpha);
                }
                canvas.restore();
            }
        }
    }

    private void drawGlyphTextLine(String text, DocumentData documentData, Font font, Canvas canvas, float parentScale, float fontScale, float tracking, int parentAlpha) {
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            int characterHash = FontCharacter.hashFor(c, font.getFamily(), font.getStyle());
            FontCharacter character = (FontCharacter)this.composition.getCharacters().get(characterHash);
            if (character == null) continue;
            this.drawCharacterAsGlyph(character, fontScale, documentData, canvas, i, parentAlpha);
            float tx = (float)character.getWidth() * fontScale * Utils.dpScale() + tracking;
            canvas.translate(tx, 0.0f);
        }
    }

    private void drawTextWithFont(DocumentData documentData, Font font, Canvas canvas, int parentAlpha) {
        Typeface typeface = this.getTypeface(font);
        if (typeface == null) {
            return;
        }
        String text = documentData.text;
        TextDelegate textDelegate = this.lottieDrawable.getTextDelegate();
        if (textDelegate != null) {
            text = textDelegate.getTextInternal(this.getName(), text);
        }
        this.fillPaint.setTypeface(typeface);
        float textSize = this.textSizeCallbackAnimation != null ? this.textSizeCallbackAnimation.getValue().floatValue() : documentData.size;
        this.fillPaint.setTextSize(textSize * Utils.dpScale());
        this.strokePaint.setTypeface(this.fillPaint.getTypeface());
        this.strokePaint.setTextSize(this.fillPaint.getTextSize());
        float tracking = (float)documentData.tracking / 10.0f;
        if (this.trackingCallbackAnimation != null) {
            tracking += this.trackingCallbackAnimation.getValue().floatValue();
        } else if (this.trackingAnimation != null) {
            tracking += this.trackingAnimation.getValue().floatValue();
        }
        tracking = tracking * Utils.dpScale() * textSize / 100.0f;
        List<String> textLines = this.getTextLines(text);
        int textLineCount = textLines.size();
        int lineIndex = -1;
        int characterIndexAtStartOfLine = 0;
        for (int i = 0; i < textLineCount; ++i) {
            String textLine = textLines.get(i);
            float boxWidth = documentData.boxSize == null ? 0.0f : documentData.boxSize.x;
            List<TextSubLine> lines = this.splitGlyphTextIntoLines(textLine, boxWidth, font, 0.0f, tracking, false);
            for (int j = 0; j < lines.size(); ++j) {
                TextSubLine line = lines.get(j);
                canvas.save();
                if (this.offsetCanvas(canvas, documentData, ++lineIndex, line.width)) {
                    this.drawFontTextLine(line.text, documentData, canvas, tracking, characterIndexAtStartOfLine, parentAlpha);
                }
                characterIndexAtStartOfLine += line.text.length();
                canvas.restore();
            }
        }
    }

    private boolean offsetCanvas(Canvas canvas, DocumentData documentData, int lineIndex, float lineWidth) {
        PointF position = documentData.boxPosition;
        PointF size = documentData.boxSize;
        float dpScale = Utils.dpScale();
        float lineStartY = position == null ? 0.0f : documentData.lineHeight * dpScale + position.y;
        float lineOffset = (float)lineIndex * documentData.lineHeight * dpScale + lineStartY;
        if (this.lottieDrawable.getClipTextToBoundingBox() && size != null && position != null && lineOffset >= position.y + size.y + documentData.size) {
            return false;
        }
        float lineStart = position == null ? 0.0f : position.x;
        float boxWidth = size == null ? 0.0f : size.x;
        switch (documentData.justification) {
            case LEFT_ALIGN: {
                canvas.translate(lineStart, lineOffset);
                break;
            }
            case RIGHT_ALIGN: {
                canvas.translate(lineStart + boxWidth - lineWidth, lineOffset);
                break;
            }
            case CENTER: {
                canvas.translate(lineStart + boxWidth / 2.0f - lineWidth / 2.0f, lineOffset);
            }
        }
        return true;
    }

    @Nullable
    private Typeface getTypeface(Font font) {
        Typeface callbackTypeface;
        if (this.typefaceCallbackAnimation != null && (callbackTypeface = this.typefaceCallbackAnimation.getValue()) != null) {
            return callbackTypeface;
        }
        Typeface drawableTypeface = this.lottieDrawable.getTypeface(font);
        if (drawableTypeface != null) {
            return drawableTypeface;
        }
        return font.getTypeface();
    }

    private List<String> getTextLines(String text) {
        String formattedText = text.replaceAll("\r\n", "\r").replaceAll("\u0003", "\r").replaceAll("\n", "\r");
        String[] textLinesArray = formattedText.split("\r");
        return Arrays.asList(textLinesArray);
    }

    private void drawFontTextLine(String text, DocumentData documentData, Canvas canvas, float tracking, int characterIndexAtStartOfLine, int parentAlpha) {
        String charString;
        for (int i = 0; i < text.length(); i += charString.length()) {
            charString = this.codePointToString(text, i);
            this.drawCharacterFromFont(charString, documentData, canvas, characterIndexAtStartOfLine + i, parentAlpha);
            float charWidth = this.fillPaint.measureText(charString);
            float tx = charWidth + tracking;
            canvas.translate(tx, 0.0f);
        }
    }

    private List<TextSubLine> splitGlyphTextIntoLines(String textLine, float boxWidth, Font font, float fontScale, float tracking, boolean usingGlyphs) {
        int lineCount = 0;
        float currentLineWidth = 0.0f;
        int currentLineStartIndex = 0;
        int currentWordStartIndex = 0;
        float currentWordWidth = 0.0f;
        boolean nextCharacterStartsWord = false;
        float spaceWidth = 0.0f;
        for (int i = 0; i < textLine.length(); ++i) {
            float trimmedSpace;
            String trimmed;
            String substr;
            float currentCharWidth;
            char c = textLine.charAt(i);
            if (usingGlyphs) {
                int characterHash = FontCharacter.hashFor(c, font.getFamily(), font.getStyle());
                FontCharacter character = (FontCharacter)this.composition.getCharacters().get(characterHash);
                if (character == null) continue;
                currentCharWidth = (float)character.getWidth() * fontScale * Utils.dpScale() + tracking;
            } else {
                currentCharWidth = this.fillPaint.measureText(textLine.substring(i, i + 1)) + tracking;
            }
            if (c == ' ') {
                spaceWidth = currentCharWidth;
                nextCharacterStartsWord = true;
            } else if (nextCharacterStartsWord) {
                nextCharacterStartsWord = false;
                currentWordStartIndex = i;
                currentWordWidth = currentCharWidth;
            } else {
                currentWordWidth += currentCharWidth;
            }
            if (!(boxWidth > 0.0f) || !((currentLineWidth += currentCharWidth) >= boxWidth) || c == ' ') continue;
            TextSubLine subLine = this.ensureEnoughSubLines(++lineCount);
            if (currentWordStartIndex == currentLineStartIndex) {
                substr = textLine.substring(currentLineStartIndex, i);
                trimmed = substr.trim();
                trimmedSpace = (float)(trimmed.length() - substr.length()) * spaceWidth;
                subLine.set(trimmed, currentLineWidth - currentCharWidth - trimmedSpace);
                currentLineStartIndex = i;
                currentLineWidth = currentCharWidth;
                currentWordStartIndex = currentLineStartIndex;
                currentWordWidth = currentCharWidth;
                continue;
            }
            substr = textLine.substring(currentLineStartIndex, currentWordStartIndex - 1);
            trimmed = substr.trim();
            trimmedSpace = (float)(substr.length() - trimmed.length()) * spaceWidth;
            subLine.set(trimmed, currentLineWidth - currentWordWidth - trimmedSpace - spaceWidth);
            currentLineStartIndex = currentWordStartIndex;
            currentLineWidth = currentWordWidth;
        }
        if (currentLineWidth > 0.0f) {
            TextSubLine line = this.ensureEnoughSubLines(++lineCount);
            line.set(textLine.substring(currentLineStartIndex), currentLineWidth);
        }
        return this.textSubLines.subList(0, lineCount);
    }

    private TextSubLine ensureEnoughSubLines(int numLines) {
        for (int i = this.textSubLines.size(); i < numLines; ++i) {
            this.textSubLines.add(new TextSubLine());
        }
        return this.textSubLines.get(numLines - 1);
    }

    private void drawCharacterAsGlyph(FontCharacter character, float fontScale, DocumentData documentData, Canvas canvas, int indexInDocument, int parentAlpha) {
        this.configurePaint(documentData, parentAlpha, indexInDocument);
        List<ContentGroup> contentGroups = this.getContentsForCharacter(character);
        for (int j = 0; j < contentGroups.size(); ++j) {
            Path path = contentGroups.get(j).getPath();
            path.computeBounds(this.rectF, false);
            this.matrix.reset();
            this.matrix.preTranslate(0.0f, -documentData.baselineShift * Utils.dpScale());
            this.matrix.preScale(fontScale, fontScale);
            path.transform(this.matrix);
            if (documentData.strokeOverFill) {
                this.drawGlyph(path, this.fillPaint, canvas);
                this.drawGlyph(path, this.strokePaint, canvas);
                continue;
            }
            this.drawGlyph(path, this.strokePaint, canvas);
            this.drawGlyph(path, this.fillPaint, canvas);
        }
    }

    private void drawGlyph(Path path, Paint paint, Canvas canvas) {
        if (paint.getColor() == 0) {
            return;
        }
        if (paint.getStyle() == Paint.Style.STROKE && paint.getStrokeWidth() == 0.0f) {
            return;
        }
        canvas.drawPath(path, paint);
    }

    private void drawCharacterFromFont(String character, DocumentData documentData, Canvas canvas, int indexInDocument, int parentAlpha) {
        this.configurePaint(documentData, parentAlpha, indexInDocument);
        if (documentData.strokeOverFill) {
            this.drawCharacter(character, this.fillPaint, canvas);
            this.drawCharacter(character, this.strokePaint, canvas);
        } else {
            this.drawCharacter(character, this.strokePaint, canvas);
            this.drawCharacter(character, this.fillPaint, canvas);
        }
    }

    private void drawCharacter(String character, Paint paint, Canvas canvas) {
        if (paint.getColor() == 0) {
            return;
        }
        if (paint.getStyle() == Paint.Style.STROKE && paint.getStrokeWidth() == 0.0f) {
            return;
        }
        canvas.drawText(character, 0, character.length(), 0.0f, 0.0f, paint);
    }

    private List<ContentGroup> getContentsForCharacter(FontCharacter character) {
        if (this.contentsForCharacter.containsKey(character)) {
            return this.contentsForCharacter.get(character);
        }
        List<ShapeGroup> shapes = character.getShapes();
        int size = shapes.size();
        ArrayList<ContentGroup> contents = new ArrayList<ContentGroup>(size);
        for (int i = 0; i < size; ++i) {
            ShapeGroup sg = shapes.get(i);
            contents.add(new ContentGroup(this.lottieDrawable, this, sg, this.composition));
        }
        this.contentsForCharacter.put(character, contents);
        return contents;
    }

    private String codePointToString(String text, int startIndex) {
        int codePoint;
        int nextCodePoint;
        int index;
        int nextCodePointLength;
        int firstCodePoint = text.codePointAt(startIndex);
        int firstCodePointLength = Character.charCount(firstCodePoint);
        int key = firstCodePoint;
        for (index = startIndex + firstCodePointLength; index < text.length() && this.isModifier(nextCodePoint = text.codePointAt(index)); index += nextCodePointLength) {
            nextCodePointLength = Character.charCount(nextCodePoint);
            key = key * 31 + nextCodePoint;
        }
        if (this.codePointCache.containsKey((long)key)) {
            return (String)this.codePointCache.get((long)key);
        }
        this.stringBuilder.setLength(0);
        for (int i = startIndex; i < index; i += Character.charCount(codePoint)) {
            codePoint = text.codePointAt(i);
            this.stringBuilder.appendCodePoint(codePoint);
        }
        String str = this.stringBuilder.toString();
        this.codePointCache.put((long)key, (Object)str);
        return str;
    }

    private boolean isModifier(int codePoint) {
        return Character.getType(codePoint) == 16 || Character.getType(codePoint) == 27 || Character.getType(codePoint) == 6 || Character.getType(codePoint) == 28 || Character.getType(codePoint) == 8 || Character.getType(codePoint) == 19;
    }

    @Override
    public <T> void addValueCallback(T property, @Nullable LottieValueCallback<T> callback) {
        super.addValueCallback(property, callback);
        if (property == LottieProperty.COLOR) {
            if (this.colorCallbackAnimation != null) {
                this.removeAnimation(this.colorCallbackAnimation);
            }
            if (callback == null) {
                this.colorCallbackAnimation = null;
            } else {
                this.colorCallbackAnimation = new ValueCallbackKeyframeAnimation<Integer, T>(callback);
                this.colorCallbackAnimation.addUpdateListener(this);
                this.addAnimation(this.colorCallbackAnimation);
            }
        } else if (property == LottieProperty.STROKE_COLOR) {
            if (this.strokeColorCallbackAnimation != null) {
                this.removeAnimation(this.strokeColorCallbackAnimation);
            }
            if (callback == null) {
                this.strokeColorCallbackAnimation = null;
            } else {
                this.strokeColorCallbackAnimation = new ValueCallbackKeyframeAnimation<Integer, T>(callback);
                this.strokeColorCallbackAnimation.addUpdateListener(this);
                this.addAnimation(this.strokeColorCallbackAnimation);
            }
        } else if (property == LottieProperty.STROKE_WIDTH) {
            if (this.strokeWidthCallbackAnimation != null) {
                this.removeAnimation(this.strokeWidthCallbackAnimation);
            }
            if (callback == null) {
                this.strokeWidthCallbackAnimation = null;
            } else {
                this.strokeWidthCallbackAnimation = new ValueCallbackKeyframeAnimation<Float, T>(callback);
                this.strokeWidthCallbackAnimation.addUpdateListener(this);
                this.addAnimation(this.strokeWidthCallbackAnimation);
            }
        } else if (property == LottieProperty.TEXT_TRACKING) {
            if (this.trackingCallbackAnimation != null) {
                this.removeAnimation(this.trackingCallbackAnimation);
            }
            if (callback == null) {
                this.trackingCallbackAnimation = null;
            } else {
                this.trackingCallbackAnimation = new ValueCallbackKeyframeAnimation<Float, T>(callback);
                this.trackingCallbackAnimation.addUpdateListener(this);
                this.addAnimation(this.trackingCallbackAnimation);
            }
        } else if (property == LottieProperty.TEXT_SIZE) {
            if (this.textSizeCallbackAnimation != null) {
                this.removeAnimation(this.textSizeCallbackAnimation);
            }
            if (callback == null) {
                this.textSizeCallbackAnimation = null;
            } else {
                this.textSizeCallbackAnimation = new ValueCallbackKeyframeAnimation<Float, T>(callback);
                this.textSizeCallbackAnimation.addUpdateListener(this);
                this.addAnimation(this.textSizeCallbackAnimation);
            }
        } else if (property == LottieProperty.TYPEFACE) {
            if (this.typefaceCallbackAnimation != null) {
                this.removeAnimation(this.typefaceCallbackAnimation);
            }
            if (callback == null) {
                this.typefaceCallbackAnimation = null;
            } else {
                this.typefaceCallbackAnimation = new ValueCallbackKeyframeAnimation<Typeface, String>(callback);
                this.typefaceCallbackAnimation.addUpdateListener(this);
                this.addAnimation(this.typefaceCallbackAnimation);
            }
        } else if (property == LottieProperty.TEXT) {
            this.textAnimation.setStringValueCallback(callback);
        }
    }

    private static class TextSubLine {
        private String text = "";
        private float width = 0.0f;

        private TextSubLine() {
        }

        void set(String text, float width) {
            this.text = text;
            this.width = width;
        }
    }
}

