/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.parser;

import android.graphics.Color;
import com.airbnb.lottie.model.content.GradientColor;
import com.airbnb.lottie.parser.ValueParser;
import com.airbnb.lottie.parser.moshi.JsonReader;
import com.airbnb.lottie.utils.GammaEvaluator;
import com.airbnb.lottie.utils.MiscUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GradientColorParser
implements ValueParser<GradientColor> {
    private int colorPoints;

    public GradientColorParser(int colorPoints) {
        this.colorPoints = colorPoints;
    }

    @Override
    public GradientColor parse(JsonReader reader, float scale) throws IOException {
        boolean isArray;
        ArrayList<Float> array = new ArrayList<Float>();
        boolean bl = isArray = reader.peek() == JsonReader.Token.BEGIN_ARRAY;
        if (isArray) {
            reader.beginArray();
        }
        while (reader.hasNext()) {
            array.add(Float.valueOf((float)reader.nextDouble()));
        }
        if (array.size() == 4 && ((Float)array.get(0)).floatValue() == 1.0f) {
            array.set(0, Float.valueOf(0.0f));
            array.add(Float.valueOf(1.0f));
            array.add((Float)array.get(1));
            array.add((Float)array.get(2));
            array.add((Float)array.get(3));
            this.colorPoints = 2;
        }
        if (isArray) {
            reader.endArray();
        }
        if (this.colorPoints == -1) {
            this.colorPoints = array.size() / 4;
        }
        float[] positions = new float[this.colorPoints];
        int[] colors = new int[this.colorPoints];
        int r = 0;
        int g = 0;
        block7: for (int i = 0; i < this.colorPoints * 4; ++i) {
            int colorIndex = i / 4;
            double value = ((Float)array.get(i)).floatValue();
            switch (i % 4) {
                case 0: {
                    if (colorIndex > 0 && positions[colorIndex - 1] >= (float)value) {
                        positions[colorIndex] = (float)value + 0.01f;
                        continue block7;
                    }
                    positions[colorIndex] = (float)value;
                    continue block7;
                }
                case 1: {
                    r = (int)(value * 255.0);
                    continue block7;
                }
                case 2: {
                    g = (int)(value * 255.0);
                    continue block7;
                }
                case 3: {
                    int b = (int)(value * 255.0);
                    colors[colorIndex] = Color.argb((int)255, (int)r, (int)g, (int)b);
                }
            }
        }
        GradientColor gradientColor = new GradientColor(positions, colors);
        gradientColor = this.addOpacityStopsToGradientIfNeeded(gradientColor, array);
        return gradientColor;
    }

    private GradientColor addOpacityStopsToGradientIfNeeded(GradientColor gradientColor, List<Float> array) {
        int startIndex = this.colorPoints * 4;
        if (array.size() <= startIndex) {
            return gradientColor;
        }
        float[] colorStopPositions = gradientColor.getPositions();
        int[] colorStopColors = gradientColor.getColors();
        int opacityStops = (array.size() - startIndex) / 2;
        float[] opacityStopPositions = new float[opacityStops];
        float[] opacityStopOpacities = new float[opacityStops];
        int j = 0;
        for (int i = startIndex; i < array.size(); ++i) {
            if (i % 2 == 0) {
                opacityStopPositions[j] = array.get(i).floatValue();
                continue;
            }
            opacityStopOpacities[j] = array.get(i).floatValue();
            ++j;
        }
        float[] newPositions = GradientColorParser.mergeUniqueElements(gradientColor.getPositions(), opacityStopPositions);
        int newColorPoints = newPositions.length;
        int[] newColors = new int[newColorPoints];
        for (int i = 0; i < newColorPoints; ++i) {
            float position = newPositions[i];
            int colorStopIndex = Arrays.binarySearch(colorStopPositions, position);
            int opacityIndex = Arrays.binarySearch(opacityStopPositions, position);
            if (colorStopIndex < 0 || opacityIndex > 0) {
                if (opacityIndex < 0) {
                    opacityIndex = -(opacityIndex + 1);
                }
                newColors[i] = this.getColorInBetweenColorStops(position, opacityStopOpacities[opacityIndex], colorStopPositions, colorStopColors);
                continue;
            }
            newColors[i] = this.getColorInBetweenOpacityStops(position, colorStopColors[colorStopIndex], opacityStopPositions, opacityStopOpacities);
        }
        return new GradientColor(newPositions, newColors);
    }

    int getColorInBetweenColorStops(float position, float opacity, float[] colorStopPositions, int[] colorStopColors) {
        if (colorStopColors.length < 2 || position == colorStopPositions[0]) {
            return colorStopColors[0];
        }
        for (int i = 1; i < colorStopPositions.length; ++i) {
            float colorStopPosition = colorStopPositions[i];
            if (colorStopPosition < position && i != colorStopPositions.length - 1) continue;
            if (i == colorStopPositions.length - 1 && position >= colorStopPosition) {
                return Color.argb((int)((int)(opacity * 255.0f)), (int)Color.red((int)colorStopColors[i]), (int)Color.green((int)colorStopColors[i]), (int)Color.blue((int)colorStopColors[i]));
            }
            float distanceBetweenColors = colorStopPositions[i] - colorStopPositions[i - 1];
            float distanceToLowerColor = position - colorStopPositions[i - 1];
            float percentage = distanceToLowerColor / distanceBetweenColors;
            int upperColor = colorStopColors[i];
            int lowerColor = colorStopColors[i - 1];
            int intermediateColor = GammaEvaluator.evaluate(percentage, lowerColor, upperColor);
            int a = (int)(opacity * 255.0f);
            int r = Color.red((int)intermediateColor);
            int g = Color.green((int)intermediateColor);
            int b = Color.blue((int)intermediateColor);
            return Color.argb((int)a, (int)r, (int)g, (int)b);
        }
        throw new IllegalArgumentException("Unreachable code.");
    }

    private int getColorInBetweenOpacityStops(float position, int color, float[] opacityStopPositions, float[] opacityStopOpacities) {
        if (opacityStopOpacities.length < 2 || position <= opacityStopPositions[0]) {
            int a = (int)(opacityStopOpacities[0] * 255.0f);
            int r = Color.red((int)color);
            int g = Color.green((int)color);
            int b = Color.blue((int)color);
            return Color.argb((int)a, (int)r, (int)g, (int)b);
        }
        for (int i = 1; i < opacityStopPositions.length; ++i) {
            int a;
            float opacityStopPosition = opacityStopPositions[i];
            if (opacityStopPosition < position && i != opacityStopPositions.length - 1) continue;
            if (opacityStopPosition <= position) {
                a = (int)(opacityStopOpacities[i] * 255.0f);
            } else {
                float distanceBetweenOpacities = opacityStopPositions[i] - opacityStopPositions[i - 1];
                float distanceToLowerOpacity = position - opacityStopPositions[i - 1];
                float percentage = distanceToLowerOpacity / distanceBetweenOpacities;
                a = (int)(MiscUtils.lerp(opacityStopOpacities[i - 1], opacityStopOpacities[i], percentage) * 255.0f);
            }
            int r = Color.red((int)color);
            int g = Color.green((int)color);
            int b = Color.blue((int)color);
            return Color.argb((int)a, (int)r, (int)g, (int)b);
        }
        throw new IllegalArgumentException("Unreachable code.");
    }

    protected static float[] mergeUniqueElements(float[] arrayA, float[] arrayB) {
        if (arrayA.length == 0) {
            return arrayB;
        }
        if (arrayB.length == 0) {
            return arrayA;
        }
        int aIndex = 0;
        int bIndex = 0;
        int numDuplicates = 0;
        float[] mergedNotTruncated = new float[arrayA.length + arrayB.length];
        for (int i = 0; i < mergedNotTruncated.length; ++i) {
            float b;
            float a = aIndex < arrayA.length ? arrayA[aIndex] : Float.NaN;
            float f = b = bIndex < arrayB.length ? arrayB[bIndex] : Float.NaN;
            if (Float.isNaN(b) || a < b) {
                mergedNotTruncated[i] = a;
                ++aIndex;
                continue;
            }
            if (Float.isNaN(a) || b < a) {
                mergedNotTruncated[i] = b;
                ++bIndex;
                continue;
            }
            mergedNotTruncated[i] = a;
            ++aIndex;
            ++bIndex;
            ++numDuplicates;
        }
        if (numDuplicates == 0) {
            return mergedNotTruncated;
        }
        return Arrays.copyOf(mergedNotTruncated, mergedNotTruncated.length - numDuplicates);
    }
}

