/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.aigc.videosynthesis;

import com.alibaba.dashscope.base.HalfDuplexServiceParam;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.utils.GsonExclude;
import com.alibaba.dashscope.utils.JsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.NonNull;

public class VideoSynthesisParam
extends HalfDuplexServiceParam {
    private String size;
    private Integer steps;
    private Integer seed;
    @NonNull
    private String prompt;
    private String negative_prompt;
    private String template;
    private Boolean extendPrompt;
    private String imgUrl;
    @GsonExclude
    protected Map<String, Object> extraInputs;
    private Integer duration;

    public JsonObject getInput() {
        JsonObject jsonObject = new JsonObject();
        this.prompt = this.prompt.trim();
        int maxLength = 500;
        if (this.prompt.length() > maxLength) {
            this.prompt = this.prompt.substring(0, maxLength);
        }
        jsonObject.addProperty("prompt", this.prompt);
        jsonObject.addProperty("extend_prompt", this.extendPrompt);
        if (this.negative_prompt != null && !this.negative_prompt.isEmpty()) {
            jsonObject.addProperty("negative_prompt", this.negative_prompt);
        }
        if (this.template != null && !this.template.isEmpty()) {
            jsonObject.addProperty("template", this.template);
        }
        if (this.imgUrl != null && !this.imgUrl.isEmpty()) {
            jsonObject.addProperty("img_url", this.imgUrl);
        }
        if (this.extraInputs != null && !this.extraInputs.isEmpty()) {
            JsonObject extraInputsJsonObject = JsonUtils.parametersToJsonObject(this.extraInputs);
            JsonUtils.merge(jsonObject, extraInputsJsonObject);
        }
        return jsonObject;
    }

    @Override
    public Map<String, Object> getParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("duration", this.duration);
        params.put("size", this.size);
        if (this.steps != null) {
            params.put("steps", this.steps);
        }
        if (this.seed != null) {
            params.put("seed", this.seed);
        }
        params.putAll(super.getParameters());
        return params;
    }

    @Override
    public JsonObject getHttpBody() {
        JsonObject body = new JsonObject();
        body.addProperty("model", this.getModel());
        body.add("input", (JsonElement)this.getInput());
        if (this.getParameters() != null) {
            body.add("parameters", (JsonElement)JsonUtils.parametersToJsonObject(this.getParameters()));
        }
        return body;
    }

    @Override
    public ByteBuffer getBinaryData() {
        throw new UnsupportedOperationException("Unimplemented method 'getBinaryData'");
    }

    @Override
    public void validate() throws InputRequiredException {
    }

    private static String $default$size() {
        return "1280*720";
    }

    private static Integer $default$steps() {
        return null;
    }

    private static Integer $default$seed() {
        return null;
    }

    private static String $default$negative_prompt() {
        return null;
    }

    private static String $default$template() {
        return null;
    }

    private static Boolean $default$extendPrompt() {
        return Boolean.TRUE;
    }

    private static String $default$imgUrl() {
        return null;
    }

    private static Integer $default$duration() {
        return 5;
    }

    protected VideoSynthesisParam(VideoSynthesisParamBuilder<?, ?> b) {
        super((HalfDuplexServiceParam.HalfDuplexServiceParamBuilder<?, ?>)b);
        Map<Object, Object> extraInputs;
        this.size = ((VideoSynthesisParamBuilder)b).size$set ? ((VideoSynthesisParamBuilder)b).size$value : VideoSynthesisParam.$default$size();
        this.steps = ((VideoSynthesisParamBuilder)b).steps$set ? ((VideoSynthesisParamBuilder)b).steps$value : VideoSynthesisParam.$default$steps();
        this.seed = ((VideoSynthesisParamBuilder)b).seed$set ? ((VideoSynthesisParamBuilder)b).seed$value : VideoSynthesisParam.$default$seed();
        this.prompt = ((VideoSynthesisParamBuilder)b).prompt;
        if (this.prompt == null) {
            throw new NullPointerException("prompt is marked non-null but is null");
        }
        this.negative_prompt = ((VideoSynthesisParamBuilder)b).negative_prompt$set ? ((VideoSynthesisParamBuilder)b).negative_prompt$value : VideoSynthesisParam.$default$negative_prompt();
        this.template = ((VideoSynthesisParamBuilder)b).template$set ? ((VideoSynthesisParamBuilder)b).template$value : VideoSynthesisParam.$default$template();
        this.extendPrompt = ((VideoSynthesisParamBuilder)b).extendPrompt$set ? ((VideoSynthesisParamBuilder)b).extendPrompt$value : VideoSynthesisParam.$default$extendPrompt();
        this.imgUrl = ((VideoSynthesisParamBuilder)b).imgUrl$set ? ((VideoSynthesisParamBuilder)b).imgUrl$value : VideoSynthesisParam.$default$imgUrl();
        switch (((VideoSynthesisParamBuilder)b).extraInputs$key == null ? 0 : ((VideoSynthesisParamBuilder)b).extraInputs$key.size()) {
            case 0: {
                extraInputs = Collections.emptyMap();
                break;
            }
            case 1: {
                extraInputs = Collections.singletonMap(((VideoSynthesisParamBuilder)b).extraInputs$key.get(0), ((VideoSynthesisParamBuilder)b).extraInputs$value.get(0));
                break;
            }
            default: {
                extraInputs = new LinkedHashMap(((VideoSynthesisParamBuilder)b).extraInputs$key.size() < 0x40000000 ? 1 + ((VideoSynthesisParamBuilder)b).extraInputs$key.size() + (((VideoSynthesisParamBuilder)b).extraInputs$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < ((VideoSynthesisParamBuilder)b).extraInputs$key.size(); ++$i) {
                    extraInputs.put(((VideoSynthesisParamBuilder)b).extraInputs$key.get($i), ((VideoSynthesisParamBuilder)b).extraInputs$value.get($i));
                }
                extraInputs = Collections.unmodifiableMap(extraInputs);
            }
        }
        this.extraInputs = extraInputs;
        this.duration = ((VideoSynthesisParamBuilder)b).duration$set ? ((VideoSynthesisParamBuilder)b).duration$value : VideoSynthesisParam.$default$duration();
    }

    public static VideoSynthesisParamBuilder<?, ?> builder() {
        return new VideoSynthesisParamBuilderImpl();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VideoSynthesisParam)) {
            return false;
        }
        VideoSynthesisParam other = (VideoSynthesisParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$steps = this.getSteps();
        Integer other$steps = other.getSteps();
        if (this$steps == null ? other$steps != null : !((Object)this$steps).equals(other$steps)) {
            return false;
        }
        Integer this$seed = this.getSeed();
        Integer other$seed = other.getSeed();
        if (this$seed == null ? other$seed != null : !((Object)this$seed).equals(other$seed)) {
            return false;
        }
        Boolean this$extendPrompt = this.getExtendPrompt();
        Boolean other$extendPrompt = other.getExtendPrompt();
        if (this$extendPrompt == null ? other$extendPrompt != null : !((Object)this$extendPrompt).equals(other$extendPrompt)) {
            return false;
        }
        Integer this$duration = this.getDuration();
        Integer other$duration = other.getDuration();
        if (this$duration == null ? other$duration != null : !((Object)this$duration).equals(other$duration)) {
            return false;
        }
        String this$size = this.getSize();
        String other$size = other.getSize();
        if (this$size == null ? other$size != null : !this$size.equals(other$size)) {
            return false;
        }
        String this$prompt = this.getPrompt();
        String other$prompt = other.getPrompt();
        if (this$prompt == null ? other$prompt != null : !this$prompt.equals(other$prompt)) {
            return false;
        }
        String this$negative_prompt = this.getNegative_prompt();
        String other$negative_prompt = other.getNegative_prompt();
        if (this$negative_prompt == null ? other$negative_prompt != null : !this$negative_prompt.equals(other$negative_prompt)) {
            return false;
        }
        String this$template = this.getTemplate();
        String other$template = other.getTemplate();
        if (this$template == null ? other$template != null : !this$template.equals(other$template)) {
            return false;
        }
        String this$imgUrl = this.getImgUrl();
        String other$imgUrl = other.getImgUrl();
        if (this$imgUrl == null ? other$imgUrl != null : !this$imgUrl.equals(other$imgUrl)) {
            return false;
        }
        Map<String, Object> this$extraInputs = this.getExtraInputs();
        Map<String, Object> other$extraInputs = other.getExtraInputs();
        return !(this$extraInputs == null ? other$extraInputs != null : !((Object)this$extraInputs).equals(other$extraInputs));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof VideoSynthesisParam;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $steps = this.getSteps();
        result = result * 59 + ($steps == null ? 43 : ((Object)$steps).hashCode());
        Integer $seed = this.getSeed();
        result = result * 59 + ($seed == null ? 43 : ((Object)$seed).hashCode());
        Boolean $extendPrompt = this.getExtendPrompt();
        result = result * 59 + ($extendPrompt == null ? 43 : ((Object)$extendPrompt).hashCode());
        Integer $duration = this.getDuration();
        result = result * 59 + ($duration == null ? 43 : ((Object)$duration).hashCode());
        String $size = this.getSize();
        result = result * 59 + ($size == null ? 43 : $size.hashCode());
        String $prompt = this.getPrompt();
        result = result * 59 + ($prompt == null ? 43 : $prompt.hashCode());
        String $negative_prompt = this.getNegative_prompt();
        result = result * 59 + ($negative_prompt == null ? 43 : $negative_prompt.hashCode());
        String $template = this.getTemplate();
        result = result * 59 + ($template == null ? 43 : $template.hashCode());
        String $imgUrl = this.getImgUrl();
        result = result * 59 + ($imgUrl == null ? 43 : $imgUrl.hashCode());
        Map<String, Object> $extraInputs = this.getExtraInputs();
        result = result * 59 + ($extraInputs == null ? 43 : ((Object)$extraInputs).hashCode());
        return result;
    }

    public String getSize() {
        return this.size;
    }

    public Integer getSteps() {
        return this.steps;
    }

    public Integer getSeed() {
        return this.seed;
    }

    @NonNull
    public String getPrompt() {
        return this.prompt;
    }

    public String getNegative_prompt() {
        return this.negative_prompt;
    }

    public String getTemplate() {
        return this.template;
    }

    public Boolean getExtendPrompt() {
        return this.extendPrompt;
    }

    public String getImgUrl() {
        return this.imgUrl;
    }

    public Map<String, Object> getExtraInputs() {
        return this.extraInputs;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public void setSteps(Integer steps) {
        this.steps = steps;
    }

    public void setSeed(Integer seed) {
        this.seed = seed;
    }

    public void setPrompt(@NonNull String prompt) {
        if (prompt == null) {
            throw new NullPointerException("prompt is marked non-null but is null");
        }
        this.prompt = prompt;
    }

    public void setNegative_prompt(String negative_prompt) {
        this.negative_prompt = negative_prompt;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void setExtendPrompt(Boolean extendPrompt) {
        this.extendPrompt = extendPrompt;
    }

    public void setImgUrl(String imgUrl) {
        this.imgUrl = imgUrl;
    }

    public void setExtraInputs(Map<String, Object> extraInputs) {
        this.extraInputs = extraInputs;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    @Override
    public String toString() {
        return "VideoSynthesisParam(size=" + this.getSize() + ", steps=" + this.getSteps() + ", seed=" + this.getSeed() + ", prompt=" + this.getPrompt() + ", negative_prompt=" + this.getNegative_prompt() + ", template=" + this.getTemplate() + ", extendPrompt=" + this.getExtendPrompt() + ", imgUrl=" + this.getImgUrl() + ", extraInputs=" + this.getExtraInputs() + ", duration=" + this.getDuration() + ")";
    }

    private static final class VideoSynthesisParamBuilderImpl
    extends VideoSynthesisParamBuilder<VideoSynthesisParam, VideoSynthesisParamBuilderImpl> {
        private VideoSynthesisParamBuilderImpl() {
        }

        @Override
        protected VideoSynthesisParamBuilderImpl self() {
            return this;
        }

        @Override
        public VideoSynthesisParam build() {
            return new VideoSynthesisParam(this);
        }
    }

    public static abstract class VideoSynthesisParamBuilder<C extends VideoSynthesisParam, B extends VideoSynthesisParamBuilder<C, B>>
    extends HalfDuplexServiceParam.HalfDuplexServiceParamBuilder<C, B> {
        private boolean size$set;
        private String size$value;
        private boolean steps$set;
        private Integer steps$value;
        private boolean seed$set;
        private Integer seed$value;
        private String prompt;
        private boolean negative_prompt$set;
        private String negative_prompt$value;
        private boolean template$set;
        private String template$value;
        private boolean extendPrompt$set;
        private Boolean extendPrompt$value;
        private boolean imgUrl$set;
        private String imgUrl$value;
        private ArrayList<String> extraInputs$key;
        private ArrayList<Object> extraInputs$value;
        private boolean duration$set;
        private Integer duration$value;

        public B size(String size) {
            this.size$value = size;
            this.size$set = true;
            return (B)this.self();
        }

        public B steps(Integer steps) {
            this.steps$value = steps;
            this.steps$set = true;
            return (B)this.self();
        }

        public B seed(Integer seed) {
            this.seed$value = seed;
            this.seed$set = true;
            return (B)this.self();
        }

        public B prompt(@NonNull String prompt) {
            if (prompt == null) {
                throw new NullPointerException("prompt is marked non-null but is null");
            }
            this.prompt = prompt;
            return (B)this.self();
        }

        public B negative_prompt(String negative_prompt) {
            this.negative_prompt$value = negative_prompt;
            this.negative_prompt$set = true;
            return (B)this.self();
        }

        public B template(String template) {
            this.template$value = template;
            this.template$set = true;
            return (B)this.self();
        }

        public B extendPrompt(Boolean extendPrompt) {
            this.extendPrompt$value = extendPrompt;
            this.extendPrompt$set = true;
            return (B)this.self();
        }

        public B imgUrl(String imgUrl) {
            this.imgUrl$value = imgUrl;
            this.imgUrl$set = true;
            return (B)this.self();
        }

        public B extraInput(String extraInputKey, Object extraInputValue) {
            if (this.extraInputs$key == null) {
                this.extraInputs$key = new ArrayList();
                this.extraInputs$value = new ArrayList();
            }
            this.extraInputs$key.add(extraInputKey);
            this.extraInputs$value.add(extraInputValue);
            return (B)this.self();
        }

        public B extraInputs(Map<? extends String, ? extends Object> extraInputs) {
            if (extraInputs == null) {
                throw new NullPointerException("extraInputs cannot be null");
            }
            if (this.extraInputs$key == null) {
                this.extraInputs$key = new ArrayList();
                this.extraInputs$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : extraInputs.entrySet()) {
                this.extraInputs$key.add($lombokEntry.getKey());
                this.extraInputs$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        public B clearExtraInputs() {
            if (this.extraInputs$key != null) {
                this.extraInputs$key.clear();
                this.extraInputs$value.clear();
            }
            return (B)this.self();
        }

        public B duration(Integer duration) {
            this.duration$value = duration;
            this.duration$set = true;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "VideoSynthesisParam.VideoSynthesisParamBuilder(super=" + super.toString() + ", size$value=" + this.size$value + ", steps$value=" + this.steps$value + ", seed$value=" + this.seed$value + ", prompt=" + this.prompt + ", negative_prompt$value=" + this.negative_prompt$value + ", template$value=" + this.template$value + ", extendPrompt$value=" + this.extendPrompt$value + ", imgUrl$value=" + this.imgUrl$value + ", extraInputs$key=" + this.extraInputs$key + ", extraInputs$value=" + this.extraInputs$value + ", duration$value=" + this.duration$value + ")";
        }
    }
}

